/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSecondarySubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecondarySubnetsResponse;
import software.amazon.awssdk.services.ec2.model.SecondarySubnet;

public class DescribeSecondarySubnetsIterable
implements SdkIterable<DescribeSecondarySubnetsResponse> {
    private final Ec2Client client;
    private final DescribeSecondarySubnetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSecondarySubnetsIterable(Ec2Client client, DescribeSecondarySubnetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSecondarySubnetsResponseFetcher();
    }

    public Iterator<DescribeSecondarySubnetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecondarySubnet> secondarySubnets() {
        Function<DescribeSecondarySubnetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.secondarySubnets() != null) {
                return response.secondarySubnets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSecondarySubnetsResponseFetcher
    implements SyncPageFetcher<DescribeSecondarySubnetsResponse> {
        private DescribeSecondarySubnetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSecondarySubnetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSecondarySubnetsResponse nextPage(DescribeSecondarySubnetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSecondarySubnetsIterable.this.client.describeSecondarySubnets(DescribeSecondarySubnetsIterable.this.firstRequest);
            }
            return DescribeSecondarySubnetsIterable.this.client.describeSecondarySubnets((DescribeSecondarySubnetsRequest)((Object)DescribeSecondarySubnetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

