/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.SecondaryInterfaceAttachment;
import software.amazon.awssdk.services.ec2.model.SecondaryInterfaceIpv4Address;
import software.amazon.awssdk.services.ec2.model.SecondaryInterfaceIpv4AddressListCopier;
import software.amazon.awssdk.services.ec2.model.SecondaryInterfaceStatus;
import software.amazon.awssdk.services.ec2.model.SecondaryInterfaceType;
import software.amazon.awssdk.services.ec2.model.SecondaryNetworkType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecondaryInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecondaryInterface> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(SecondaryInterface.getter(SecondaryInterface::availabilityZone)).setter(SecondaryInterface.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(SecondaryInterface.getter(SecondaryInterface::availabilityZoneId)).setter(SecondaryInterface.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final SdkField<SecondaryInterfaceAttachment> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(SecondaryInterface.getter(SecondaryInterface::attachment)).setter(SecondaryInterface.setter(Builder::attachment)).constructor(SecondaryInterfaceAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").unmarshallLocationName("attachment").build()}).build();
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacAddress").getter(SecondaryInterface.getter(SecondaryInterface::macAddress)).setter(SecondaryInterface.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress").unmarshallLocationName("macAddress").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(SecondaryInterface.getter(SecondaryInterface::ownerId)).setter(SecondaryInterface.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<List<SecondaryInterfaceIpv4Address>> PRIVATE_IPV4_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpv4Addresses").getter(SecondaryInterface.getter(SecondaryInterface::privateIpv4Addresses)).setter(SecondaryInterface.setter(Builder::privateIpv4Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpv4AddressSet").unmarshallLocationName("privateIpv4AddressSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecondaryInterfaceIpv4Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> SECONDARY_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryInterfaceId").getter(SecondaryInterface.getter(SecondaryInterface::secondaryInterfaceId)).setter(SecondaryInterface.setter(Builder::secondaryInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryInterfaceId").unmarshallLocationName("secondaryInterfaceId").build()}).build();
    private static final SdkField<String> SECONDARY_INTERFACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryInterfaceArn").getter(SecondaryInterface.getter(SecondaryInterface::secondaryInterfaceArn)).setter(SecondaryInterface.setter(Builder::secondaryInterfaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryInterfaceArn").unmarshallLocationName("secondaryInterfaceArn").build()}).build();
    private static final SdkField<String> SECONDARY_INTERFACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryInterfaceType").getter(SecondaryInterface.getter(SecondaryInterface::secondaryInterfaceTypeAsString)).setter(SecondaryInterface.setter(Builder::secondaryInterfaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryInterfaceType").unmarshallLocationName("secondaryInterfaceType").build()}).build();
    private static final SdkField<String> SECONDARY_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondarySubnetId").getter(SecondaryInterface.getter(SecondaryInterface::secondarySubnetId)).setter(SecondaryInterface.setter(Builder::secondarySubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondarySubnetId").unmarshallLocationName("secondarySubnetId").build()}).build();
    private static final SdkField<String> SECONDARY_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryNetworkId").getter(SecondaryInterface.getter(SecondaryInterface::secondaryNetworkId)).setter(SecondaryInterface.setter(Builder::secondaryNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkId").unmarshallLocationName("secondaryNetworkId").build()}).build();
    private static final SdkField<String> SECONDARY_NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryNetworkType").getter(SecondaryInterface.getter(SecondaryInterface::secondaryNetworkTypeAsString)).setter(SecondaryInterface.setter(Builder::secondaryNetworkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkType").unmarshallLocationName("secondaryNetworkType").build()}).build();
    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SourceDestCheck").getter(SecondaryInterface.getter(SecondaryInterface::sourceDestCheck)).setter(SecondaryInterface.setter(Builder::sourceDestCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").unmarshallLocationName("sourceDestCheck").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SecondaryInterface.getter(SecondaryInterface::statusAsString)).setter(SecondaryInterface.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SecondaryInterface.getter(SecondaryInterface::tags)).setter(SecondaryInterface.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, ATTACHMENT_FIELD, MAC_ADDRESS_FIELD, OWNER_ID_FIELD, PRIVATE_IPV4_ADDRESSES_FIELD, SECONDARY_INTERFACE_ID_FIELD, SECONDARY_INTERFACE_ARN_FIELD, SECONDARY_INTERFACE_TYPE_FIELD, SECONDARY_SUBNET_ID_FIELD, SECONDARY_NETWORK_ID_FIELD, SECONDARY_NETWORK_TYPE_FIELD, SOURCE_DEST_CHECK_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SecondaryInterface.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final SecondaryInterfaceAttachment attachment;
    private final String macAddress;
    private final String ownerId;
    private final List<SecondaryInterfaceIpv4Address> privateIpv4Addresses;
    private final String secondaryInterfaceId;
    private final String secondaryInterfaceArn;
    private final String secondaryInterfaceType;
    private final String secondarySubnetId;
    private final String secondaryNetworkId;
    private final String secondaryNetworkType;
    private final Boolean sourceDestCheck;
    private final String status;
    private final List<Tag> tags;

    private SecondaryInterface(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.attachment = builder.attachment;
        this.macAddress = builder.macAddress;
        this.ownerId = builder.ownerId;
        this.privateIpv4Addresses = builder.privateIpv4Addresses;
        this.secondaryInterfaceId = builder.secondaryInterfaceId;
        this.secondaryInterfaceArn = builder.secondaryInterfaceArn;
        this.secondaryInterfaceType = builder.secondaryInterfaceType;
        this.secondarySubnetId = builder.secondarySubnetId;
        this.secondaryNetworkId = builder.secondaryNetworkId;
        this.secondaryNetworkType = builder.secondaryNetworkType;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final SecondaryInterfaceAttachment attachment() {
        return this.attachment;
    }

    public final String macAddress() {
        return this.macAddress;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final boolean hasPrivateIpv4Addresses() {
        return this.privateIpv4Addresses != null && !(this.privateIpv4Addresses instanceof SdkAutoConstructList);
    }

    public final List<SecondaryInterfaceIpv4Address> privateIpv4Addresses() {
        return this.privateIpv4Addresses;
    }

    public final String secondaryInterfaceId() {
        return this.secondaryInterfaceId;
    }

    public final String secondaryInterfaceArn() {
        return this.secondaryInterfaceArn;
    }

    public final SecondaryInterfaceType secondaryInterfaceType() {
        return SecondaryInterfaceType.fromValue(this.secondaryInterfaceType);
    }

    public final String secondaryInterfaceTypeAsString() {
        return this.secondaryInterfaceType;
    }

    public final String secondarySubnetId() {
        return this.secondarySubnetId;
    }

    public final String secondaryNetworkId() {
        return this.secondaryNetworkId;
    }

    public final SecondaryNetworkType secondaryNetworkType() {
        return SecondaryNetworkType.fromValue(this.secondaryNetworkType);
    }

    public final String secondaryNetworkTypeAsString() {
        return this.secondaryNetworkType;
    }

    public final Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public final SecondaryInterfaceStatus status() {
        return SecondaryInterfaceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateIpv4Addresses() ? this.privateIpv4Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryInterfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondarySubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryNetworkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecondaryInterface)) {
            return false;
        }
        SecondaryInterface other = (SecondaryInterface)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.ownerId(), other.ownerId()) && this.hasPrivateIpv4Addresses() == other.hasPrivateIpv4Addresses() && Objects.equals(this.privateIpv4Addresses(), other.privateIpv4Addresses()) && Objects.equals(this.secondaryInterfaceId(), other.secondaryInterfaceId()) && Objects.equals(this.secondaryInterfaceArn(), other.secondaryInterfaceArn()) && Objects.equals(this.secondaryInterfaceTypeAsString(), other.secondaryInterfaceTypeAsString()) && Objects.equals(this.secondarySubnetId(), other.secondarySubnetId()) && Objects.equals(this.secondaryNetworkId(), other.secondaryNetworkId()) && Objects.equals(this.secondaryNetworkTypeAsString(), other.secondaryNetworkTypeAsString()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SecondaryInterface").add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("Attachment", (Object)this.attachment()).add("MacAddress", (Object)this.macAddress()).add("OwnerId", (Object)this.ownerId()).add("PrivateIpv4Addresses", this.hasPrivateIpv4Addresses() ? this.privateIpv4Addresses() : null).add("SecondaryInterfaceId", (Object)this.secondaryInterfaceId()).add("SecondaryInterfaceArn", (Object)this.secondaryInterfaceArn()).add("SecondaryInterfaceType", (Object)this.secondaryInterfaceTypeAsString()).add("SecondarySubnetId", (Object)this.secondarySubnetId()).add("SecondaryNetworkId", (Object)this.secondaryNetworkId()).add("SecondaryNetworkType", (Object)this.secondaryNetworkTypeAsString()).add("SourceDestCheck", (Object)this.sourceDestCheck()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "MacAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "PrivateIpv4Addresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpv4Addresses()));
            }
            case "SecondaryInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.secondaryInterfaceId()));
            }
            case "SecondaryInterfaceArn": {
                return Optional.ofNullable(clazz.cast(this.secondaryInterfaceArn()));
            }
            case "SecondaryInterfaceType": {
                return Optional.ofNullable(clazz.cast(this.secondaryInterfaceTypeAsString()));
            }
            case "SecondarySubnetId": {
                return Optional.ofNullable(clazz.cast(this.secondarySubnetId()));
            }
            case "SecondaryNetworkId": {
                return Optional.ofNullable(clazz.cast(this.secondaryNetworkId()));
            }
            case "SecondaryNetworkType": {
                return Optional.ofNullable(clazz.cast(this.secondaryNetworkTypeAsString()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("Attachment", ATTACHMENT_FIELD);
        map.put("MacAddress", MAC_ADDRESS_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("PrivateIpv4AddressSet", PRIVATE_IPV4_ADDRESSES_FIELD);
        map.put("SecondaryInterfaceId", SECONDARY_INTERFACE_ID_FIELD);
        map.put("SecondaryInterfaceArn", SECONDARY_INTERFACE_ARN_FIELD);
        map.put("SecondaryInterfaceType", SECONDARY_INTERFACE_TYPE_FIELD);
        map.put("SecondarySubnetId", SECONDARY_SUBNET_ID_FIELD);
        map.put("SecondaryNetworkId", SECONDARY_NETWORK_ID_FIELD);
        map.put("SecondaryNetworkType", SECONDARY_NETWORK_TYPE_FIELD);
        map.put("SourceDestCheck", SOURCE_DEST_CHECK_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecondaryInterface, T> g) {
        return obj -> g.apply((SecondaryInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String availabilityZoneId;
        private SecondaryInterfaceAttachment attachment;
        private String macAddress;
        private String ownerId;
        private List<SecondaryInterfaceIpv4Address> privateIpv4Addresses = DefaultSdkAutoConstructList.getInstance();
        private String secondaryInterfaceId;
        private String secondaryInterfaceArn;
        private String secondaryInterfaceType;
        private String secondarySubnetId;
        private String secondaryNetworkId;
        private String secondaryNetworkType;
        private Boolean sourceDestCheck;
        private String status;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecondaryInterface model) {
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.attachment(model.attachment);
            this.macAddress(model.macAddress);
            this.ownerId(model.ownerId);
            this.privateIpv4Addresses(model.privateIpv4Addresses);
            this.secondaryInterfaceId(model.secondaryInterfaceId);
            this.secondaryInterfaceArn(model.secondaryInterfaceArn);
            this.secondaryInterfaceType(model.secondaryInterfaceType);
            this.secondarySubnetId(model.secondarySubnetId);
            this.secondaryNetworkId(model.secondaryNetworkId);
            this.secondaryNetworkType(model.secondaryNetworkType);
            this.sourceDestCheck(model.sourceDestCheck);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final SecondaryInterfaceAttachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        public final void setAttachment(SecondaryInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(SecondaryInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<SecondaryInterfaceIpv4Address.Builder> getPrivateIpv4Addresses() {
            List<SecondaryInterfaceIpv4Address.Builder> result = SecondaryInterfaceIpv4AddressListCopier.copyToBuilder(this.privateIpv4Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpv4Addresses(Collection<SecondaryInterfaceIpv4Address.BuilderImpl> privateIpv4Addresses) {
            this.privateIpv4Addresses = SecondaryInterfaceIpv4AddressListCopier.copyFromBuilder(privateIpv4Addresses);
        }

        @Override
        public final Builder privateIpv4Addresses(Collection<SecondaryInterfaceIpv4Address> privateIpv4Addresses) {
            this.privateIpv4Addresses = SecondaryInterfaceIpv4AddressListCopier.copy(privateIpv4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpv4Addresses(SecondaryInterfaceIpv4Address ... privateIpv4Addresses) {
            this.privateIpv4Addresses(Arrays.asList(privateIpv4Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpv4Addresses(Consumer<SecondaryInterfaceIpv4Address.Builder> ... privateIpv4Addresses) {
            this.privateIpv4Addresses(Stream.of(privateIpv4Addresses).map(c -> (SecondaryInterfaceIpv4Address)((SecondaryInterfaceIpv4Address.Builder)SecondaryInterfaceIpv4Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSecondaryInterfaceId() {
            return this.secondaryInterfaceId;
        }

        public final void setSecondaryInterfaceId(String secondaryInterfaceId) {
            this.secondaryInterfaceId = secondaryInterfaceId;
        }

        @Override
        public final Builder secondaryInterfaceId(String secondaryInterfaceId) {
            this.secondaryInterfaceId = secondaryInterfaceId;
            return this;
        }

        public final String getSecondaryInterfaceArn() {
            return this.secondaryInterfaceArn;
        }

        public final void setSecondaryInterfaceArn(String secondaryInterfaceArn) {
            this.secondaryInterfaceArn = secondaryInterfaceArn;
        }

        @Override
        public final Builder secondaryInterfaceArn(String secondaryInterfaceArn) {
            this.secondaryInterfaceArn = secondaryInterfaceArn;
            return this;
        }

        public final String getSecondaryInterfaceType() {
            return this.secondaryInterfaceType;
        }

        public final void setSecondaryInterfaceType(String secondaryInterfaceType) {
            this.secondaryInterfaceType = secondaryInterfaceType;
        }

        @Override
        public final Builder secondaryInterfaceType(String secondaryInterfaceType) {
            this.secondaryInterfaceType = secondaryInterfaceType;
            return this;
        }

        @Override
        public final Builder secondaryInterfaceType(SecondaryInterfaceType secondaryInterfaceType) {
            this.secondaryInterfaceType(secondaryInterfaceType == null ? null : secondaryInterfaceType.toString());
            return this;
        }

        public final String getSecondarySubnetId() {
            return this.secondarySubnetId;
        }

        public final void setSecondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
        }

        @Override
        public final Builder secondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
            return this;
        }

        public final String getSecondaryNetworkId() {
            return this.secondaryNetworkId;
        }

        public final void setSecondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
        }

        @Override
        public final Builder secondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
            return this;
        }

        public final String getSecondaryNetworkType() {
            return this.secondaryNetworkType;
        }

        public final void setSecondaryNetworkType(String secondaryNetworkType) {
            this.secondaryNetworkType = secondaryNetworkType;
        }

        @Override
        public final Builder secondaryNetworkType(String secondaryNetworkType) {
            this.secondaryNetworkType = secondaryNetworkType;
            return this;
        }

        @Override
        public final Builder secondaryNetworkType(SecondaryNetworkType secondaryNetworkType) {
            this.secondaryNetworkType(secondaryNetworkType == null ? null : secondaryNetworkType.toString());
            return this;
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SecondaryInterfaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SecondaryInterface build() {
            return new SecondaryInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecondaryInterface> {
        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder attachment(SecondaryInterfaceAttachment var1);

        default public Builder attachment(Consumer<SecondaryInterfaceAttachment.Builder> attachment) {
            return this.attachment((SecondaryInterfaceAttachment)((SecondaryInterfaceAttachment.Builder)SecondaryInterfaceAttachment.builder().applyMutation(attachment)).build());
        }

        public Builder macAddress(String var1);

        public Builder ownerId(String var1);

        public Builder privateIpv4Addresses(Collection<SecondaryInterfaceIpv4Address> var1);

        public Builder privateIpv4Addresses(SecondaryInterfaceIpv4Address ... var1);

        public Builder privateIpv4Addresses(Consumer<SecondaryInterfaceIpv4Address.Builder> ... var1);

        public Builder secondaryInterfaceId(String var1);

        public Builder secondaryInterfaceArn(String var1);

        public Builder secondaryInterfaceType(String var1);

        public Builder secondaryInterfaceType(SecondaryInterfaceType var1);

        public Builder secondarySubnetId(String var1);

        public Builder secondaryNetworkId(String var1);

        public Builder secondaryNetworkType(String var1);

        public Builder secondaryNetworkType(SecondaryNetworkType var1);

        public Builder sourceDestCheck(Boolean var1);

        public Builder status(String var1);

        public Builder status(SecondaryInterfaceStatus var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

