/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SecondarySubnet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSecondarySubnetResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateSecondarySubnetResponse> {
    private static final SdkField<SecondarySubnet> SECONDARY_SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecondarySubnet").getter(CreateSecondarySubnetResponse.getter(CreateSecondarySubnetResponse::secondarySubnet)).setter(CreateSecondarySubnetResponse.setter(Builder::secondarySubnet)).constructor(SecondarySubnet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondarySubnet").unmarshallLocationName("secondarySubnet").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateSecondarySubnetResponse.getter(CreateSecondarySubnetResponse::clientToken)).setter(CreateSecondarySubnetResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECONDARY_SUBNET_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSecondarySubnetResponse.memberNameToFieldInitializer();
    private final SecondarySubnet secondarySubnet;
    private final String clientToken;

    private CreateSecondarySubnetResponse(BuilderImpl builder) {
        super(builder);
        this.secondarySubnet = builder.secondarySubnet;
        this.clientToken = builder.clientToken;
    }

    public final SecondarySubnet secondarySubnet() {
        return this.secondarySubnet;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.secondarySubnet());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecondarySubnetResponse)) {
            return false;
        }
        CreateSecondarySubnetResponse other = (CreateSecondarySubnetResponse)((Object)obj);
        return Objects.equals(this.secondarySubnet(), other.secondarySubnet()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSecondarySubnetResponse").add("SecondarySubnet", (Object)this.secondarySubnet()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecondarySubnet": {
                return Optional.ofNullable(clazz.cast(this.secondarySubnet()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SecondarySubnet", SECONDARY_SUBNET_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSecondarySubnetResponse, T> g) {
        return obj -> g.apply((CreateSecondarySubnetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private SecondarySubnet secondarySubnet;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecondarySubnetResponse model) {
            super(model);
            this.secondarySubnet(model.secondarySubnet);
            this.clientToken(model.clientToken);
        }

        public final SecondarySubnet.Builder getSecondarySubnet() {
            return this.secondarySubnet != null ? this.secondarySubnet.toBuilder() : null;
        }

        public final void setSecondarySubnet(SecondarySubnet.BuilderImpl secondarySubnet) {
            this.secondarySubnet = secondarySubnet != null ? secondarySubnet.build() : null;
        }

        @Override
        public final Builder secondarySubnet(SecondarySubnet secondarySubnet) {
            this.secondarySubnet = secondarySubnet;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public CreateSecondarySubnetResponse build() {
            return new CreateSecondarySubnetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSecondarySubnetResponse> {
        public Builder secondarySubnet(SecondarySubnet var1);

        default public Builder secondarySubnet(Consumer<SecondarySubnet.Builder> secondarySubnet) {
            return this.secondarySubnet((SecondarySubnet)((SecondarySubnet.Builder)SecondarySubnet.builder().applyMutation(secondarySubnet)).build());
        }

        public Builder clientToken(String var1);
    }
}

