/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IPv4 CIDR block associated with a secondary subnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecondarySubnetIpv4CidrBlockAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<SecondarySubnetIpv4CidrBlockAssociation.Builder, SecondarySubnetIpv4CidrBlockAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociationId")
            .getter(getter(SecondarySubnetIpv4CidrBlockAssociation::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId")
                    .unmarshallLocationName("associationId").build()).build();

    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrBlock")
            .getter(getter(SecondarySubnetIpv4CidrBlockAssociation::cidrBlock))
            .setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock")
                    .unmarshallLocationName("cidrBlock").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(SecondarySubnetIpv4CidrBlockAssociation::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateReason")
            .getter(getter(SecondarySubnetIpv4CidrBlockAssociation::stateReason))
            .setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason")
                    .unmarshallLocationName("stateReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            CIDR_BLOCK_FIELD, STATE_FIELD, STATE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String associationId;

    private final String cidrBlock;

    private final String state;

    private final String stateReason;

    private SecondarySubnetIpv4CidrBlockAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.cidrBlock = builder.cidrBlock;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
    }

    /**
     * <p>
     * The association ID for the IPv4 CIDR block.
     * </p>
     * 
     * @return The association ID for the IPv4 CIDR block.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The IPv4 CIDR block.
     * </p>
     * 
     * @return The IPv4 CIDR block.
     */
    public final String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * The state of the CIDR block association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SecondarySubnetCidrBlockAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the CIDR block association.
     * @see SecondarySubnetCidrBlockAssociationState
     */
    public final SecondarySubnetCidrBlockAssociationState state() {
        return SecondarySubnetCidrBlockAssociationState.fromValue(state);
    }

    /**
     * <p>
     * The state of the CIDR block association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SecondarySubnetCidrBlockAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the CIDR block association.
     * @see SecondarySubnetCidrBlockAssociationState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason for the current state of the CIDR block association.
     * </p>
     * 
     * @return The reason for the current state of the CIDR block association.
     */
    public final String stateReason() {
        return stateReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecondarySubnetIpv4CidrBlockAssociation)) {
            return false;
        }
        SecondarySubnetIpv4CidrBlockAssociation other = (SecondarySubnetIpv4CidrBlockAssociation) obj;
        return Objects.equals(associationId(), other.associationId()) && Objects.equals(cidrBlock(), other.cidrBlock())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateReason(), other.stateReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecondarySubnetIpv4CidrBlockAssociation").add("AssociationId", associationId())
                .add("CidrBlock", cidrBlock()).add("State", stateAsString()).add("StateReason", stateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("CidrBlock", CIDR_BLOCK_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecondarySubnetIpv4CidrBlockAssociation, T> g) {
        return obj -> g.apply((SecondarySubnetIpv4CidrBlockAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecondarySubnetIpv4CidrBlockAssociation> {
        /**
         * <p>
         * The association ID for the IPv4 CIDR block.
         * </p>
         * 
         * @param associationId
         *        The association ID for the IPv4 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The IPv4 CIDR block.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * The state of the CIDR block association.
         * </p>
         * 
         * @param state
         *        The state of the CIDR block association.
         * @see SecondarySubnetCidrBlockAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondarySubnetCidrBlockAssociationState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the CIDR block association.
         * </p>
         * 
         * @param state
         *        The state of the CIDR block association.
         * @see SecondarySubnetCidrBlockAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondarySubnetCidrBlockAssociationState
         */
        Builder state(SecondarySubnetCidrBlockAssociationState state);

        /**
         * <p>
         * The reason for the current state of the CIDR block association.
         * </p>
         * 
         * @param stateReason
         *        The reason for the current state of the CIDR block association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String cidrBlock;

        private String state;

        private String stateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SecondarySubnetIpv4CidrBlockAssociation model) {
            associationId(model.associationId);
            cidrBlock(model.cidrBlock);
            state(model.state);
            stateReason(model.stateReason);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SecondarySubnetCidrBlockAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        @Override
        public SecondarySubnetIpv4CidrBlockAssociation build() {
            return new SecondarySubnetIpv4CidrBlockAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
