/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a secondary subnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecondarySubnet implements SdkPojo, Serializable, ToCopyableBuilder<SecondarySubnet.Builder, SecondarySubnet> {
    private static final SdkField<String> SECONDARY_SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondarySubnetId")
            .getter(getter(SecondarySubnet::secondarySubnetId))
            .setter(setter(Builder::secondarySubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondarySubnetId")
                    .unmarshallLocationName("secondarySubnetId").build()).build();

    private static final SdkField<String> SECONDARY_SUBNET_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondarySubnetArn")
            .getter(getter(SecondarySubnet::secondarySubnetArn))
            .setter(setter(Builder::secondarySubnetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondarySubnetArn")
                    .unmarshallLocationName("secondarySubnetArn").build()).build();

    private static final SdkField<String> SECONDARY_NETWORK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondaryNetworkId")
            .getter(getter(SecondarySubnet::secondaryNetworkId))
            .setter(setter(Builder::secondaryNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkId")
                    .unmarshallLocationName("secondaryNetworkId").build()).build();

    private static final SdkField<String> SECONDARY_NETWORK_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondaryNetworkType")
            .getter(getter(SecondarySubnet::secondaryNetworkTypeAsString))
            .setter(setter(Builder::secondaryNetworkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkType")
                    .unmarshallLocationName("secondaryNetworkType").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(SecondarySubnet::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(SecondarySubnet::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("availabilityZoneId").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(SecondarySubnet::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<List<SecondarySubnetIpv4CidrBlockAssociation>> IPV4_CIDR_BLOCK_ASSOCIATIONS_FIELD = SdkField
            .<List<SecondarySubnetIpv4CidrBlockAssociation>> builder(MarshallingType.LIST)
            .memberName("Ipv4CidrBlockAssociations")
            .getter(getter(SecondarySubnet::ipv4CidrBlockAssociations))
            .setter(setter(Builder::ipv4CidrBlockAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4CidrBlockAssociationSet")
                    .unmarshallLocationName("ipv4CidrBlockAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SecondarySubnetIpv4CidrBlockAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecondarySubnetIpv4CidrBlockAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(SecondarySubnet::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateReason")
            .getter(getter(SecondarySubnet::stateReason))
            .setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason")
                    .unmarshallLocationName("stateReason").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(SecondarySubnet::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECONDARY_SUBNET_ID_FIELD,
            SECONDARY_SUBNET_ARN_FIELD, SECONDARY_NETWORK_ID_FIELD, SECONDARY_NETWORK_TYPE_FIELD, OWNER_ID_FIELD,
            AVAILABILITY_ZONE_ID_FIELD, AVAILABILITY_ZONE_FIELD, IPV4_CIDR_BLOCK_ASSOCIATIONS_FIELD, STATE_FIELD,
            STATE_REASON_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String secondarySubnetId;

    private final String secondarySubnetArn;

    private final String secondaryNetworkId;

    private final String secondaryNetworkType;

    private final String ownerId;

    private final String availabilityZoneId;

    private final String availabilityZone;

    private final List<SecondarySubnetIpv4CidrBlockAssociation> ipv4CidrBlockAssociations;

    private final String state;

    private final String stateReason;

    private final List<Tag> tags;

    private SecondarySubnet(BuilderImpl builder) {
        this.secondarySubnetId = builder.secondarySubnetId;
        this.secondarySubnetArn = builder.secondarySubnetArn;
        this.secondaryNetworkId = builder.secondaryNetworkId;
        this.secondaryNetworkType = builder.secondaryNetworkType;
        this.ownerId = builder.ownerId;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.availabilityZone = builder.availabilityZone;
        this.ipv4CidrBlockAssociations = builder.ipv4CidrBlockAssociations;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the secondary subnet.
     * </p>
     * 
     * @return The ID of the secondary subnet.
     */
    public final String secondarySubnetId() {
        return secondarySubnetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the secondary subnet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the secondary subnet.
     */
    public final String secondarySubnetArn() {
        return secondarySubnetArn;
    }

    /**
     * <p>
     * The ID of the secondary network.
     * </p>
     * 
     * @return The ID of the secondary network.
     */
    public final String secondaryNetworkId() {
        return secondaryNetworkId;
    }

    /**
     * <p>
     * The type of the secondary network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #secondaryNetworkType} will return {@link SecondaryNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #secondaryNetworkTypeAsString}.
     * </p>
     * 
     * @return The type of the secondary network.
     * @see SecondaryNetworkType
     */
    public final SecondaryNetworkType secondaryNetworkType() {
        return SecondaryNetworkType.fromValue(secondaryNetworkType);
    }

    /**
     * <p>
     * The type of the secondary network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #secondaryNetworkType} will return {@link SecondaryNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #secondaryNetworkTypeAsString}.
     * </p>
     * 
     * @return The type of the secondary network.
     * @see SecondaryNetworkType
     */
    public final String secondaryNetworkTypeAsString() {
        return secondaryNetworkType;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the secondary subnet.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the secondary subnet.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The ID of the Availability Zone of the secondary subnet.
     * </p>
     * 
     * @return The ID of the Availability Zone of the secondary subnet.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The Availability Zone of the secondary subnet.
     * </p>
     * 
     * @return The Availability Zone of the secondary subnet.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv4CidrBlockAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIpv4CidrBlockAssociations() {
        return ipv4CidrBlockAssociations != null && !(ipv4CidrBlockAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPv4 CIDR blocks associated with the secondary subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv4CidrBlockAssociations} method.
     * </p>
     * 
     * @return Information about the IPv4 CIDR blocks associated with the secondary subnet.
     */
    public final List<SecondarySubnetIpv4CidrBlockAssociation> ipv4CidrBlockAssociations() {
        return ipv4CidrBlockAssociations;
    }

    /**
     * <p>
     * The state of the secondary subnet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SecondarySubnetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the secondary subnet.
     * @see SecondarySubnetState
     */
    public final SecondarySubnetState state() {
        return SecondarySubnetState.fromValue(state);
    }

    /**
     * <p>
     * The state of the secondary subnet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SecondarySubnetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the secondary subnet.
     * @see SecondarySubnetState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason for the current state of the secondary subnet.
     * </p>
     * 
     * @return The reason for the current state of the secondary subnet.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the secondary subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the secondary subnet.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secondarySubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(secondarySubnetArn());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryNetworkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv4CidrBlockAssociations() ? ipv4CidrBlockAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecondarySubnet)) {
            return false;
        }
        SecondarySubnet other = (SecondarySubnet) obj;
        return Objects.equals(secondarySubnetId(), other.secondarySubnetId())
                && Objects.equals(secondarySubnetArn(), other.secondarySubnetArn())
                && Objects.equals(secondaryNetworkId(), other.secondaryNetworkId())
                && Objects.equals(secondaryNetworkTypeAsString(), other.secondaryNetworkTypeAsString())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && hasIpv4CidrBlockAssociations() == other.hasIpv4CidrBlockAssociations()
                && Objects.equals(ipv4CidrBlockAssociations(), other.ipv4CidrBlockAssociations())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateReason(), other.stateReason())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecondarySubnet").add("SecondarySubnetId", secondarySubnetId())
                .add("SecondarySubnetArn", secondarySubnetArn()).add("SecondaryNetworkId", secondaryNetworkId())
                .add("SecondaryNetworkType", secondaryNetworkTypeAsString()).add("OwnerId", ownerId())
                .add("AvailabilityZoneId", availabilityZoneId()).add("AvailabilityZone", availabilityZone())
                .add("Ipv4CidrBlockAssociations", hasIpv4CidrBlockAssociations() ? ipv4CidrBlockAssociations() : null)
                .add("State", stateAsString()).add("StateReason", stateReason()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecondarySubnetId":
            return Optional.ofNullable(clazz.cast(secondarySubnetId()));
        case "SecondarySubnetArn":
            return Optional.ofNullable(clazz.cast(secondarySubnetArn()));
        case "SecondaryNetworkId":
            return Optional.ofNullable(clazz.cast(secondaryNetworkId()));
        case "SecondaryNetworkType":
            return Optional.ofNullable(clazz.cast(secondaryNetworkTypeAsString()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Ipv4CidrBlockAssociations":
            return Optional.ofNullable(clazz.cast(ipv4CidrBlockAssociations()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecondarySubnetId", SECONDARY_SUBNET_ID_FIELD);
        map.put("SecondarySubnetArn", SECONDARY_SUBNET_ARN_FIELD);
        map.put("SecondaryNetworkId", SECONDARY_NETWORK_ID_FIELD);
        map.put("SecondaryNetworkType", SECONDARY_NETWORK_TYPE_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("Ipv4CidrBlockAssociationSet", IPV4_CIDR_BLOCK_ASSOCIATIONS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecondarySubnet, T> g) {
        return obj -> g.apply((SecondarySubnet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecondarySubnet> {
        /**
         * <p>
         * The ID of the secondary subnet.
         * </p>
         * 
         * @param secondarySubnetId
         *        The ID of the secondary subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySubnetId(String secondarySubnetId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the secondary subnet.
         * </p>
         * 
         * @param secondarySubnetArn
         *        The Amazon Resource Name (ARN) of the secondary subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySubnetArn(String secondarySubnetArn);

        /**
         * <p>
         * The ID of the secondary network.
         * </p>
         * 
         * @param secondaryNetworkId
         *        The ID of the secondary network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryNetworkId(String secondaryNetworkId);

        /**
         * <p>
         * The type of the secondary network.
         * </p>
         * 
         * @param secondaryNetworkType
         *        The type of the secondary network.
         * @see SecondaryNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryNetworkType
         */
        Builder secondaryNetworkType(String secondaryNetworkType);

        /**
         * <p>
         * The type of the secondary network.
         * </p>
         * 
         * @param secondaryNetworkType
         *        The type of the secondary network.
         * @see SecondaryNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryNetworkType
         */
        Builder secondaryNetworkType(SecondaryNetworkType secondaryNetworkType);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the secondary subnet.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the secondary subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The ID of the Availability Zone of the secondary subnet.
         * </p>
         * 
         * @param availabilityZoneId
         *        The ID of the Availability Zone of the secondary subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The Availability Zone of the secondary subnet.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the secondary subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the secondary subnet.
         * </p>
         * 
         * @param ipv4CidrBlockAssociations
         *        Information about the IPv4 CIDR blocks associated with the secondary subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4CidrBlockAssociations(Collection<SecondarySubnetIpv4CidrBlockAssociation> ipv4CidrBlockAssociations);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the secondary subnet.
         * </p>
         * 
         * @param ipv4CidrBlockAssociations
         *        Information about the IPv4 CIDR blocks associated with the secondary subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4CidrBlockAssociations(SecondarySubnetIpv4CidrBlockAssociation... ipv4CidrBlockAssociations);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the secondary subnet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SecondarySubnetIpv4CidrBlockAssociation.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.SecondarySubnetIpv4CidrBlockAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SecondarySubnetIpv4CidrBlockAssociation.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #ipv4CidrBlockAssociations(List<SecondarySubnetIpv4CidrBlockAssociation>)}.
         * 
         * @param ipv4CidrBlockAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SecondarySubnetIpv4CidrBlockAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv4CidrBlockAssociations(java.util.Collection<SecondarySubnetIpv4CidrBlockAssociation>)
         */
        Builder ipv4CidrBlockAssociations(Consumer<SecondarySubnetIpv4CidrBlockAssociation.Builder>... ipv4CidrBlockAssociations);

        /**
         * <p>
         * The state of the secondary subnet.
         * </p>
         * 
         * @param state
         *        The state of the secondary subnet.
         * @see SecondarySubnetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondarySubnetState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the secondary subnet.
         * </p>
         * 
         * @param state
         *        The state of the secondary subnet.
         * @see SecondarySubnetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondarySubnetState
         */
        Builder state(SecondarySubnetState state);

        /**
         * <p>
         * The reason for the current state of the secondary subnet.
         * </p>
         * 
         * @param stateReason
         *        The reason for the current state of the secondary subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The tags assigned to the secondary subnet.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the secondary subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the secondary subnet.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the secondary subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the secondary subnet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String secondarySubnetId;

        private String secondarySubnetArn;

        private String secondaryNetworkId;

        private String secondaryNetworkType;

        private String ownerId;

        private String availabilityZoneId;

        private String availabilityZone;

        private List<SecondarySubnetIpv4CidrBlockAssociation> ipv4CidrBlockAssociations = DefaultSdkAutoConstructList
                .getInstance();

        private String state;

        private String stateReason;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecondarySubnet model) {
            secondarySubnetId(model.secondarySubnetId);
            secondarySubnetArn(model.secondarySubnetArn);
            secondaryNetworkId(model.secondaryNetworkId);
            secondaryNetworkType(model.secondaryNetworkType);
            ownerId(model.ownerId);
            availabilityZoneId(model.availabilityZoneId);
            availabilityZone(model.availabilityZone);
            ipv4CidrBlockAssociations(model.ipv4CidrBlockAssociations);
            state(model.state);
            stateReason(model.stateReason);
            tags(model.tags);
        }

        public final String getSecondarySubnetId() {
            return secondarySubnetId;
        }

        public final void setSecondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
        }

        @Override
        public final Builder secondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
            return this;
        }

        public final String getSecondarySubnetArn() {
            return secondarySubnetArn;
        }

        public final void setSecondarySubnetArn(String secondarySubnetArn) {
            this.secondarySubnetArn = secondarySubnetArn;
        }

        @Override
        public final Builder secondarySubnetArn(String secondarySubnetArn) {
            this.secondarySubnetArn = secondarySubnetArn;
            return this;
        }

        public final String getSecondaryNetworkId() {
            return secondaryNetworkId;
        }

        public final void setSecondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
        }

        @Override
        public final Builder secondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
            return this;
        }

        public final String getSecondaryNetworkType() {
            return secondaryNetworkType;
        }

        public final void setSecondaryNetworkType(String secondaryNetworkType) {
            this.secondaryNetworkType = secondaryNetworkType;
        }

        @Override
        public final Builder secondaryNetworkType(String secondaryNetworkType) {
            this.secondaryNetworkType = secondaryNetworkType;
            return this;
        }

        @Override
        public final Builder secondaryNetworkType(SecondaryNetworkType secondaryNetworkType) {
            this.secondaryNetworkType(secondaryNetworkType == null ? null : secondaryNetworkType.toString());
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final List<SecondarySubnetIpv4CidrBlockAssociation.Builder> getIpv4CidrBlockAssociations() {
            List<SecondarySubnetIpv4CidrBlockAssociation.Builder> result = SecondarySubnetIpv4CidrBlockAssociationListCopier
                    .copyToBuilder(this.ipv4CidrBlockAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4CidrBlockAssociations(
                Collection<SecondarySubnetIpv4CidrBlockAssociation.BuilderImpl> ipv4CidrBlockAssociations) {
            this.ipv4CidrBlockAssociations = SecondarySubnetIpv4CidrBlockAssociationListCopier
                    .copyFromBuilder(ipv4CidrBlockAssociations);
        }

        @Override
        public final Builder ipv4CidrBlockAssociations(
                Collection<SecondarySubnetIpv4CidrBlockAssociation> ipv4CidrBlockAssociations) {
            this.ipv4CidrBlockAssociations = SecondarySubnetIpv4CidrBlockAssociationListCopier.copy(ipv4CidrBlockAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4CidrBlockAssociations(SecondarySubnetIpv4CidrBlockAssociation... ipv4CidrBlockAssociations) {
            ipv4CidrBlockAssociations(Arrays.asList(ipv4CidrBlockAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4CidrBlockAssociations(
                Consumer<SecondarySubnetIpv4CidrBlockAssociation.Builder>... ipv4CidrBlockAssociations) {
            ipv4CidrBlockAssociations(Stream.of(ipv4CidrBlockAssociations)
                    .map(c -> SecondarySubnetIpv4CidrBlockAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SecondarySubnetState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SecondarySubnet build() {
            return new SecondarySubnet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
