/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a secondary network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecondaryNetwork implements SdkPojo, Serializable,
        ToCopyableBuilder<SecondaryNetwork.Builder, SecondaryNetwork> {
    private static final SdkField<String> SECONDARY_NETWORK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondaryNetworkId")
            .getter(getter(SecondaryNetwork::secondaryNetworkId))
            .setter(setter(Builder::secondaryNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkId")
                    .unmarshallLocationName("secondaryNetworkId").build()).build();

    private static final SdkField<String> SECONDARY_NETWORK_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondaryNetworkArn")
            .getter(getter(SecondaryNetwork::secondaryNetworkArn))
            .setter(setter(Builder::secondaryNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkArn")
                    .unmarshallLocationName("secondaryNetworkArn").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(SecondaryNetwork::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(SecondaryNetwork::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(SecondaryNetwork::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateReason")
            .getter(getter(SecondaryNetwork::stateReason))
            .setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason")
                    .unmarshallLocationName("stateReason").build()).build();

    private static final SdkField<List<SecondaryNetworkIpv4CidrBlockAssociation>> IPV4_CIDR_BLOCK_ASSOCIATIONS_FIELD = SdkField
            .<List<SecondaryNetworkIpv4CidrBlockAssociation>> builder(MarshallingType.LIST)
            .memberName("Ipv4CidrBlockAssociations")
            .getter(getter(SecondaryNetwork::ipv4CidrBlockAssociations))
            .setter(setter(Builder::ipv4CidrBlockAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4CidrBlockAssociationSet")
                    .unmarshallLocationName("ipv4CidrBlockAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SecondaryNetworkIpv4CidrBlockAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecondaryNetworkIpv4CidrBlockAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(SecondaryNetwork::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECONDARY_NETWORK_ID_FIELD,
            SECONDARY_NETWORK_ARN_FIELD, OWNER_ID_FIELD, TYPE_FIELD, STATE_FIELD, STATE_REASON_FIELD,
            IPV4_CIDR_BLOCK_ASSOCIATIONS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String secondaryNetworkId;

    private final String secondaryNetworkArn;

    private final String ownerId;

    private final String type;

    private final String state;

    private final String stateReason;

    private final List<SecondaryNetworkIpv4CidrBlockAssociation> ipv4CidrBlockAssociations;

    private final List<Tag> tags;

    private SecondaryNetwork(BuilderImpl builder) {
        this.secondaryNetworkId = builder.secondaryNetworkId;
        this.secondaryNetworkArn = builder.secondaryNetworkArn;
        this.ownerId = builder.ownerId;
        this.type = builder.type;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.ipv4CidrBlockAssociations = builder.ipv4CidrBlockAssociations;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the secondary network.
     * </p>
     * 
     * @return The ID of the secondary network.
     */
    public final String secondaryNetworkId() {
        return secondaryNetworkId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the secondary network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the secondary network.
     */
    public final String secondaryNetworkArn() {
        return secondaryNetworkArn;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the secondary network.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the secondary network.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The type of the secondary network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SecondaryNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the secondary network.
     * @see SecondaryNetworkType
     */
    public final SecondaryNetworkType type() {
        return SecondaryNetworkType.fromValue(type);
    }

    /**
     * <p>
     * The type of the secondary network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SecondaryNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the secondary network.
     * @see SecondaryNetworkType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The state of the secondary network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SecondaryNetworkState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the secondary network.
     * @see SecondaryNetworkState
     */
    public final SecondaryNetworkState state() {
        return SecondaryNetworkState.fromValue(state);
    }

    /**
     * <p>
     * The state of the secondary network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SecondaryNetworkState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the secondary network.
     * @see SecondaryNetworkState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason for the current state of the secondary network.
     * </p>
     * 
     * @return The reason for the current state of the secondary network.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv4CidrBlockAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIpv4CidrBlockAssociations() {
        return ipv4CidrBlockAssociations != null && !(ipv4CidrBlockAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPv4 CIDR blocks associated with the secondary network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv4CidrBlockAssociations} method.
     * </p>
     * 
     * @return Information about the IPv4 CIDR blocks associated with the secondary network.
     */
    public final List<SecondaryNetworkIpv4CidrBlockAssociation> ipv4CidrBlockAssociations() {
        return ipv4CidrBlockAssociations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the secondary network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the secondary network.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secondaryNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv4CidrBlockAssociations() ? ipv4CidrBlockAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecondaryNetwork)) {
            return false;
        }
        SecondaryNetwork other = (SecondaryNetwork) obj;
        return Objects.equals(secondaryNetworkId(), other.secondaryNetworkId())
                && Objects.equals(secondaryNetworkArn(), other.secondaryNetworkArn())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateReason(), other.stateReason())
                && hasIpv4CidrBlockAssociations() == other.hasIpv4CidrBlockAssociations()
                && Objects.equals(ipv4CidrBlockAssociations(), other.ipv4CidrBlockAssociations()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecondaryNetwork").add("SecondaryNetworkId", secondaryNetworkId())
                .add("SecondaryNetworkArn", secondaryNetworkArn()).add("OwnerId", ownerId()).add("Type", typeAsString())
                .add("State", stateAsString()).add("StateReason", stateReason())
                .add("Ipv4CidrBlockAssociations", hasIpv4CidrBlockAssociations() ? ipv4CidrBlockAssociations() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecondaryNetworkId":
            return Optional.ofNullable(clazz.cast(secondaryNetworkId()));
        case "SecondaryNetworkArn":
            return Optional.ofNullable(clazz.cast(secondaryNetworkArn()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "Ipv4CidrBlockAssociations":
            return Optional.ofNullable(clazz.cast(ipv4CidrBlockAssociations()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecondaryNetworkId", SECONDARY_NETWORK_ID_FIELD);
        map.put("SecondaryNetworkArn", SECONDARY_NETWORK_ARN_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("Ipv4CidrBlockAssociationSet", IPV4_CIDR_BLOCK_ASSOCIATIONS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecondaryNetwork, T> g) {
        return obj -> g.apply((SecondaryNetwork) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecondaryNetwork> {
        /**
         * <p>
         * The ID of the secondary network.
         * </p>
         * 
         * @param secondaryNetworkId
         *        The ID of the secondary network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryNetworkId(String secondaryNetworkId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the secondary network.
         * </p>
         * 
         * @param secondaryNetworkArn
         *        The Amazon Resource Name (ARN) of the secondary network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryNetworkArn(String secondaryNetworkArn);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the secondary network.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the secondary network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The type of the secondary network.
         * </p>
         * 
         * @param type
         *        The type of the secondary network.
         * @see SecondaryNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryNetworkType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the secondary network.
         * </p>
         * 
         * @param type
         *        The type of the secondary network.
         * @see SecondaryNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryNetworkType
         */
        Builder type(SecondaryNetworkType type);

        /**
         * <p>
         * The state of the secondary network.
         * </p>
         * 
         * @param state
         *        The state of the secondary network.
         * @see SecondaryNetworkState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryNetworkState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the secondary network.
         * </p>
         * 
         * @param state
         *        The state of the secondary network.
         * @see SecondaryNetworkState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryNetworkState
         */
        Builder state(SecondaryNetworkState state);

        /**
         * <p>
         * The reason for the current state of the secondary network.
         * </p>
         * 
         * @param stateReason
         *        The reason for the current state of the secondary network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the secondary network.
         * </p>
         * 
         * @param ipv4CidrBlockAssociations
         *        Information about the IPv4 CIDR blocks associated with the secondary network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4CidrBlockAssociations(Collection<SecondaryNetworkIpv4CidrBlockAssociation> ipv4CidrBlockAssociations);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the secondary network.
         * </p>
         * 
         * @param ipv4CidrBlockAssociations
         *        Information about the IPv4 CIDR blocks associated with the secondary network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4CidrBlockAssociations(SecondaryNetworkIpv4CidrBlockAssociation... ipv4CidrBlockAssociations);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the secondary network.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SecondaryNetworkIpv4CidrBlockAssociation.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.SecondaryNetworkIpv4CidrBlockAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SecondaryNetworkIpv4CidrBlockAssociation.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #ipv4CidrBlockAssociations(List<SecondaryNetworkIpv4CidrBlockAssociation>)}.
         * 
         * @param ipv4CidrBlockAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SecondaryNetworkIpv4CidrBlockAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv4CidrBlockAssociations(java.util.Collection<SecondaryNetworkIpv4CidrBlockAssociation>)
         */
        Builder ipv4CidrBlockAssociations(Consumer<SecondaryNetworkIpv4CidrBlockAssociation.Builder>... ipv4CidrBlockAssociations);

        /**
         * <p>
         * The tags assigned to the secondary network.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the secondary network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the secondary network.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the secondary network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the secondary network.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String secondaryNetworkId;

        private String secondaryNetworkArn;

        private String ownerId;

        private String type;

        private String state;

        private String stateReason;

        private List<SecondaryNetworkIpv4CidrBlockAssociation> ipv4CidrBlockAssociations = DefaultSdkAutoConstructList
                .getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecondaryNetwork model) {
            secondaryNetworkId(model.secondaryNetworkId);
            secondaryNetworkArn(model.secondaryNetworkArn);
            ownerId(model.ownerId);
            type(model.type);
            state(model.state);
            stateReason(model.stateReason);
            ipv4CidrBlockAssociations(model.ipv4CidrBlockAssociations);
            tags(model.tags);
        }

        public final String getSecondaryNetworkId() {
            return secondaryNetworkId;
        }

        public final void setSecondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
        }

        @Override
        public final Builder secondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
            return this;
        }

        public final String getSecondaryNetworkArn() {
            return secondaryNetworkArn;
        }

        public final void setSecondaryNetworkArn(String secondaryNetworkArn) {
            this.secondaryNetworkArn = secondaryNetworkArn;
        }

        @Override
        public final Builder secondaryNetworkArn(String secondaryNetworkArn) {
            this.secondaryNetworkArn = secondaryNetworkArn;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SecondaryNetworkType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SecondaryNetworkState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final List<SecondaryNetworkIpv4CidrBlockAssociation.Builder> getIpv4CidrBlockAssociations() {
            List<SecondaryNetworkIpv4CidrBlockAssociation.Builder> result = SecondaryNetworkIpv4CidrBlockAssociationListCopier
                    .copyToBuilder(this.ipv4CidrBlockAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4CidrBlockAssociations(
                Collection<SecondaryNetworkIpv4CidrBlockAssociation.BuilderImpl> ipv4CidrBlockAssociations) {
            this.ipv4CidrBlockAssociations = SecondaryNetworkIpv4CidrBlockAssociationListCopier
                    .copyFromBuilder(ipv4CidrBlockAssociations);
        }

        @Override
        public final Builder ipv4CidrBlockAssociations(
                Collection<SecondaryNetworkIpv4CidrBlockAssociation> ipv4CidrBlockAssociations) {
            this.ipv4CidrBlockAssociations = SecondaryNetworkIpv4CidrBlockAssociationListCopier.copy(ipv4CidrBlockAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4CidrBlockAssociations(SecondaryNetworkIpv4CidrBlockAssociation... ipv4CidrBlockAssociations) {
            ipv4CidrBlockAssociations(Arrays.asList(ipv4CidrBlockAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4CidrBlockAssociations(
                Consumer<SecondaryNetworkIpv4CidrBlockAssociation.Builder>... ipv4CidrBlockAssociations) {
            ipv4CidrBlockAssociations(Stream.of(ipv4CidrBlockAssociations)
                    .map(c -> SecondaryNetworkIpv4CidrBlockAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SecondaryNetwork build() {
            return new SecondaryNetwork(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
