/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a schedule that is available for your Scheduled Instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledInstanceAvailability implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledInstanceAvailability.Builder, ScheduledInstanceAvailability> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(ScheduledInstanceAvailability::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableInstanceCount")
            .getter(getter(ScheduledInstanceAvailability::availableInstanceCount))
            .setter(setter(Builder::availableInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount")
                    .unmarshallLocationName("availableInstanceCount").build()).build();

    private static final SdkField<Instant> FIRST_SLOT_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("FirstSlotStartTime")
            .getter(getter(ScheduledInstanceAvailability::firstSlotStartTime))
            .setter(setter(Builder::firstSlotStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstSlotStartTime")
                    .unmarshallLocationName("firstSlotStartTime").build()).build();

    private static final SdkField<String> HOURLY_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HourlyPrice")
            .getter(getter(ScheduledInstanceAvailability::hourlyPrice))
            .setter(setter(Builder::hourlyPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyPrice")
                    .unmarshallLocationName("hourlyPrice").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(ScheduledInstanceAvailability::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<Integer> MAX_TERM_DURATION_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxTermDurationInDays")
            .getter(getter(ScheduledInstanceAvailability::maxTermDurationInDays))
            .setter(setter(Builder::maxTermDurationInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTermDurationInDays")
                    .unmarshallLocationName("maxTermDurationInDays").build()).build();

    private static final SdkField<Integer> MIN_TERM_DURATION_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinTermDurationInDays")
            .getter(getter(ScheduledInstanceAvailability::minTermDurationInDays))
            .setter(setter(Builder::minTermDurationInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTermDurationInDays")
                    .unmarshallLocationName("minTermDurationInDays").build()).build();

    private static final SdkField<String> NETWORK_PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkPlatform")
            .getter(getter(ScheduledInstanceAvailability::networkPlatform))
            .setter(setter(Builder::networkPlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPlatform")
                    .unmarshallLocationName("networkPlatform").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Platform")
            .getter(getter(ScheduledInstanceAvailability::platform))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform")
                    .unmarshallLocationName("platform").build()).build();

    private static final SdkField<String> PURCHASE_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PurchaseToken")
            .getter(getter(ScheduledInstanceAvailability::purchaseToken))
            .setter(setter(Builder::purchaseToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseToken")
                    .unmarshallLocationName("purchaseToken").build()).build();

    private static final SdkField<ScheduledInstanceRecurrence> RECURRENCE_FIELD = SdkField
            .<ScheduledInstanceRecurrence> builder(MarshallingType.SDK_POJO)
            .memberName("Recurrence")
            .getter(getter(ScheduledInstanceAvailability::recurrence))
            .setter(setter(Builder::recurrence))
            .constructor(ScheduledInstanceRecurrence::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence")
                    .unmarshallLocationName("recurrence").build()).build();

    private static final SdkField<Integer> SLOT_DURATION_IN_HOURS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SlotDurationInHours")
            .getter(getter(ScheduledInstanceAvailability::slotDurationInHours))
            .setter(setter(Builder::slotDurationInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlotDurationInHours")
                    .unmarshallLocationName("slotDurationInHours").build()).build();

    private static final SdkField<Integer> TOTAL_SCHEDULED_INSTANCE_HOURS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalScheduledInstanceHours")
            .getter(getter(ScheduledInstanceAvailability::totalScheduledInstanceHours))
            .setter(setter(Builder::totalScheduledInstanceHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalScheduledInstanceHours")
                    .unmarshallLocationName("totalScheduledInstanceHours").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            AVAILABLE_INSTANCE_COUNT_FIELD, FIRST_SLOT_START_TIME_FIELD, HOURLY_PRICE_FIELD, INSTANCE_TYPE_FIELD,
            MAX_TERM_DURATION_IN_DAYS_FIELD, MIN_TERM_DURATION_IN_DAYS_FIELD, NETWORK_PLATFORM_FIELD, PLATFORM_FIELD,
            PURCHASE_TOKEN_FIELD, RECURRENCE_FIELD, SLOT_DURATION_IN_HOURS_FIELD, TOTAL_SCHEDULED_INSTANCE_HOURS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final Integer availableInstanceCount;

    private final Instant firstSlotStartTime;

    private final String hourlyPrice;

    private final String instanceType;

    private final Integer maxTermDurationInDays;

    private final Integer minTermDurationInDays;

    private final String networkPlatform;

    private final String platform;

    private final String purchaseToken;

    private final ScheduledInstanceRecurrence recurrence;

    private final Integer slotDurationInHours;

    private final Integer totalScheduledInstanceHours;

    private ScheduledInstanceAvailability(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.firstSlotStartTime = builder.firstSlotStartTime;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceType = builder.instanceType;
        this.maxTermDurationInDays = builder.maxTermDurationInDays;
        this.minTermDurationInDays = builder.minTermDurationInDays;
        this.networkPlatform = builder.networkPlatform;
        this.platform = builder.platform;
        this.purchaseToken = builder.purchaseToken;
        this.recurrence = builder.recurrence;
        this.slotDurationInHours = builder.slotDurationInHours;
        this.totalScheduledInstanceHours = builder.totalScheduledInstanceHours;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * 
     * @return The Availability Zone.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of available instances.
     * </p>
     * 
     * @return The number of available instances.
     */
    public final Integer availableInstanceCount() {
        return availableInstanceCount;
    }

    /**
     * <p>
     * The time period for the first schedule to start.
     * </p>
     * 
     * @return The time period for the first schedule to start.
     */
    public final Instant firstSlotStartTime() {
        return firstSlotStartTime;
    }

    /**
     * <p>
     * The hourly price for a single instance.
     * </p>
     * 
     * @return The hourly price for a single instance.
     */
    public final String hourlyPrice() {
        return hourlyPrice;
    }

    /**
     * <p>
     * The instance type. You can specify one of the C3, C4, M4, or R3 instance types.
     * </p>
     * 
     * @return The instance type. You can specify one of the C3, C4, M4, or R3 instance types.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The maximum term. The only possible value is 365 days.
     * </p>
     * 
     * @return The maximum term. The only possible value is 365 days.
     */
    public final Integer maxTermDurationInDays() {
        return maxTermDurationInDays;
    }

    /**
     * <p>
     * The minimum term. The only possible value is 365 days.
     * </p>
     * 
     * @return The minimum term. The only possible value is 365 days.
     */
    public final Integer minTermDurationInDays() {
        return minTermDurationInDays;
    }

    /**
     * <p>
     * The network platform.
     * </p>
     * 
     * @return The network platform.
     */
    public final String networkPlatform() {
        return networkPlatform;
    }

    /**
     * <p>
     * The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     * </p>
     * 
     * @return The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The purchase token. This token expires in two hours.
     * </p>
     * 
     * @return The purchase token. This token expires in two hours.
     */
    public final String purchaseToken() {
        return purchaseToken;
    }

    /**
     * <p>
     * The schedule recurrence.
     * </p>
     * 
     * @return The schedule recurrence.
     */
    public final ScheduledInstanceRecurrence recurrence() {
        return recurrence;
    }

    /**
     * <p>
     * The number of hours in the schedule.
     * </p>
     * 
     * @return The number of hours in the schedule.
     */
    public final Integer slotDurationInHours() {
        return slotDurationInHours;
    }

    /**
     * <p>
     * The total number of hours for a single instance for the entire term.
     * </p>
     * 
     * @return The total number of hours for a single instance for the entire term.
     */
    public final Integer totalScheduledInstanceHours() {
        return totalScheduledInstanceHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(firstSlotStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(maxTermDurationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(minTermDurationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(networkPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseToken());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(slotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(totalScheduledInstanceHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstanceAvailability)) {
            return false;
        }
        ScheduledInstanceAvailability other = (ScheduledInstanceAvailability) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availableInstanceCount(), other.availableInstanceCount())
                && Objects.equals(firstSlotStartTime(), other.firstSlotStartTime())
                && Objects.equals(hourlyPrice(), other.hourlyPrice()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(maxTermDurationInDays(), other.maxTermDurationInDays())
                && Objects.equals(minTermDurationInDays(), other.minTermDurationInDays())
                && Objects.equals(networkPlatform(), other.networkPlatform()) && Objects.equals(platform(), other.platform())
                && Objects.equals(purchaseToken(), other.purchaseToken()) && Objects.equals(recurrence(), other.recurrence())
                && Objects.equals(slotDurationInHours(), other.slotDurationInHours())
                && Objects.equals(totalScheduledInstanceHours(), other.totalScheduledInstanceHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledInstanceAvailability").add("AvailabilityZone", availabilityZone())
                .add("AvailableInstanceCount", availableInstanceCount()).add("FirstSlotStartTime", firstSlotStartTime())
                .add("HourlyPrice", hourlyPrice()).add("InstanceType", instanceType())
                .add("MaxTermDurationInDays", maxTermDurationInDays()).add("MinTermDurationInDays", minTermDurationInDays())
                .add("NetworkPlatform", networkPlatform()).add("Platform", platform()).add("PurchaseToken", purchaseToken())
                .add("Recurrence", recurrence()).add("SlotDurationInHours", slotDurationInHours())
                .add("TotalScheduledInstanceHours", totalScheduledInstanceHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailableInstanceCount":
            return Optional.ofNullable(clazz.cast(availableInstanceCount()));
        case "FirstSlotStartTime":
            return Optional.ofNullable(clazz.cast(firstSlotStartTime()));
        case "HourlyPrice":
            return Optional.ofNullable(clazz.cast(hourlyPrice()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "MaxTermDurationInDays":
            return Optional.ofNullable(clazz.cast(maxTermDurationInDays()));
        case "MinTermDurationInDays":
            return Optional.ofNullable(clazz.cast(minTermDurationInDays()));
        case "NetworkPlatform":
            return Optional.ofNullable(clazz.cast(networkPlatform()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "PurchaseToken":
            return Optional.ofNullable(clazz.cast(purchaseToken()));
        case "Recurrence":
            return Optional.ofNullable(clazz.cast(recurrence()));
        case "SlotDurationInHours":
            return Optional.ofNullable(clazz.cast(slotDurationInHours()));
        case "TotalScheduledInstanceHours":
            return Optional.ofNullable(clazz.cast(totalScheduledInstanceHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailableInstanceCount", AVAILABLE_INSTANCE_COUNT_FIELD);
        map.put("FirstSlotStartTime", FIRST_SLOT_START_TIME_FIELD);
        map.put("HourlyPrice", HOURLY_PRICE_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("MaxTermDurationInDays", MAX_TERM_DURATION_IN_DAYS_FIELD);
        map.put("MinTermDurationInDays", MIN_TERM_DURATION_IN_DAYS_FIELD);
        map.put("NetworkPlatform", NETWORK_PLATFORM_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("PurchaseToken", PURCHASE_TOKEN_FIELD);
        map.put("Recurrence", RECURRENCE_FIELD);
        map.put("SlotDurationInHours", SLOT_DURATION_IN_HOURS_FIELD);
        map.put("TotalScheduledInstanceHours", TOTAL_SCHEDULED_INSTANCE_HOURS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledInstanceAvailability, T> g) {
        return obj -> g.apply((ScheduledInstanceAvailability) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledInstanceAvailability> {
        /**
         * <p>
         * The Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of available instances.
         * </p>
         * 
         * @param availableInstanceCount
         *        The number of available instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCount(Integer availableInstanceCount);

        /**
         * <p>
         * The time period for the first schedule to start.
         * </p>
         * 
         * @param firstSlotStartTime
         *        The time period for the first schedule to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstSlotStartTime(Instant firstSlotStartTime);

        /**
         * <p>
         * The hourly price for a single instance.
         * </p>
         * 
         * @param hourlyPrice
         *        The hourly price for a single instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyPrice(String hourlyPrice);

        /**
         * <p>
         * The instance type. You can specify one of the C3, C4, M4, or R3 instance types.
         * </p>
         * 
         * @param instanceType
         *        The instance type. You can specify one of the C3, C4, M4, or R3 instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The maximum term. The only possible value is 365 days.
         * </p>
         * 
         * @param maxTermDurationInDays
         *        The maximum term. The only possible value is 365 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxTermDurationInDays(Integer maxTermDurationInDays);

        /**
         * <p>
         * The minimum term. The only possible value is 365 days.
         * </p>
         * 
         * @param minTermDurationInDays
         *        The minimum term. The only possible value is 365 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minTermDurationInDays(Integer minTermDurationInDays);

        /**
         * <p>
         * The network platform.
         * </p>
         * 
         * @param networkPlatform
         *        The network platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPlatform(String networkPlatform);

        /**
         * <p>
         * The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * 
         * @param platform
         *        The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The purchase token. This token expires in two hours.
         * </p>
         * 
         * @param purchaseToken
         *        The purchase token. This token expires in two hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseToken(String purchaseToken);

        /**
         * <p>
         * The schedule recurrence.
         * </p>
         * 
         * @param recurrence
         *        The schedule recurrence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(ScheduledInstanceRecurrence recurrence);

        /**
         * <p>
         * The schedule recurrence.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduledInstanceRecurrence.Builder}
         * avoiding the need to create one manually via {@link ScheduledInstanceRecurrence#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduledInstanceRecurrence.Builder#build()} is called
         * immediately and its result is passed to {@link #recurrence(ScheduledInstanceRecurrence)}.
         * 
         * @param recurrence
         *        a consumer that will call methods on {@link ScheduledInstanceRecurrence.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurrence(ScheduledInstanceRecurrence)
         */
        default Builder recurrence(Consumer<ScheduledInstanceRecurrence.Builder> recurrence) {
            return recurrence(ScheduledInstanceRecurrence.builder().applyMutation(recurrence).build());
        }

        /**
         * <p>
         * The number of hours in the schedule.
         * </p>
         * 
         * @param slotDurationInHours
         *        The number of hours in the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotDurationInHours(Integer slotDurationInHours);

        /**
         * <p>
         * The total number of hours for a single instance for the entire term.
         * </p>
         * 
         * @param totalScheduledInstanceHours
         *        The total number of hours for a single instance for the entire term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalScheduledInstanceHours(Integer totalScheduledInstanceHours);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Integer availableInstanceCount;

        private Instant firstSlotStartTime;

        private String hourlyPrice;

        private String instanceType;

        private Integer maxTermDurationInDays;

        private Integer minTermDurationInDays;

        private String networkPlatform;

        private String platform;

        private String purchaseToken;

        private ScheduledInstanceRecurrence recurrence;

        private Integer slotDurationInHours;

        private Integer totalScheduledInstanceHours;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstanceAvailability model) {
            availabilityZone(model.availabilityZone);
            availableInstanceCount(model.availableInstanceCount);
            firstSlotStartTime(model.firstSlotStartTime);
            hourlyPrice(model.hourlyPrice);
            instanceType(model.instanceType);
            maxTermDurationInDays(model.maxTermDurationInDays);
            minTermDurationInDays(model.minTermDurationInDays);
            networkPlatform(model.networkPlatform);
            platform(model.platform);
            purchaseToken(model.purchaseToken);
            recurrence(model.recurrence);
            slotDurationInHours(model.slotDurationInHours);
            totalScheduledInstanceHours(model.totalScheduledInstanceHours);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getAvailableInstanceCount() {
            return availableInstanceCount;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final Instant getFirstSlotStartTime() {
            return firstSlotStartTime;
        }

        public final void setFirstSlotStartTime(Instant firstSlotStartTime) {
            this.firstSlotStartTime = firstSlotStartTime;
        }

        @Override
        public final Builder firstSlotStartTime(Instant firstSlotStartTime) {
            this.firstSlotStartTime = firstSlotStartTime;
            return this;
        }

        public final String getHourlyPrice() {
            return hourlyPrice;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getMaxTermDurationInDays() {
            return maxTermDurationInDays;
        }

        public final void setMaxTermDurationInDays(Integer maxTermDurationInDays) {
            this.maxTermDurationInDays = maxTermDurationInDays;
        }

        @Override
        public final Builder maxTermDurationInDays(Integer maxTermDurationInDays) {
            this.maxTermDurationInDays = maxTermDurationInDays;
            return this;
        }

        public final Integer getMinTermDurationInDays() {
            return minTermDurationInDays;
        }

        public final void setMinTermDurationInDays(Integer minTermDurationInDays) {
            this.minTermDurationInDays = minTermDurationInDays;
        }

        @Override
        public final Builder minTermDurationInDays(Integer minTermDurationInDays) {
            this.minTermDurationInDays = minTermDurationInDays;
            return this;
        }

        public final String getNetworkPlatform() {
            return networkPlatform;
        }

        public final void setNetworkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
        }

        @Override
        public final Builder networkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getPurchaseToken() {
            return purchaseToken;
        }

        public final void setPurchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
        }

        @Override
        public final Builder purchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
            return this;
        }

        public final ScheduledInstanceRecurrence.Builder getRecurrence() {
            return recurrence != null ? recurrence.toBuilder() : null;
        }

        public final void setRecurrence(ScheduledInstanceRecurrence.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public final Builder recurrence(ScheduledInstanceRecurrence recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final Integer getSlotDurationInHours() {
            return slotDurationInHours;
        }

        public final void setSlotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
        }

        @Override
        public final Builder slotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
            return this;
        }

        public final Integer getTotalScheduledInstanceHours() {
            return totalScheduledInstanceHours;
        }

        public final void setTotalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
        }

        @Override
        public final Builder totalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
            return this;
        }

        @Override
        public ScheduledInstanceAvailability build() {
            return new ScheduledInstanceAvailability(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
