/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcEncryptionControlResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyVpcEncryptionControlResponse.Builder, ModifyVpcEncryptionControlResponse> {
    private static final SdkField<VpcEncryptionControl> VPC_ENCRYPTION_CONTROL_FIELD = SdkField
            .<VpcEncryptionControl> builder(MarshallingType.SDK_POJO)
            .memberName("VpcEncryptionControl")
            .getter(getter(ModifyVpcEncryptionControlResponse::vpcEncryptionControl))
            .setter(setter(Builder::vpcEncryptionControl))
            .constructor(VpcEncryptionControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEncryptionControl")
                    .unmarshallLocationName("vpcEncryptionControl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENCRYPTION_CONTROL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VpcEncryptionControl vpcEncryptionControl;

    private ModifyVpcEncryptionControlResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEncryptionControl = builder.vpcEncryptionControl;
    }

    /**
     * <p>
     * Information about the VPC Encryption Control configuration.
     * </p>
     * 
     * @return Information about the VPC Encryption Control configuration.
     */
    public final VpcEncryptionControl vpcEncryptionControl() {
        return vpcEncryptionControl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcEncryptionControl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEncryptionControlResponse)) {
            return false;
        }
        ModifyVpcEncryptionControlResponse other = (ModifyVpcEncryptionControlResponse) obj;
        return Objects.equals(vpcEncryptionControl(), other.vpcEncryptionControl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVpcEncryptionControlResponse").add("VpcEncryptionControl", vpcEncryptionControl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEncryptionControl":
            return Optional.ofNullable(clazz.cast(vpcEncryptionControl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcEncryptionControl", VPC_ENCRYPTION_CONTROL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEncryptionControlResponse, T> g) {
        return obj -> g.apply((ModifyVpcEncryptionControlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVpcEncryptionControlResponse> {
        /**
         * <p>
         * Information about the VPC Encryption Control configuration.
         * </p>
         * 
         * @param vpcEncryptionControl
         *        Information about the VPC Encryption Control configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEncryptionControl(VpcEncryptionControl vpcEncryptionControl);

        /**
         * <p>
         * Information about the VPC Encryption Control configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEncryptionControl.Builder} avoiding
         * the need to create one manually via {@link VpcEncryptionControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEncryptionControl.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcEncryptionControl(VpcEncryptionControl)}.
         * 
         * @param vpcEncryptionControl
         *        a consumer that will call methods on {@link VpcEncryptionControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEncryptionControl(VpcEncryptionControl)
         */
        default Builder vpcEncryptionControl(Consumer<VpcEncryptionControl.Builder> vpcEncryptionControl) {
            return vpcEncryptionControl(VpcEncryptionControl.builder().applyMutation(vpcEncryptionControl).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private VpcEncryptionControl vpcEncryptionControl;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEncryptionControlResponse model) {
            super(model);
            vpcEncryptionControl(model.vpcEncryptionControl);
        }

        public final VpcEncryptionControl.Builder getVpcEncryptionControl() {
            return vpcEncryptionControl != null ? vpcEncryptionControl.toBuilder() : null;
        }

        public final void setVpcEncryptionControl(VpcEncryptionControl.BuilderImpl vpcEncryptionControl) {
            this.vpcEncryptionControl = vpcEncryptionControl != null ? vpcEncryptionControl.build() : null;
        }

        @Override
        public final Builder vpcEncryptionControl(VpcEncryptionControl vpcEncryptionControl) {
            this.vpcEncryptionControl = vpcEncryptionControl;
            return this;
        }

        @Override
        public ModifyVpcEncryptionControlResponse build() {
            return new ModifyVpcEncryptionControlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
