/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIpamScopeRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyIpamScopeRequest.Builder, ModifyIpamScopeRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyIpamScopeRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> IPAM_SCOPE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamScopeId")
            .getter(getter(ModifyIpamScopeRequest::ipamScopeId))
            .setter(setter(Builder::ipamScopeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScopeId")
                    .unmarshallLocationName("IpamScopeId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ModifyIpamScopeRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<ExternalAuthorityConfiguration> EXTERNAL_AUTHORITY_CONFIGURATION_FIELD = SdkField
            .<ExternalAuthorityConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ExternalAuthorityConfiguration")
            .getter(getter(ModifyIpamScopeRequest::externalAuthorityConfiguration))
            .setter(setter(Builder::externalAuthorityConfiguration))
            .constructor(ExternalAuthorityConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalAuthorityConfiguration")
                    .unmarshallLocationName("ExternalAuthorityConfiguration").build()).build();

    private static final SdkField<Boolean> REMOVE_EXTERNAL_AUTHORITY_CONFIGURATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemoveExternalAuthorityConfiguration")
            .getter(getter(ModifyIpamScopeRequest::removeExternalAuthorityConfiguration))
            .setter(setter(Builder::removeExternalAuthorityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RemoveExternalAuthorityConfiguration")
                    .unmarshallLocationName("RemoveExternalAuthorityConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            IPAM_SCOPE_ID_FIELD, DESCRIPTION_FIELD, EXTERNAL_AUTHORITY_CONFIGURATION_FIELD,
            REMOVE_EXTERNAL_AUTHORITY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String ipamScopeId;

    private final String description;

    private final ExternalAuthorityConfiguration externalAuthorityConfiguration;

    private final Boolean removeExternalAuthorityConfiguration;

    private ModifyIpamScopeRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamScopeId = builder.ipamScopeId;
        this.description = builder.description;
        this.externalAuthorityConfiguration = builder.externalAuthorityConfiguration;
        this.removeExternalAuthorityConfiguration = builder.removeExternalAuthorityConfiguration;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the scope you want to modify.
     * </p>
     * 
     * @return The ID of the scope you want to modify.
     */
    public final String ipamScopeId() {
        return ipamScopeId;
    }

    /**
     * <p>
     * The description of the scope you want to modify.
     * </p>
     * 
     * @return The description of the scope you want to modify.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration that links an Amazon VPC IPAM scope to an external authority system. It specifies the type of
     * external system and the external resource identifier that identifies your account or instance in that system.
     * </p>
     * <p>
     * In IPAM, an external authority is a third-party IP address management system that provides CIDR blocks when you
     * provision address space for top-level IPAM pools. This allows you to use your existing IP management system to
     * control which address ranges are allocated to Amazon Web Services while using Amazon VPC IPAM to manage subnets
     * within those ranges.
     * </p>
     * 
     * @return The configuration that links an Amazon VPC IPAM scope to an external authority system. It specifies the
     *         type of external system and the external resource identifier that identifies your account or instance in
     *         that system.</p>
     *         <p>
     *         In IPAM, an external authority is a third-party IP address management system that provides CIDR blocks
     *         when you provision address space for top-level IPAM pools. This allows you to use your existing IP
     *         management system to control which address ranges are allocated to Amazon Web Services while using Amazon
     *         VPC IPAM to manage subnets within those ranges.
     */
    public final ExternalAuthorityConfiguration externalAuthorityConfiguration() {
        return externalAuthorityConfiguration;
    }

    /**
     * <p>
     * Remove the external authority configuration. <code>true</code> to remove.
     * </p>
     * 
     * @return Remove the external authority configuration. <code>true</code> to remove.
     */
    public final Boolean removeExternalAuthorityConfiguration() {
        return removeExternalAuthorityConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(ipamScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(externalAuthorityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(removeExternalAuthorityConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamScopeRequest)) {
            return false;
        }
        ModifyIpamScopeRequest other = (ModifyIpamScopeRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(ipamScopeId(), other.ipamScopeId())
                && Objects.equals(description(), other.description())
                && Objects.equals(externalAuthorityConfiguration(), other.externalAuthorityConfiguration())
                && Objects.equals(removeExternalAuthorityConfiguration(), other.removeExternalAuthorityConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIpamScopeRequest").add("DryRun", dryRun()).add("IpamScopeId", ipamScopeId())
                .add("Description", description()).add("ExternalAuthorityConfiguration", externalAuthorityConfiguration())
                .add("RemoveExternalAuthorityConfiguration", removeExternalAuthorityConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "IpamScopeId":
            return Optional.ofNullable(clazz.cast(ipamScopeId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ExternalAuthorityConfiguration":
            return Optional.ofNullable(clazz.cast(externalAuthorityConfiguration()));
        case "RemoveExternalAuthorityConfiguration":
            return Optional.ofNullable(clazz.cast(removeExternalAuthorityConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamScopeId", IPAM_SCOPE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ExternalAuthorityConfiguration", EXTERNAL_AUTHORITY_CONFIGURATION_FIELD);
        map.put("RemoveExternalAuthorityConfiguration", REMOVE_EXTERNAL_AUTHORITY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamScopeRequest, T> g) {
        return obj -> g.apply((ModifyIpamScopeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyIpamScopeRequest> {
        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the scope you want to modify.
         * </p>
         * 
         * @param ipamScopeId
         *        The ID of the scope you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamScopeId(String ipamScopeId);

        /**
         * <p>
         * The description of the scope you want to modify.
         * </p>
         * 
         * @param description
         *        The description of the scope you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration that links an Amazon VPC IPAM scope to an external authority system. It specifies the type
         * of external system and the external resource identifier that identifies your account or instance in that
         * system.
         * </p>
         * <p>
         * In IPAM, an external authority is a third-party IP address management system that provides CIDR blocks when
         * you provision address space for top-level IPAM pools. This allows you to use your existing IP management
         * system to control which address ranges are allocated to Amazon Web Services while using Amazon VPC IPAM to
         * manage subnets within those ranges.
         * </p>
         * 
         * @param externalAuthorityConfiguration
         *        The configuration that links an Amazon VPC IPAM scope to an external authority system. It specifies
         *        the type of external system and the external resource identifier that identifies your account or
         *        instance in that system.</p>
         *        <p>
         *        In IPAM, an external authority is a third-party IP address management system that provides CIDR blocks
         *        when you provision address space for top-level IPAM pools. This allows you to use your existing IP
         *        management system to control which address ranges are allocated to Amazon Web Services while using
         *        Amazon VPC IPAM to manage subnets within those ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalAuthorityConfiguration(ExternalAuthorityConfiguration externalAuthorityConfiguration);

        /**
         * <p>
         * The configuration that links an Amazon VPC IPAM scope to an external authority system. It specifies the type
         * of external system and the external resource identifier that identifies your account or instance in that
         * system.
         * </p>
         * <p>
         * In IPAM, an external authority is a third-party IP address management system that provides CIDR blocks when
         * you provision address space for top-level IPAM pools. This allows you to use your existing IP management
         * system to control which address ranges are allocated to Amazon Web Services while using Amazon VPC IPAM to
         * manage subnets within those ranges.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalAuthorityConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExternalAuthorityConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalAuthorityConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #externalAuthorityConfiguration(ExternalAuthorityConfiguration)}.
         * 
         * @param externalAuthorityConfiguration
         *        a consumer that will call methods on {@link ExternalAuthorityConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalAuthorityConfiguration(ExternalAuthorityConfiguration)
         */
        default Builder externalAuthorityConfiguration(
                Consumer<ExternalAuthorityConfiguration.Builder> externalAuthorityConfiguration) {
            return externalAuthorityConfiguration(ExternalAuthorityConfiguration.builder()
                    .applyMutation(externalAuthorityConfiguration).build());
        }

        /**
         * <p>
         * Remove the external authority configuration. <code>true</code> to remove.
         * </p>
         * 
         * @param removeExternalAuthorityConfiguration
         *        Remove the external authority configuration. <code>true</code> to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeExternalAuthorityConfiguration(Boolean removeExternalAuthorityConfiguration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String ipamScopeId;

        private String description;

        private ExternalAuthorityConfiguration externalAuthorityConfiguration;

        private Boolean removeExternalAuthorityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamScopeRequest model) {
            super(model);
            dryRun(model.dryRun);
            ipamScopeId(model.ipamScopeId);
            description(model.description);
            externalAuthorityConfiguration(model.externalAuthorityConfiguration);
            removeExternalAuthorityConfiguration(model.removeExternalAuthorityConfiguration);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamScopeId() {
            return ipamScopeId;
        }

        public final void setIpamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
        }

        @Override
        public final Builder ipamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ExternalAuthorityConfiguration.Builder getExternalAuthorityConfiguration() {
            return externalAuthorityConfiguration != null ? externalAuthorityConfiguration.toBuilder() : null;
        }

        public final void setExternalAuthorityConfiguration(
                ExternalAuthorityConfiguration.BuilderImpl externalAuthorityConfiguration) {
            this.externalAuthorityConfiguration = externalAuthorityConfiguration != null ? externalAuthorityConfiguration.build()
                    : null;
        }

        @Override
        public final Builder externalAuthorityConfiguration(ExternalAuthorityConfiguration externalAuthorityConfiguration) {
            this.externalAuthorityConfiguration = externalAuthorityConfiguration;
            return this;
        }

        public final Boolean getRemoveExternalAuthorityConfiguration() {
            return removeExternalAuthorityConfiguration;
        }

        public final void setRemoveExternalAuthorityConfiguration(Boolean removeExternalAuthorityConfiguration) {
            this.removeExternalAuthorityConfiguration = removeExternalAuthorityConfiguration;
        }

        @Override
        public final Builder removeExternalAuthorityConfiguration(Boolean removeExternalAuthorityConfiguration) {
            this.removeExternalAuthorityConfiguration = removeExternalAuthorityConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamScopeRequest build() {
            return new ModifyIpamScopeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
