/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIpamPrefixListResolverTargetRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyIpamPrefixListResolverTargetRequest.Builder, ModifyIpamPrefixListResolverTargetRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyIpamPrefixListResolverTargetRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPrefixListResolverTargetId")
            .getter(getter(ModifyIpamPrefixListResolverTargetRequest::ipamPrefixListResolverTargetId))
            .setter(setter(Builder::ipamPrefixListResolverTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverTargetId")
                    .unmarshallLocationName("IpamPrefixListResolverTargetId").build()).build();

    private static final SdkField<Long> DESIRED_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("DesiredVersion")
            .getter(getter(ModifyIpamPrefixListResolverTargetRequest::desiredVersion))
            .setter(setter(Builder::desiredVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredVersion")
                    .unmarshallLocationName("DesiredVersion").build()).build();

    private static final SdkField<Boolean> TRACK_LATEST_VERSION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TrackLatestVersion")
            .getter(getter(ModifyIpamPrefixListResolverTargetRequest::trackLatestVersion))
            .setter(setter(Builder::trackLatestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackLatestVersion")
                    .unmarshallLocationName("TrackLatestVersion").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ModifyIpamPrefixListResolverTargetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD, DESIRED_VERSION_FIELD, TRACK_LATEST_VERSION_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String ipamPrefixListResolverTargetId;

    private final Long desiredVersion;

    private final Boolean trackLatestVersion;

    private final String clientToken;

    private ModifyIpamPrefixListResolverTargetRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPrefixListResolverTargetId = builder.ipamPrefixListResolverTargetId;
        this.desiredVersion = builder.desiredVersion;
        this.trackLatestVersion = builder.trackLatestVersion;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the IPAM prefix list resolver target to modify.
     * </p>
     * 
     * @return The ID of the IPAM prefix list resolver target to modify.
     */
    public final String ipamPrefixListResolverTargetId() {
        return ipamPrefixListResolverTargetId;
    }

    /**
     * <p>
     * The desired version of the prefix list to target. This allows you to pin the target to a specific version.
     * </p>
     * 
     * @return The desired version of the prefix list to target. This allows you to pin the target to a specific
     *         version.
     */
    public final Long desiredVersion() {
        return desiredVersion;
    }

    /**
     * <p>
     * Indicates whether the resolver target should automatically track the latest version of the prefix list. When
     * enabled, the target will always synchronize with the most current version.
     * </p>
     * <p>
     * Choose this for automatic updates when you want your prefix lists to stay current with infrastructure changes
     * without manual intervention.
     * </p>
     * 
     * @return Indicates whether the resolver target should automatically track the latest version of the prefix list.
     *         When enabled, the target will always synchronize with the most current version.</p>
     *         <p>
     *         Choose this for automatic updates when you want your prefix lists to stay current with infrastructure
     *         changes without manual intervention.
     */
    public final Boolean trackLatestVersion() {
        return trackLatestVersion;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPrefixListResolverTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(desiredVersion());
        hashCode = 31 * hashCode + Objects.hashCode(trackLatestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamPrefixListResolverTargetRequest)) {
            return false;
        }
        ModifyIpamPrefixListResolverTargetRequest other = (ModifyIpamPrefixListResolverTargetRequest) obj;
        return Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(ipamPrefixListResolverTargetId(), other.ipamPrefixListResolverTargetId())
                && Objects.equals(desiredVersion(), other.desiredVersion())
                && Objects.equals(trackLatestVersion(), other.trackLatestVersion())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIpamPrefixListResolverTargetRequest").add("DryRun", dryRun())
                .add("IpamPrefixListResolverTargetId", ipamPrefixListResolverTargetId()).add("DesiredVersion", desiredVersion())
                .add("TrackLatestVersion", trackLatestVersion()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "IpamPrefixListResolverTargetId":
            return Optional.ofNullable(clazz.cast(ipamPrefixListResolverTargetId()));
        case "DesiredVersion":
            return Optional.ofNullable(clazz.cast(desiredVersion()));
        case "TrackLatestVersion":
            return Optional.ofNullable(clazz.cast(trackLatestVersion()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamPrefixListResolverTargetId", IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD);
        map.put("DesiredVersion", DESIRED_VERSION_FIELD);
        map.put("TrackLatestVersion", TRACK_LATEST_VERSION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamPrefixListResolverTargetRequest, T> g) {
        return obj -> g.apply((ModifyIpamPrefixListResolverTargetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyIpamPrefixListResolverTargetRequest> {
        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the IPAM prefix list resolver target to modify.
         * </p>
         * 
         * @param ipamPrefixListResolverTargetId
         *        The ID of the IPAM prefix list resolver target to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPrefixListResolverTargetId(String ipamPrefixListResolverTargetId);

        /**
         * <p>
         * The desired version of the prefix list to target. This allows you to pin the target to a specific version.
         * </p>
         * 
         * @param desiredVersion
         *        The desired version of the prefix list to target. This allows you to pin the target to a specific
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredVersion(Long desiredVersion);

        /**
         * <p>
         * Indicates whether the resolver target should automatically track the latest version of the prefix list. When
         * enabled, the target will always synchronize with the most current version.
         * </p>
         * <p>
         * Choose this for automatic updates when you want your prefix lists to stay current with infrastructure changes
         * without manual intervention.
         * </p>
         * 
         * @param trackLatestVersion
         *        Indicates whether the resolver target should automatically track the latest version of the prefix
         *        list. When enabled, the target will always synchronize with the most current version.</p>
         *        <p>
         *        Choose this for automatic updates when you want your prefix lists to stay current with infrastructure
         *        changes without manual intervention.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackLatestVersion(Boolean trackLatestVersion);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String ipamPrefixListResolverTargetId;

        private Long desiredVersion;

        private Boolean trackLatestVersion;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamPrefixListResolverTargetRequest model) {
            super(model);
            dryRun(model.dryRun);
            ipamPrefixListResolverTargetId(model.ipamPrefixListResolverTargetId);
            desiredVersion(model.desiredVersion);
            trackLatestVersion(model.trackLatestVersion);
            clientToken(model.clientToken);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPrefixListResolverTargetId() {
            return ipamPrefixListResolverTargetId;
        }

        public final void setIpamPrefixListResolverTargetId(String ipamPrefixListResolverTargetId) {
            this.ipamPrefixListResolverTargetId = ipamPrefixListResolverTargetId;
        }

        @Override
        public final Builder ipamPrefixListResolverTargetId(String ipamPrefixListResolverTargetId) {
            this.ipamPrefixListResolverTargetId = ipamPrefixListResolverTargetId;
            return this;
        }

        public final Long getDesiredVersion() {
            return desiredVersion;
        }

        public final void setDesiredVersion(Long desiredVersion) {
            this.desiredVersion = desiredVersion;
        }

        @Override
        public final Builder desiredVersion(Long desiredVersion) {
            this.desiredVersion = desiredVersion;
            return this;
        }

        public final Boolean getTrackLatestVersion() {
            return trackLatestVersion;
        }

        public final void setTrackLatestVersion(Boolean trackLatestVersion) {
            this.trackLatestVersion = trackLatestVersion;
        }

        @Override
        public final Builder trackLatestVersion(Boolean trackLatestVersion) {
            this.trackLatestVersion = trackLatestVersion;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamPrefixListResolverTargetRequest build() {
            return new ModifyIpamPrefixListResolverTargetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
