/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device for an EBS volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateEbsBlockDevice implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchTemplateEbsBlockDevice.Builder, LaunchTemplateEbsBlockDevice> {
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted")
            .getter(getter(LaunchTemplateEbsBlockDevice::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted")
                    .unmarshallLocationName("encrypted").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(LaunchTemplateEbsBlockDevice::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination")
                    .unmarshallLocationName("deleteOnTermination").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Iops")
            .getter(getter(LaunchTemplateEbsBlockDevice::iops))
            .setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops")
                    .unmarshallLocationName("iops").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId")
            .getter(getter(LaunchTemplateEbsBlockDevice::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId")
                    .unmarshallLocationName("kmsKeyId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(LaunchTemplateEbsBlockDevice::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSize")
            .getter(getter(LaunchTemplateEbsBlockDevice::volumeSize))
            .setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize")
                    .unmarshallLocationName("volumeSize").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeType")
            .getter(getter(LaunchTemplateEbsBlockDevice::volumeTypeAsString))
            .setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType")
                    .unmarshallLocationName("volumeType").build()).build();

    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Throughput")
            .getter(getter(LaunchTemplateEbsBlockDevice::throughput))
            .setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput")
                    .unmarshallLocationName("throughput").build()).build();

    private static final SdkField<Integer> VOLUME_INITIALIZATION_RATE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeInitializationRate")
            .getter(getter(LaunchTemplateEbsBlockDevice::volumeInitializationRate))
            .setter(setter(Builder::volumeInitializationRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeInitializationRate")
                    .unmarshallLocationName("volumeInitializationRate").build()).build();

    private static final SdkField<Integer> EBS_CARD_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("EbsCardIndex")
            .getter(getter(LaunchTemplateEbsBlockDevice::ebsCardIndex))
            .setter(setter(Builder::ebsCardIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsCardIndex")
                    .unmarshallLocationName("ebsCardIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTED_FIELD,
            DELETE_ON_TERMINATION_FIELD, IOPS_FIELD, KMS_KEY_ID_FIELD, SNAPSHOT_ID_FIELD, VOLUME_SIZE_FIELD, VOLUME_TYPE_FIELD,
            THROUGHPUT_FIELD, VOLUME_INITIALIZATION_RATE_FIELD, EBS_CARD_INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean encrypted;

    private final Boolean deleteOnTermination;

    private final Integer iops;

    private final String kmsKeyId;

    private final String snapshotId;

    private final Integer volumeSize;

    private final String volumeType;

    private final Integer throughput;

    private final Integer volumeInitializationRate;

    private final Integer ebsCardIndex;

    private LaunchTemplateEbsBlockDevice(BuilderImpl builder) {
        this.encrypted = builder.encrypted;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.iops = builder.iops;
        this.kmsKeyId = builder.kmsKeyId;
        this.snapshotId = builder.snapshotId;
        this.volumeSize = builder.volumeSize;
        this.volumeType = builder.volumeType;
        this.throughput = builder.throughput;
        this.volumeInitializationRate = builder.volumeInitializationRate;
        this.ebsCardIndex = builder.ebsCardIndex;
    }

    /**
     * <p>
     * Indicates whether the EBS volume is encrypted.
     * </p>
     * 
     * @return Indicates whether the EBS volume is encrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * Indicates whether the EBS volume is deleted on instance termination.
     * </p>
     * 
     * @return Indicates whether the EBS volume is deleted on instance termination.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The number of I/O operations per second (IOPS) that the volume supports.
     * </p>
     * 
     * @return The number of I/O operations per second (IOPS) that the volume supports.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * Identifier (key ID, key alias, key ARN, or alias ARN) of the customer managed KMS key to use for EBS encryption.
     * </p>
     * 
     * @return Identifier (key ID, key alias, key ARN, or alias ARN) of the customer managed KMS key to use for EBS
     *         encryption.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The size of the volume, in GiB.
     * </p>
     * 
     * @return The size of the volume, in GiB.
     */
    public final Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * The volume type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type.
     * @see VolumeType
     */
    public final VolumeType volumeType() {
        return VolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * The volume type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type.
     * @see VolumeType
     */
    public final String volumeTypeAsString() {
        return volumeType;
    }

    /**
     * <p>
     * The throughput that the volume supports, in MiB/s.
     * </p>
     * 
     * @return The throughput that the volume supports, in MiB/s.
     */
    public final Integer throughput() {
        return throughput;
    }

    /**
     * <p>
     * The Amazon EBS Provisioned Rate for Volume Initialization (volume initialization rate) specified for the volume,
     * in MiB/s. If no volume initialization rate was specified, the value is <code>null</code>.
     * </p>
     * 
     * @return The Amazon EBS Provisioned Rate for Volume Initialization (volume initialization rate) specified for the
     *         volume, in MiB/s. If no volume initialization rate was specified, the value is <code>null</code>.
     */
    public final Integer volumeInitializationRate() {
        return volumeInitializationRate;
    }

    /**
     * <p>
     * The index of the EBS card. Some instance types support multiple EBS cards. The default EBS card index is 0.
     * </p>
     * 
     * @return The index of the EBS card. Some instance types support multiple EBS cards. The default EBS card index is
     *         0.
     */
    public final Integer ebsCardIndex() {
        return ebsCardIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        hashCode = 31 * hashCode + Objects.hashCode(volumeInitializationRate());
        hashCode = 31 * hashCode + Objects.hashCode(ebsCardIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateEbsBlockDevice)) {
            return false;
        }
        LaunchTemplateEbsBlockDevice other = (LaunchTemplateEbsBlockDevice) obj;
        return Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(iops(), other.iops())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(volumeSize(), other.volumeSize())
                && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString())
                && Objects.equals(throughput(), other.throughput())
                && Objects.equals(volumeInitializationRate(), other.volumeInitializationRate())
                && Objects.equals(ebsCardIndex(), other.ebsCardIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchTemplateEbsBlockDevice").add("Encrypted", encrypted())
                .add("DeleteOnTermination", deleteOnTermination()).add("Iops", iops()).add("KmsKeyId", kmsKeyId())
                .add("SnapshotId", snapshotId()).add("VolumeSize", volumeSize()).add("VolumeType", volumeTypeAsString())
                .add("Throughput", throughput()).add("VolumeInitializationRate", volumeInitializationRate())
                .add("EbsCardIndex", ebsCardIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        case "Throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        case "VolumeInitializationRate":
            return Optional.ofNullable(clazz.cast(volumeInitializationRate()));
        case "EbsCardIndex":
            return Optional.ofNullable(clazz.cast(ebsCardIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("VolumeSize", VOLUME_SIZE_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        map.put("VolumeInitializationRate", VOLUME_INITIALIZATION_RATE_FIELD);
        map.put("EbsCardIndex", EBS_CARD_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateEbsBlockDevice, T> g) {
        return obj -> g.apply((LaunchTemplateEbsBlockDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplateEbsBlockDevice> {
        /**
         * <p>
         * Indicates whether the EBS volume is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the EBS volume is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * Indicates whether the EBS volume is deleted on instance termination.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the EBS volume is deleted on instance termination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The number of I/O operations per second (IOPS) that the volume supports.
         * </p>
         * 
         * @param iops
         *        The number of I/O operations per second (IOPS) that the volume supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * Identifier (key ID, key alias, key ARN, or alias ARN) of the customer managed KMS key to use for EBS
         * encryption.
         * </p>
         * 
         * @param kmsKeyId
         *        Identifier (key ID, key alias, key ARN, or alias ARN) of the customer managed KMS key to use for EBS
         *        encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The size of the volume, in GiB.
         * </p>
         * 
         * @param volumeSize
         *        The size of the volume, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * The volume type.
         * </p>
         * 
         * @param volumeType
         *        The volume type.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The volume type.
         * </p>
         * 
         * @param volumeType
         *        The volume type.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);

        /**
         * <p>
         * The throughput that the volume supports, in MiB/s.
         * </p>
         * 
         * @param throughput
         *        The throughput that the volume supports, in MiB/s.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Integer throughput);

        /**
         * <p>
         * The Amazon EBS Provisioned Rate for Volume Initialization (volume initialization rate) specified for the
         * volume, in MiB/s. If no volume initialization rate was specified, the value is <code>null</code>.
         * </p>
         * 
         * @param volumeInitializationRate
         *        The Amazon EBS Provisioned Rate for Volume Initialization (volume initialization rate) specified for
         *        the volume, in MiB/s. If no volume initialization rate was specified, the value is <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeInitializationRate(Integer volumeInitializationRate);

        /**
         * <p>
         * The index of the EBS card. Some instance types support multiple EBS cards. The default EBS card index is 0.
         * </p>
         * 
         * @param ebsCardIndex
         *        The index of the EBS card. Some instance types support multiple EBS cards. The default EBS card index
         *        is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsCardIndex(Integer ebsCardIndex);
    }

    static final class BuilderImpl implements Builder {
        private Boolean encrypted;

        private Boolean deleteOnTermination;

        private Integer iops;

        private String kmsKeyId;

        private String snapshotId;

        private Integer volumeSize;

        private String volumeType;

        private Integer throughput;

        private Integer volumeInitializationRate;

        private Integer ebsCardIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateEbsBlockDevice model) {
            encrypted(model.encrypted);
            deleteOnTermination(model.deleteOnTermination);
            iops(model.iops);
            kmsKeyId(model.kmsKeyId);
            snapshotId(model.snapshotId);
            volumeSize(model.volumeSize);
            volumeType(model.volumeType);
            throughput(model.throughput);
            volumeInitializationRate(model.volumeInitializationRate);
            ebsCardIndex(model.ebsCardIndex);
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final Integer getThroughput() {
            return throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final Integer getVolumeInitializationRate() {
            return volumeInitializationRate;
        }

        public final void setVolumeInitializationRate(Integer volumeInitializationRate) {
            this.volumeInitializationRate = volumeInitializationRate;
        }

        @Override
        public final Builder volumeInitializationRate(Integer volumeInitializationRate) {
            this.volumeInitializationRate = volumeInitializationRate;
            return this;
        }

        public final Integer getEbsCardIndex() {
            return ebsCardIndex;
        }

        public final void setEbsCardIndex(Integer ebsCardIndex) {
            this.ebsCardIndex = ebsCardIndex;
        }

        @Override
        public final Builder ebsCardIndex(Integer ebsCardIndex) {
            this.ebsCardIndex = ebsCardIndex;
            return this;
        }

        @Override
        public LaunchTemplateEbsBlockDevice build() {
            return new LaunchTemplateEbsBlockDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
