/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a secondary interface specification for launching an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceSecondaryInterfaceSpecificationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceSecondaryInterfaceSpecificationRequest.Builder, InstanceSecondaryInterfaceSpecificationRequest> {
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(InstanceSecondaryInterfaceSpecificationRequest::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination")
                    .unmarshallLocationName("DeleteOnTermination").build()).build();

    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeviceIndex")
            .getter(getter(InstanceSecondaryInterfaceSpecificationRequest::deviceIndex))
            .setter(setter(Builder::deviceIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex")
                    .unmarshallLocationName("DeviceIndex").build()).build();

    private static final SdkField<List<InstanceSecondaryInterfacePrivateIpAddressRequest>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<InstanceSecondaryInterfacePrivateIpAddressRequest>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(InstanceSecondaryInterfaceSpecificationRequest::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("PrivateIpAddress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceSecondaryInterfacePrivateIpAddressRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceSecondaryInterfacePrivateIpAddressRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PrivateIpAddressCount")
            .getter(getter(InstanceSecondaryInterfaceSpecificationRequest::privateIpAddressCount))
            .setter(setter(Builder::privateIpAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddressCount")
                    .unmarshallLocationName("PrivateIpAddressCount").build()).build();

    private static final SdkField<String> SECONDARY_SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondarySubnetId")
            .getter(getter(InstanceSecondaryInterfaceSpecificationRequest::secondarySubnetId))
            .setter(setter(Builder::secondarySubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondarySubnetId")
                    .unmarshallLocationName("SecondarySubnetId").build()).build();

    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InterfaceType")
            .getter(getter(InstanceSecondaryInterfaceSpecificationRequest::interfaceTypeAsString))
            .setter(setter(Builder::interfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType")
                    .unmarshallLocationName("InterfaceType").build()).build();

    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkCardIndex")
            .getter(getter(InstanceSecondaryInterfaceSpecificationRequest::networkCardIndex))
            .setter(setter(Builder::networkCardIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex")
                    .unmarshallLocationName("NetworkCardIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETE_ON_TERMINATION_FIELD,
            DEVICE_INDEX_FIELD, PRIVATE_IP_ADDRESSES_FIELD, PRIVATE_IP_ADDRESS_COUNT_FIELD, SECONDARY_SUBNET_ID_FIELD,
            INTERFACE_TYPE_FIELD, NETWORK_CARD_INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean deleteOnTermination;

    private final Integer deviceIndex;

    private final List<InstanceSecondaryInterfacePrivateIpAddressRequest> privateIpAddresses;

    private final Integer privateIpAddressCount;

    private final String secondarySubnetId;

    private final String interfaceType;

    private final Integer networkCardIndex;

    private InstanceSecondaryInterfaceSpecificationRequest(BuilderImpl builder) {
        this.deleteOnTermination = builder.deleteOnTermination;
        this.deviceIndex = builder.deviceIndex;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.privateIpAddressCount = builder.privateIpAddressCount;
        this.secondarySubnetId = builder.secondarySubnetId;
        this.interfaceType = builder.interfaceType;
        this.networkCardIndex = builder.networkCardIndex;
    }

    /**
     * <p>
     * Indicates whether the secondary interface is deleted when the instance is terminated.
     * </p>
     * <p>
     * The only supported value for this field is <code>true</code>.
     * </p>
     * 
     * @return Indicates whether the secondary interface is deleted when the instance is terminated.</p>
     *         <p>
     *         The only supported value for this field is <code>true</code>.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The device index for the secondary interface attachment.
     * </p>
     * 
     * @return The device index for the secondary interface attachment.
     */
    public final Integer deviceIndex() {
        return deviceIndex;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateIpAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The private IPv4 addresses to assign to the secondary interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateIpAddresses} method.
     * </p>
     * 
     * @return The private IPv4 addresses to assign to the secondary interface.
     */
    public final List<InstanceSecondaryInterfacePrivateIpAddressRequest> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The number of private IPv4 addresses to assign to the secondary interface.
     * </p>
     * 
     * @return The number of private IPv4 addresses to assign to the secondary interface.
     */
    public final Integer privateIpAddressCount() {
        return privateIpAddressCount;
    }

    /**
     * <p>
     * The ID of the secondary subnet.
     * </p>
     * 
     * @return The ID of the secondary subnet.
     */
    public final String secondarySubnetId() {
        return secondarySubnetId;
    }

    /**
     * <p>
     * The type of secondary interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceType}
     * will return {@link SecondaryInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interfaceTypeAsString}.
     * </p>
     * 
     * @return The type of secondary interface.
     * @see SecondaryInterfaceType
     */
    public final SecondaryInterfaceType interfaceType() {
        return SecondaryInterfaceType.fromValue(interfaceType);
    }

    /**
     * <p>
     * The type of secondary interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceType}
     * will return {@link SecondaryInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interfaceTypeAsString}.
     * </p>
     * 
     * @return The type of secondary interface.
     * @see SecondaryInterfaceType
     */
    public final String interfaceTypeAsString() {
        return interfaceType;
    }

    /**
     * <p>
     * The index of the network card. The network card must support secondary interfaces.
     * </p>
     * 
     * @return The index of the network card. The network card must support secondary interfaces.
     */
    public final Integer networkCardIndex() {
        return networkCardIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(secondarySubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(networkCardIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSecondaryInterfaceSpecificationRequest)) {
            return false;
        }
        InstanceSecondaryInterfaceSpecificationRequest other = (InstanceSecondaryInterfaceSpecificationRequest) obj;
        return Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(deviceIndex(), other.deviceIndex()) && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(privateIpAddressCount(), other.privateIpAddressCount())
                && Objects.equals(secondarySubnetId(), other.secondarySubnetId())
                && Objects.equals(interfaceTypeAsString(), other.interfaceTypeAsString())
                && Objects.equals(networkCardIndex(), other.networkCardIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceSecondaryInterfaceSpecificationRequest")
                .add("DeleteOnTermination", deleteOnTermination()).add("DeviceIndex", deviceIndex())
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null)
                .add("PrivateIpAddressCount", privateIpAddressCount()).add("SecondarySubnetId", secondarySubnetId())
                .add("InterfaceType", interfaceTypeAsString()).add("NetworkCardIndex", networkCardIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "DeviceIndex":
            return Optional.ofNullable(clazz.cast(deviceIndex()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "PrivateIpAddressCount":
            return Optional.ofNullable(clazz.cast(privateIpAddressCount()));
        case "SecondarySubnetId":
            return Optional.ofNullable(clazz.cast(secondarySubnetId()));
        case "InterfaceType":
            return Optional.ofNullable(clazz.cast(interfaceTypeAsString()));
        case "NetworkCardIndex":
            return Optional.ofNullable(clazz.cast(networkCardIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        map.put("DeviceIndex", DEVICE_INDEX_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESSES_FIELD);
        map.put("PrivateIpAddressCount", PRIVATE_IP_ADDRESS_COUNT_FIELD);
        map.put("SecondarySubnetId", SECONDARY_SUBNET_ID_FIELD);
        map.put("InterfaceType", INTERFACE_TYPE_FIELD);
        map.put("NetworkCardIndex", NETWORK_CARD_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceSecondaryInterfaceSpecificationRequest, T> g) {
        return obj -> g.apply((InstanceSecondaryInterfaceSpecificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceSecondaryInterfaceSpecificationRequest> {
        /**
         * <p>
         * Indicates whether the secondary interface is deleted when the instance is terminated.
         * </p>
         * <p>
         * The only supported value for this field is <code>true</code>.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the secondary interface is deleted when the instance is terminated.</p>
         *        <p>
         *        The only supported value for this field is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The device index for the secondary interface attachment.
         * </p>
         * 
         * @param deviceIndex
         *        The device index for the secondary interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        /**
         * <p>
         * The private IPv4 addresses to assign to the secondary interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        The private IPv4 addresses to assign to the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<InstanceSecondaryInterfacePrivateIpAddressRequest> privateIpAddresses);

        /**
         * <p>
         * The private IPv4 addresses to assign to the secondary interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        The private IPv4 addresses to assign to the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(InstanceSecondaryInterfacePrivateIpAddressRequest... privateIpAddresses);

        /**
         * <p>
         * The private IPv4 addresses to assign to the secondary interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterfacePrivateIpAddressRequest.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterfacePrivateIpAddressRequest#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterfacePrivateIpAddressRequest.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #privateIpAddresses(List<InstanceSecondaryInterfacePrivateIpAddressRequest>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterfacePrivateIpAddressRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(java.util.Collection<InstanceSecondaryInterfacePrivateIpAddressRequest>)
         */
        Builder privateIpAddresses(Consumer<InstanceSecondaryInterfacePrivateIpAddressRequest.Builder>... privateIpAddresses);

        /**
         * <p>
         * The number of private IPv4 addresses to assign to the secondary interface.
         * </p>
         * 
         * @param privateIpAddressCount
         *        The number of private IPv4 addresses to assign to the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddressCount(Integer privateIpAddressCount);

        /**
         * <p>
         * The ID of the secondary subnet.
         * </p>
         * 
         * @param secondarySubnetId
         *        The ID of the secondary subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySubnetId(String secondarySubnetId);

        /**
         * <p>
         * The type of secondary interface.
         * </p>
         * 
         * @param interfaceType
         *        The type of secondary interface.
         * @see SecondaryInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryInterfaceType
         */
        Builder interfaceType(String interfaceType);

        /**
         * <p>
         * The type of secondary interface.
         * </p>
         * 
         * @param interfaceType
         *        The type of secondary interface.
         * @see SecondaryInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryInterfaceType
         */
        Builder interfaceType(SecondaryInterfaceType interfaceType);

        /**
         * <p>
         * The index of the network card. The network card must support secondary interfaces.
         * </p>
         * 
         * @param networkCardIndex
         *        The index of the network card. The network card must support secondary interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkCardIndex(Integer networkCardIndex);
    }

    static final class BuilderImpl implements Builder {
        private Boolean deleteOnTermination;

        private Integer deviceIndex;

        private List<InstanceSecondaryInterfacePrivateIpAddressRequest> privateIpAddresses = DefaultSdkAutoConstructList
                .getInstance();

        private Integer privateIpAddressCount;

        private String secondarySubnetId;

        private String interfaceType;

        private Integer networkCardIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSecondaryInterfaceSpecificationRequest model) {
            deleteOnTermination(model.deleteOnTermination);
            deviceIndex(model.deviceIndex);
            privateIpAddresses(model.privateIpAddresses);
            privateIpAddressCount(model.privateIpAddressCount);
            secondarySubnetId(model.secondarySubnetId);
            interfaceType(model.interfaceType);
            networkCardIndex(model.networkCardIndex);
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final List<InstanceSecondaryInterfacePrivateIpAddressRequest.Builder> getPrivateIpAddresses() {
            List<InstanceSecondaryInterfacePrivateIpAddressRequest.Builder> result = InstanceSecondaryInterfacePrivateIpAddressListRequestCopier
                    .copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(
                Collection<InstanceSecondaryInterfacePrivateIpAddressRequest.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = InstanceSecondaryInterfacePrivateIpAddressListRequestCopier
                    .copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<InstanceSecondaryInterfacePrivateIpAddressRequest> privateIpAddresses) {
            this.privateIpAddresses = InstanceSecondaryInterfacePrivateIpAddressListRequestCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(InstanceSecondaryInterfacePrivateIpAddressRequest... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(
                Consumer<InstanceSecondaryInterfacePrivateIpAddressRequest.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream.of(privateIpAddresses)
                    .map(c -> InstanceSecondaryInterfacePrivateIpAddressRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getPrivateIpAddressCount() {
            return privateIpAddressCount;
        }

        public final void setPrivateIpAddressCount(Integer privateIpAddressCount) {
            this.privateIpAddressCount = privateIpAddressCount;
        }

        @Override
        public final Builder privateIpAddressCount(Integer privateIpAddressCount) {
            this.privateIpAddressCount = privateIpAddressCount;
            return this;
        }

        public final String getSecondarySubnetId() {
            return secondarySubnetId;
        }

        public final void setSecondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
        }

        @Override
        public final Builder secondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
            return this;
        }

        public final String getInterfaceType() {
            return interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        @Override
        public final Builder interfaceType(SecondaryInterfaceType interfaceType) {
            this.interfaceType(interfaceType == null ? null : interfaceType.toString());
            return this;
        }

        public final Integer getNetworkCardIndex() {
            return networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        @Override
        public InstanceSecondaryInterfaceSpecificationRequest build() {
            return new InstanceSecondaryInterfaceSpecificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
