/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIpamPolicyOrganizationTargetsResponse extends Ec2Response implements
        ToCopyableBuilder<GetIpamPolicyOrganizationTargetsResponse.Builder, GetIpamPolicyOrganizationTargetsResponse> {
    private static final SdkField<List<IpamPolicyOrganizationTarget>> ORGANIZATION_TARGETS_FIELD = SdkField
            .<List<IpamPolicyOrganizationTarget>> builder(MarshallingType.LIST)
            .memberName("OrganizationTargets")
            .getter(getter(GetIpamPolicyOrganizationTargetsResponse::organizationTargets))
            .setter(setter(Builder::organizationTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationTargetSet")
                    .unmarshallLocationName("organizationTargetSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpamPolicyOrganizationTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpamPolicyOrganizationTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetIpamPolicyOrganizationTargetsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_TARGETS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<IpamPolicyOrganizationTarget> organizationTargets;

    private final String nextToken;

    private GetIpamPolicyOrganizationTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.organizationTargets = builder.organizationTargets;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationTargets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrganizationTargets() {
        return organizationTargets != null && !(organizationTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Amazon Web Services Organizations targets.
     * </p>
     * <p>
     * A target can be an individual Amazon Web Services account or an entity within an Amazon Web Services Organization
     * to which an IPAM policy can be applied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationTargets} method.
     * </p>
     * 
     * @return The IDs of the Amazon Web Services Organizations targets.</p>
     *         <p>
     *         A target can be an individual Amazon Web Services account or an entity within an Amazon Web Services
     *         Organization to which an IPAM policy can be applied.
     */
    public final List<IpamPolicyOrganizationTarget> organizationTargets() {
        return organizationTargets;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationTargets() ? organizationTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamPolicyOrganizationTargetsResponse)) {
            return false;
        }
        GetIpamPolicyOrganizationTargetsResponse other = (GetIpamPolicyOrganizationTargetsResponse) obj;
        return hasOrganizationTargets() == other.hasOrganizationTargets()
                && Objects.equals(organizationTargets(), other.organizationTargets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIpamPolicyOrganizationTargetsResponse")
                .add("OrganizationTargets", hasOrganizationTargets() ? organizationTargets() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationTargets":
            return Optional.ofNullable(clazz.cast(organizationTargets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationTargetSet", ORGANIZATION_TARGETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIpamPolicyOrganizationTargetsResponse, T> g) {
        return obj -> g.apply((GetIpamPolicyOrganizationTargetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIpamPolicyOrganizationTargetsResponse> {
        /**
         * <p>
         * The IDs of the Amazon Web Services Organizations targets.
         * </p>
         * <p>
         * A target can be an individual Amazon Web Services account or an entity within an Amazon Web Services
         * Organization to which an IPAM policy can be applied.
         * </p>
         * 
         * @param organizationTargets
         *        The IDs of the Amazon Web Services Organizations targets.</p>
         *        <p>
         *        A target can be an individual Amazon Web Services account or an entity within an Amazon Web Services
         *        Organization to which an IPAM policy can be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationTargets(Collection<IpamPolicyOrganizationTarget> organizationTargets);

        /**
         * <p>
         * The IDs of the Amazon Web Services Organizations targets.
         * </p>
         * <p>
         * A target can be an individual Amazon Web Services account or an entity within an Amazon Web Services
         * Organization to which an IPAM policy can be applied.
         * </p>
         * 
         * @param organizationTargets
         *        The IDs of the Amazon Web Services Organizations targets.</p>
         *        <p>
         *        A target can be an individual Amazon Web Services account or an entity within an Amazon Web Services
         *        Organization to which an IPAM policy can be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationTargets(IpamPolicyOrganizationTarget... organizationTargets);

        /**
         * <p>
         * The IDs of the Amazon Web Services Organizations targets.
         * </p>
         * <p>
         * A target can be an individual Amazon Web Services account or an entity within an Amazon Web Services
         * Organization to which an IPAM policy can be applied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpamPolicyOrganizationTarget.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.IpamPolicyOrganizationTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpamPolicyOrganizationTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #organizationTargets(List<IpamPolicyOrganizationTarget>)}.
         * 
         * @param organizationTargets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpamPolicyOrganizationTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationTargets(java.util.Collection<IpamPolicyOrganizationTarget>)
         */
        Builder organizationTargets(Consumer<IpamPolicyOrganizationTarget.Builder>... organizationTargets);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<IpamPolicyOrganizationTarget> organizationTargets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamPolicyOrganizationTargetsResponse model) {
            super(model);
            organizationTargets(model.organizationTargets);
            nextToken(model.nextToken);
        }

        public final List<IpamPolicyOrganizationTarget.Builder> getOrganizationTargets() {
            List<IpamPolicyOrganizationTarget.Builder> result = IpamPolicyOrganizationTargetSetCopier
                    .copyToBuilder(this.organizationTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationTargets(Collection<IpamPolicyOrganizationTarget.BuilderImpl> organizationTargets) {
            this.organizationTargets = IpamPolicyOrganizationTargetSetCopier.copyFromBuilder(organizationTargets);
        }

        @Override
        public final Builder organizationTargets(Collection<IpamPolicyOrganizationTarget> organizationTargets) {
            this.organizationTargets = IpamPolicyOrganizationTargetSetCopier.copy(organizationTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationTargets(IpamPolicyOrganizationTarget... organizationTargets) {
            organizationTargets(Arrays.asList(organizationTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationTargets(Consumer<IpamPolicyOrganizationTarget.Builder>... organizationTargets) {
            organizationTargets(Stream.of(organizationTargets)
                    .map(c -> IpamPolicyOrganizationTarget.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetIpamPolicyOrganizationTargetsResponse build() {
            return new GetIpamPolicyOrganizationTargetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
