/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the IAM SAML identity providers used for federated authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FederatedAuthentication implements SdkPojo, Serializable,
        ToCopyableBuilder<FederatedAuthentication.Builder, FederatedAuthentication> {
    private static final SdkField<String> SAML_PROVIDER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SamlProviderArn")
            .getter(getter(FederatedAuthentication::samlProviderArn))
            .setter(setter(Builder::samlProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamlProviderArn")
                    .unmarshallLocationName("samlProviderArn").build()).build();

    private static final SdkField<String> SELF_SERVICE_SAML_PROVIDER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SelfServiceSamlProviderArn")
            .getter(getter(FederatedAuthentication::selfServiceSamlProviderArn))
            .setter(setter(Builder::selfServiceSamlProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfServiceSamlProviderArn")
                    .unmarshallLocationName("selfServiceSamlProviderArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_PROVIDER_ARN_FIELD,
            SELF_SERVICE_SAML_PROVIDER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String samlProviderArn;

    private final String selfServiceSamlProviderArn;

    private FederatedAuthentication(BuilderImpl builder) {
        this.samlProviderArn = builder.samlProviderArn;
        this.selfServiceSamlProviderArn = builder.selfServiceSamlProviderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM SAML identity provider.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM SAML identity provider.
     */
    public final String samlProviderArn() {
        return samlProviderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM SAML identity provider for the self-service portal.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM SAML identity provider for the self-service portal.
     */
    public final String selfServiceSamlProviderArn() {
        return selfServiceSamlProviderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(samlProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(selfServiceSamlProviderArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FederatedAuthentication)) {
            return false;
        }
        FederatedAuthentication other = (FederatedAuthentication) obj;
        return Objects.equals(samlProviderArn(), other.samlProviderArn())
                && Objects.equals(selfServiceSamlProviderArn(), other.selfServiceSamlProviderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FederatedAuthentication").add("SamlProviderArn", samlProviderArn())
                .add("SelfServiceSamlProviderArn", selfServiceSamlProviderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SamlProviderArn":
            return Optional.ofNullable(clazz.cast(samlProviderArn()));
        case "SelfServiceSamlProviderArn":
            return Optional.ofNullable(clazz.cast(selfServiceSamlProviderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SamlProviderArn", SAML_PROVIDER_ARN_FIELD);
        map.put("SelfServiceSamlProviderArn", SELF_SERVICE_SAML_PROVIDER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FederatedAuthentication, T> g) {
        return obj -> g.apply((FederatedAuthentication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FederatedAuthentication> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM SAML identity provider.
         * </p>
         * 
         * @param samlProviderArn
         *        The Amazon Resource Name (ARN) of the IAM SAML identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlProviderArn(String samlProviderArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM SAML identity provider for the self-service portal.
         * </p>
         * 
         * @param selfServiceSamlProviderArn
         *        The Amazon Resource Name (ARN) of the IAM SAML identity provider for the self-service portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfServiceSamlProviderArn(String selfServiceSamlProviderArn);
    }

    static final class BuilderImpl implements Builder {
        private String samlProviderArn;

        private String selfServiceSamlProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(FederatedAuthentication model) {
            samlProviderArn(model.samlProviderArn);
            selfServiceSamlProviderArn(model.selfServiceSamlProviderArn);
        }

        public final String getSamlProviderArn() {
            return samlProviderArn;
        }

        public final void setSamlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
        }

        @Override
        public final Builder samlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
            return this;
        }

        public final String getSelfServiceSamlProviderArn() {
            return selfServiceSamlProviderArn;
        }

        public final void setSelfServiceSamlProviderArn(String selfServiceSamlProviderArn) {
            this.selfServiceSamlProviderArn = selfServiceSamlProviderArn;
        }

        @Override
        public final Builder selfServiceSamlProviderArn(String selfServiceSamlProviderArn) {
            this.selfServiceSamlProviderArn = selfServiceSamlProviderArn;
            return this;
        }

        @Override
        public FederatedAuthentication build() {
            return new FederatedAuthentication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
