/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityManagerDimension;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.MetricDimensionResultSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCapacityManagerMetricDimensionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetCapacityManagerMetricDimensionsResponse> {
    private static final SdkField<List<CapacityManagerDimension>> METRIC_DIMENSION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricDimensionResults").getter(GetCapacityManagerMetricDimensionsResponse.getter(GetCapacityManagerMetricDimensionsResponse::metricDimensionResults)).setter(GetCapacityManagerMetricDimensionsResponse.setter(Builder::metricDimensionResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDimensionResultSet").unmarshallLocationName("metricDimensionResultSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityManagerDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCapacityManagerMetricDimensionsResponse.getter(GetCapacityManagerMetricDimensionsResponse::nextToken)).setter(GetCapacityManagerMetricDimensionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DIMENSION_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCapacityManagerMetricDimensionsResponse.memberNameToFieldInitializer();
    private final List<CapacityManagerDimension> metricDimensionResults;
    private final String nextToken;

    private GetCapacityManagerMetricDimensionsResponse(BuilderImpl builder) {
        super(builder);
        this.metricDimensionResults = builder.metricDimensionResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMetricDimensionResults() {
        return this.metricDimensionResults != null && !(this.metricDimensionResults instanceof SdkAutoConstructList);
    }

    public final List<CapacityManagerDimension> metricDimensionResults() {
        return this.metricDimensionResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDimensionResults() ? this.metricDimensionResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCapacityManagerMetricDimensionsResponse)) {
            return false;
        }
        GetCapacityManagerMetricDimensionsResponse other = (GetCapacityManagerMetricDimensionsResponse)((Object)obj);
        return this.hasMetricDimensionResults() == other.hasMetricDimensionResults() && Objects.equals(this.metricDimensionResults(), other.metricDimensionResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetCapacityManagerMetricDimensionsResponse").add("MetricDimensionResults", this.hasMetricDimensionResults() ? this.metricDimensionResults() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricDimensionResults": {
                return Optional.ofNullable(clazz.cast(this.metricDimensionResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricDimensionResultSet", METRIC_DIMENSION_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCapacityManagerMetricDimensionsResponse, T> g) {
        return obj -> g.apply((GetCapacityManagerMetricDimensionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CapacityManagerDimension> metricDimensionResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCapacityManagerMetricDimensionsResponse model) {
            super(model);
            this.metricDimensionResults(model.metricDimensionResults);
            this.nextToken(model.nextToken);
        }

        public final List<CapacityManagerDimension.Builder> getMetricDimensionResults() {
            List<CapacityManagerDimension.Builder> result = MetricDimensionResultSetCopier.copyToBuilder(this.metricDimensionResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDimensionResults(Collection<CapacityManagerDimension.BuilderImpl> metricDimensionResults) {
            this.metricDimensionResults = MetricDimensionResultSetCopier.copyFromBuilder(metricDimensionResults);
        }

        @Override
        public final Builder metricDimensionResults(Collection<CapacityManagerDimension> metricDimensionResults) {
            this.metricDimensionResults = MetricDimensionResultSetCopier.copy(metricDimensionResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDimensionResults(CapacityManagerDimension ... metricDimensionResults) {
            this.metricDimensionResults(Arrays.asList(metricDimensionResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDimensionResults(Consumer<CapacityManagerDimension.Builder> ... metricDimensionResults) {
            this.metricDimensionResults(Stream.of(metricDimensionResults).map(c -> (CapacityManagerDimension)((CapacityManagerDimension.Builder)CapacityManagerDimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCapacityManagerMetricDimensionsResponse build() {
            return new GetCapacityManagerMetricDimensionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCapacityManagerMetricDimensionsResponse> {
        public Builder metricDimensionResults(Collection<CapacityManagerDimension> var1);

        public Builder metricDimensionResults(CapacityManagerDimension ... var1);

        public Builder metricDimensionResults(Consumer<CapacityManagerDimension.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

