/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.HostOffering;

public class DescribeHostReservationOfferingsPublisher
implements SdkPublisher<DescribeHostReservationOfferingsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeHostReservationOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeHostReservationOfferingsPublisher(Ec2AsyncClient client, DescribeHostReservationOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeHostReservationOfferingsPublisher(Ec2AsyncClient client, DescribeHostReservationOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeHostReservationOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeHostReservationOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HostOffering> offeringSet() {
        return this.flatMapIterable(response -> response.offeringSet());
    }

    private class DescribeHostReservationOfferingsResponseFetcher
    implements AsyncPageFetcher<DescribeHostReservationOfferingsResponse> {
        private DescribeHostReservationOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHostReservationOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeHostReservationOfferingsResponse> nextPage(DescribeHostReservationOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeHostReservationOfferingsPublisher.this.client.describeHostReservationOfferings(DescribeHostReservationOfferingsPublisher.this.firstRequest);
            }
            return DescribeHostReservationOfferingsPublisher.this.client.describeHostReservationOfferings((DescribeHostReservationOfferingsRequest)((Object)DescribeHostReservationOfferingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

