/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CarrierGateway;
import software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse;

public class DescribeCarrierGatewaysPublisher
implements SdkPublisher<DescribeCarrierGatewaysResponse> {
    private final Ec2AsyncClient client;
    private final DescribeCarrierGatewaysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCarrierGatewaysPublisher(Ec2AsyncClient client, DescribeCarrierGatewaysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCarrierGatewaysPublisher(Ec2AsyncClient client, DescribeCarrierGatewaysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCarrierGatewaysResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCarrierGatewaysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CarrierGateway> carrierGateways() {
        return this.flatMapIterable(response -> response.carrierGateways());
    }

    private class DescribeCarrierGatewaysResponseFetcher
    implements AsyncPageFetcher<DescribeCarrierGatewaysResponse> {
        private DescribeCarrierGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCarrierGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCarrierGatewaysResponse> nextPage(DescribeCarrierGatewaysResponse previousPage) {
            if (previousPage == null) {
                return DescribeCarrierGatewaysPublisher.this.client.describeCarrierGateways(DescribeCarrierGatewaysPublisher.this.firstRequest);
            }
            return DescribeCarrierGatewaysPublisher.this.client.describeCarrierGateways((DescribeCarrierGatewaysRequest)((Object)DescribeCarrierGatewaysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

