/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.SecondaryNetworkType;
import software.amazon.awssdk.services.ec2.model.SecondarySubnetIpv4CidrBlockAssociation;
import software.amazon.awssdk.services.ec2.model.SecondarySubnetIpv4CidrBlockAssociationListCopier;
import software.amazon.awssdk.services.ec2.model.SecondarySubnetState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecondarySubnet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecondarySubnet> {
    private static final SdkField<String> SECONDARY_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondarySubnetId").getter(SecondarySubnet.getter(SecondarySubnet::secondarySubnetId)).setter(SecondarySubnet.setter(Builder::secondarySubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondarySubnetId").unmarshallLocationName("secondarySubnetId").build()}).build();
    private static final SdkField<String> SECONDARY_SUBNET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondarySubnetArn").getter(SecondarySubnet.getter(SecondarySubnet::secondarySubnetArn)).setter(SecondarySubnet.setter(Builder::secondarySubnetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondarySubnetArn").unmarshallLocationName("secondarySubnetArn").build()}).build();
    private static final SdkField<String> SECONDARY_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryNetworkId").getter(SecondarySubnet.getter(SecondarySubnet::secondaryNetworkId)).setter(SecondarySubnet.setter(Builder::secondaryNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkId").unmarshallLocationName("secondaryNetworkId").build()}).build();
    private static final SdkField<String> SECONDARY_NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryNetworkType").getter(SecondarySubnet.getter(SecondarySubnet::secondaryNetworkTypeAsString)).setter(SecondarySubnet.setter(Builder::secondaryNetworkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkType").unmarshallLocationName("secondaryNetworkType").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(SecondarySubnet.getter(SecondarySubnet::ownerId)).setter(SecondarySubnet.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(SecondarySubnet.getter(SecondarySubnet::availabilityZoneId)).setter(SecondarySubnet.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(SecondarySubnet.getter(SecondarySubnet::availabilityZone)).setter(SecondarySubnet.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<List<SecondarySubnetIpv4CidrBlockAssociation>> IPV4_CIDR_BLOCK_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv4CidrBlockAssociations").getter(SecondarySubnet.getter(SecondarySubnet::ipv4CidrBlockAssociations)).setter(SecondarySubnet.setter(Builder::ipv4CidrBlockAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4CidrBlockAssociationSet").unmarshallLocationName("ipv4CidrBlockAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecondarySubnetIpv4CidrBlockAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(SecondarySubnet.getter(SecondarySubnet::stateAsString)).setter(SecondarySubnet.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(SecondarySubnet.getter(SecondarySubnet::stateReason)).setter(SecondarySubnet.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").unmarshallLocationName("stateReason").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SecondarySubnet.getter(SecondarySubnet::tags)).setter(SecondarySubnet.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECONDARY_SUBNET_ID_FIELD, SECONDARY_SUBNET_ARN_FIELD, SECONDARY_NETWORK_ID_FIELD, SECONDARY_NETWORK_TYPE_FIELD, OWNER_ID_FIELD, AVAILABILITY_ZONE_ID_FIELD, AVAILABILITY_ZONE_FIELD, IPV4_CIDR_BLOCK_ASSOCIATIONS_FIELD, STATE_FIELD, STATE_REASON_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SecondarySubnet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String secondarySubnetId;
    private final String secondarySubnetArn;
    private final String secondaryNetworkId;
    private final String secondaryNetworkType;
    private final String ownerId;
    private final String availabilityZoneId;
    private final String availabilityZone;
    private final List<SecondarySubnetIpv4CidrBlockAssociation> ipv4CidrBlockAssociations;
    private final String state;
    private final String stateReason;
    private final List<Tag> tags;

    private SecondarySubnet(BuilderImpl builder) {
        this.secondarySubnetId = builder.secondarySubnetId;
        this.secondarySubnetArn = builder.secondarySubnetArn;
        this.secondaryNetworkId = builder.secondaryNetworkId;
        this.secondaryNetworkType = builder.secondaryNetworkType;
        this.ownerId = builder.ownerId;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.availabilityZone = builder.availabilityZone;
        this.ipv4CidrBlockAssociations = builder.ipv4CidrBlockAssociations;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
    }

    public final String secondarySubnetId() {
        return this.secondarySubnetId;
    }

    public final String secondarySubnetArn() {
        return this.secondarySubnetArn;
    }

    public final String secondaryNetworkId() {
        return this.secondaryNetworkId;
    }

    public final SecondaryNetworkType secondaryNetworkType() {
        return SecondaryNetworkType.fromValue(this.secondaryNetworkType);
    }

    public final String secondaryNetworkTypeAsString() {
        return this.secondaryNetworkType;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final boolean hasIpv4CidrBlockAssociations() {
        return this.ipv4CidrBlockAssociations != null && !(this.ipv4CidrBlockAssociations instanceof SdkAutoConstructList);
    }

    public final List<SecondarySubnetIpv4CidrBlockAssociation> ipv4CidrBlockAssociations() {
        return this.ipv4CidrBlockAssociations;
    }

    public final SecondarySubnetState state() {
        return SecondarySubnetState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secondarySubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondarySubnetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryNetworkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv4CidrBlockAssociations() ? this.ipv4CidrBlockAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecondarySubnet)) {
            return false;
        }
        SecondarySubnet other = (SecondarySubnet)obj;
        return Objects.equals(this.secondarySubnetId(), other.secondarySubnetId()) && Objects.equals(this.secondarySubnetArn(), other.secondarySubnetArn()) && Objects.equals(this.secondaryNetworkId(), other.secondaryNetworkId()) && Objects.equals(this.secondaryNetworkTypeAsString(), other.secondaryNetworkTypeAsString()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && this.hasIpv4CidrBlockAssociations() == other.hasIpv4CidrBlockAssociations() && Objects.equals(this.ipv4CidrBlockAssociations(), other.ipv4CidrBlockAssociations()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SecondarySubnet").add("SecondarySubnetId", (Object)this.secondarySubnetId()).add("SecondarySubnetArn", (Object)this.secondarySubnetArn()).add("SecondaryNetworkId", (Object)this.secondaryNetworkId()).add("SecondaryNetworkType", (Object)this.secondaryNetworkTypeAsString()).add("OwnerId", (Object)this.ownerId()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Ipv4CidrBlockAssociations", this.hasIpv4CidrBlockAssociations() ? this.ipv4CidrBlockAssociations() : null).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecondarySubnetId": {
                return Optional.ofNullable(clazz.cast(this.secondarySubnetId()));
            }
            case "SecondarySubnetArn": {
                return Optional.ofNullable(clazz.cast(this.secondarySubnetArn()));
            }
            case "SecondaryNetworkId": {
                return Optional.ofNullable(clazz.cast(this.secondaryNetworkId()));
            }
            case "SecondaryNetworkType": {
                return Optional.ofNullable(clazz.cast(this.secondaryNetworkTypeAsString()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Ipv4CidrBlockAssociations": {
                return Optional.ofNullable(clazz.cast(this.ipv4CidrBlockAssociations()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SecondarySubnetId", SECONDARY_SUBNET_ID_FIELD);
        map.put("SecondarySubnetArn", SECONDARY_SUBNET_ARN_FIELD);
        map.put("SecondaryNetworkId", SECONDARY_NETWORK_ID_FIELD);
        map.put("SecondaryNetworkType", SECONDARY_NETWORK_TYPE_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("Ipv4CidrBlockAssociationSet", IPV4_CIDR_BLOCK_ASSOCIATIONS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecondarySubnet, T> g) {
        return obj -> g.apply((SecondarySubnet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String secondarySubnetId;
        private String secondarySubnetArn;
        private String secondaryNetworkId;
        private String secondaryNetworkType;
        private String ownerId;
        private String availabilityZoneId;
        private String availabilityZone;
        private List<SecondarySubnetIpv4CidrBlockAssociation> ipv4CidrBlockAssociations = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private String stateReason;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecondarySubnet model) {
            this.secondarySubnetId(model.secondarySubnetId);
            this.secondarySubnetArn(model.secondarySubnetArn);
            this.secondaryNetworkId(model.secondaryNetworkId);
            this.secondaryNetworkType(model.secondaryNetworkType);
            this.ownerId(model.ownerId);
            this.availabilityZoneId(model.availabilityZoneId);
            this.availabilityZone(model.availabilityZone);
            this.ipv4CidrBlockAssociations(model.ipv4CidrBlockAssociations);
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.tags(model.tags);
        }

        public final String getSecondarySubnetId() {
            return this.secondarySubnetId;
        }

        public final void setSecondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
        }

        @Override
        public final Builder secondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
            return this;
        }

        public final String getSecondarySubnetArn() {
            return this.secondarySubnetArn;
        }

        public final void setSecondarySubnetArn(String secondarySubnetArn) {
            this.secondarySubnetArn = secondarySubnetArn;
        }

        @Override
        public final Builder secondarySubnetArn(String secondarySubnetArn) {
            this.secondarySubnetArn = secondarySubnetArn;
            return this;
        }

        public final String getSecondaryNetworkId() {
            return this.secondaryNetworkId;
        }

        public final void setSecondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
        }

        @Override
        public final Builder secondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
            return this;
        }

        public final String getSecondaryNetworkType() {
            return this.secondaryNetworkType;
        }

        public final void setSecondaryNetworkType(String secondaryNetworkType) {
            this.secondaryNetworkType = secondaryNetworkType;
        }

        @Override
        public final Builder secondaryNetworkType(String secondaryNetworkType) {
            this.secondaryNetworkType = secondaryNetworkType;
            return this;
        }

        @Override
        public final Builder secondaryNetworkType(SecondaryNetworkType secondaryNetworkType) {
            this.secondaryNetworkType(secondaryNetworkType == null ? null : secondaryNetworkType.toString());
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final List<SecondarySubnetIpv4CidrBlockAssociation.Builder> getIpv4CidrBlockAssociations() {
            List<SecondarySubnetIpv4CidrBlockAssociation.Builder> result = SecondarySubnetIpv4CidrBlockAssociationListCopier.copyToBuilder(this.ipv4CidrBlockAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4CidrBlockAssociations(Collection<SecondarySubnetIpv4CidrBlockAssociation.BuilderImpl> ipv4CidrBlockAssociations) {
            this.ipv4CidrBlockAssociations = SecondarySubnetIpv4CidrBlockAssociationListCopier.copyFromBuilder(ipv4CidrBlockAssociations);
        }

        @Override
        public final Builder ipv4CidrBlockAssociations(Collection<SecondarySubnetIpv4CidrBlockAssociation> ipv4CidrBlockAssociations) {
            this.ipv4CidrBlockAssociations = SecondarySubnetIpv4CidrBlockAssociationListCopier.copy(ipv4CidrBlockAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4CidrBlockAssociations(SecondarySubnetIpv4CidrBlockAssociation ... ipv4CidrBlockAssociations) {
            this.ipv4CidrBlockAssociations(Arrays.asList(ipv4CidrBlockAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4CidrBlockAssociations(Consumer<SecondarySubnetIpv4CidrBlockAssociation.Builder> ... ipv4CidrBlockAssociations) {
            this.ipv4CidrBlockAssociations(Stream.of(ipv4CidrBlockAssociations).map(c -> (SecondarySubnetIpv4CidrBlockAssociation)((SecondarySubnetIpv4CidrBlockAssociation.Builder)SecondarySubnetIpv4CidrBlockAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SecondarySubnetState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SecondarySubnet build() {
            return new SecondarySubnet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecondarySubnet> {
        public Builder secondarySubnetId(String var1);

        public Builder secondarySubnetArn(String var1);

        public Builder secondaryNetworkId(String var1);

        public Builder secondaryNetworkType(String var1);

        public Builder secondaryNetworkType(SecondaryNetworkType var1);

        public Builder ownerId(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder availabilityZone(String var1);

        public Builder ipv4CidrBlockAssociations(Collection<SecondarySubnetIpv4CidrBlockAssociation> var1);

        public Builder ipv4CidrBlockAssociations(SecondarySubnetIpv4CidrBlockAssociation ... var1);

        public Builder ipv4CidrBlockAssociations(Consumer<SecondarySubnetIpv4CidrBlockAssociation.Builder> ... var1);

        public Builder state(String var1);

        public Builder state(SecondarySubnetState var1);

        public Builder stateReason(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

