/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SecondaryNetwork;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSecondaryNetworkResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DeleteSecondaryNetworkResponse> {
    private static final SdkField<SecondaryNetwork> SECONDARY_NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecondaryNetwork").getter(DeleteSecondaryNetworkResponse.getter(DeleteSecondaryNetworkResponse::secondaryNetwork)).setter(DeleteSecondaryNetworkResponse.setter(Builder::secondaryNetwork)).constructor(SecondaryNetwork::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetwork").unmarshallLocationName("secondaryNetwork").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(DeleteSecondaryNetworkResponse.getter(DeleteSecondaryNetworkResponse::clientToken)).setter(DeleteSecondaryNetworkResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECONDARY_NETWORK_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteSecondaryNetworkResponse.memberNameToFieldInitializer();
    private final SecondaryNetwork secondaryNetwork;
    private final String clientToken;

    private DeleteSecondaryNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.secondaryNetwork = builder.secondaryNetwork;
        this.clientToken = builder.clientToken;
    }

    public final SecondaryNetwork secondaryNetwork() {
        return this.secondaryNetwork;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSecondaryNetworkResponse)) {
            return false;
        }
        DeleteSecondaryNetworkResponse other = (DeleteSecondaryNetworkResponse)((Object)obj);
        return Objects.equals(this.secondaryNetwork(), other.secondaryNetwork()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteSecondaryNetworkResponse").add("SecondaryNetwork", (Object)this.secondaryNetwork()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecondaryNetwork": {
                return Optional.ofNullable(clazz.cast(this.secondaryNetwork()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SecondaryNetwork", SECONDARY_NETWORK_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSecondaryNetworkResponse, T> g) {
        return obj -> g.apply((DeleteSecondaryNetworkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private SecondaryNetwork secondaryNetwork;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSecondaryNetworkResponse model) {
            super(model);
            this.secondaryNetwork(model.secondaryNetwork);
            this.clientToken(model.clientToken);
        }

        public final SecondaryNetwork.Builder getSecondaryNetwork() {
            return this.secondaryNetwork != null ? this.secondaryNetwork.toBuilder() : null;
        }

        public final void setSecondaryNetwork(SecondaryNetwork.BuilderImpl secondaryNetwork) {
            this.secondaryNetwork = secondaryNetwork != null ? secondaryNetwork.build() : null;
        }

        @Override
        public final Builder secondaryNetwork(SecondaryNetwork secondaryNetwork) {
            this.secondaryNetwork = secondaryNetwork;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public DeleteSecondaryNetworkResponse build() {
            return new DeleteSecondaryNetworkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteSecondaryNetworkResponse> {
        public Builder secondaryNetwork(SecondaryNetwork var1);

        default public Builder secondaryNetwork(Consumer<SecondaryNetwork.Builder> secondaryNetwork) {
            return this.secondaryNetwork((SecondaryNetwork)((SecondaryNetwork.Builder)SecondaryNetwork.builder().applyMutation(secondaryNetwork)).build());
        }

        public Builder clientToken(String var1);
    }
}

