/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a secondary interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecondaryInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<SecondaryInterface.Builder, SecondaryInterface> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(SecondaryInterface::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(SecondaryInterface::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("availabilityZoneId").build()).build();

    private static final SdkField<SecondaryInterfaceAttachment> ATTACHMENT_FIELD = SdkField
            .<SecondaryInterfaceAttachment> builder(MarshallingType.SDK_POJO)
            .memberName("Attachment")
            .getter(getter(SecondaryInterface::attachment))
            .setter(setter(Builder::attachment))
            .constructor(SecondaryInterfaceAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment")
                    .unmarshallLocationName("attachment").build()).build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MacAddress")
            .getter(getter(SecondaryInterface::macAddress))
            .setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress")
                    .unmarshallLocationName("macAddress").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(SecondaryInterface::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<List<SecondaryInterfaceIpv4Address>> PRIVATE_IPV4_ADDRESSES_FIELD = SdkField
            .<List<SecondaryInterfaceIpv4Address>> builder(MarshallingType.LIST)
            .memberName("PrivateIpv4Addresses")
            .getter(getter(SecondaryInterface::privateIpv4Addresses))
            .setter(setter(Builder::privateIpv4Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpv4AddressSet")
                    .unmarshallLocationName("privateIpv4AddressSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SecondaryInterfaceIpv4Address> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecondaryInterfaceIpv4Address::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SECONDARY_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondaryInterfaceId")
            .getter(getter(SecondaryInterface::secondaryInterfaceId))
            .setter(setter(Builder::secondaryInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryInterfaceId")
                    .unmarshallLocationName("secondaryInterfaceId").build()).build();

    private static final SdkField<String> SECONDARY_INTERFACE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondaryInterfaceArn")
            .getter(getter(SecondaryInterface::secondaryInterfaceArn))
            .setter(setter(Builder::secondaryInterfaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryInterfaceArn")
                    .unmarshallLocationName("secondaryInterfaceArn").build()).build();

    private static final SdkField<String> SECONDARY_INTERFACE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondaryInterfaceType")
            .getter(getter(SecondaryInterface::secondaryInterfaceTypeAsString))
            .setter(setter(Builder::secondaryInterfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryInterfaceType")
                    .unmarshallLocationName("secondaryInterfaceType").build()).build();

    private static final SdkField<String> SECONDARY_SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondarySubnetId")
            .getter(getter(SecondaryInterface::secondarySubnetId))
            .setter(setter(Builder::secondarySubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondarySubnetId")
                    .unmarshallLocationName("secondarySubnetId").build()).build();

    private static final SdkField<String> SECONDARY_NETWORK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondaryNetworkId")
            .getter(getter(SecondaryInterface::secondaryNetworkId))
            .setter(setter(Builder::secondaryNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkId")
                    .unmarshallLocationName("secondaryNetworkId").build()).build();

    private static final SdkField<String> SECONDARY_NETWORK_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondaryNetworkType")
            .getter(getter(SecondaryInterface::secondaryNetworkTypeAsString))
            .setter(setter(Builder::secondaryNetworkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkType")
                    .unmarshallLocationName("secondaryNetworkType").build()).build();

    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SourceDestCheck")
            .getter(getter(SecondaryInterface::sourceDestCheck))
            .setter(setter(Builder::sourceDestCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck")
                    .unmarshallLocationName("sourceDestCheck").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(SecondaryInterface::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(SecondaryInterface::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            AVAILABILITY_ZONE_ID_FIELD, ATTACHMENT_FIELD, MAC_ADDRESS_FIELD, OWNER_ID_FIELD, PRIVATE_IPV4_ADDRESSES_FIELD,
            SECONDARY_INTERFACE_ID_FIELD, SECONDARY_INTERFACE_ARN_FIELD, SECONDARY_INTERFACE_TYPE_FIELD,
            SECONDARY_SUBNET_ID_FIELD, SECONDARY_NETWORK_ID_FIELD, SECONDARY_NETWORK_TYPE_FIELD, SOURCE_DEST_CHECK_FIELD,
            STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final SecondaryInterfaceAttachment attachment;

    private final String macAddress;

    private final String ownerId;

    private final List<SecondaryInterfaceIpv4Address> privateIpv4Addresses;

    private final String secondaryInterfaceId;

    private final String secondaryInterfaceArn;

    private final String secondaryInterfaceType;

    private final String secondarySubnetId;

    private final String secondaryNetworkId;

    private final String secondaryNetworkType;

    private final Boolean sourceDestCheck;

    private final String status;

    private final List<Tag> tags;

    private SecondaryInterface(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.attachment = builder.attachment;
        this.macAddress = builder.macAddress;
        this.ownerId = builder.ownerId;
        this.privateIpv4Addresses = builder.privateIpv4Addresses;
        this.secondaryInterfaceId = builder.secondaryInterfaceId;
        this.secondaryInterfaceArn = builder.secondaryInterfaceArn;
        this.secondaryInterfaceType = builder.secondaryInterfaceType;
        this.secondarySubnetId = builder.secondarySubnetId;
        this.secondaryNetworkId = builder.secondaryNetworkId;
        this.secondaryNetworkType = builder.secondaryNetworkType;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Availability Zone of the secondary interface.
     * </p>
     * 
     * @return The Availability Zone of the secondary interface.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The ID of the Availability Zone of the secondary interface.
     * </p>
     * 
     * @return The ID of the Availability Zone of the secondary interface.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The attachment information for the secondary interface.
     * </p>
     * 
     * @return The attachment information for the secondary interface.
     */
    public final SecondaryInterfaceAttachment attachment() {
        return attachment;
    }

    /**
     * <p>
     * The MAC address of the secondary interface.
     * </p>
     * 
     * @return The MAC address of the secondary interface.
     */
    public final String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the secondary interface.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the secondary interface.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateIpv4Addresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateIpv4Addresses() {
        return privateIpv4Addresses != null && !(privateIpv4Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The private IPv4 addresses associated with the secondary interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateIpv4Addresses} method.
     * </p>
     * 
     * @return The private IPv4 addresses associated with the secondary interface.
     */
    public final List<SecondaryInterfaceIpv4Address> privateIpv4Addresses() {
        return privateIpv4Addresses;
    }

    /**
     * <p>
     * The ID of the secondary interface.
     * </p>
     * 
     * @return The ID of the secondary interface.
     */
    public final String secondaryInterfaceId() {
        return secondaryInterfaceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the secondary interface.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the secondary interface.
     */
    public final String secondaryInterfaceArn() {
        return secondaryInterfaceArn;
    }

    /**
     * <p>
     * The type of secondary interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #secondaryInterfaceType} will return {@link SecondaryInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #secondaryInterfaceTypeAsString}.
     * </p>
     * 
     * @return The type of secondary interface.
     * @see SecondaryInterfaceType
     */
    public final SecondaryInterfaceType secondaryInterfaceType() {
        return SecondaryInterfaceType.fromValue(secondaryInterfaceType);
    }

    /**
     * <p>
     * The type of secondary interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #secondaryInterfaceType} will return {@link SecondaryInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #secondaryInterfaceTypeAsString}.
     * </p>
     * 
     * @return The type of secondary interface.
     * @see SecondaryInterfaceType
     */
    public final String secondaryInterfaceTypeAsString() {
        return secondaryInterfaceType;
    }

    /**
     * <p>
     * The ID of the secondary subnet.
     * </p>
     * 
     * @return The ID of the secondary subnet.
     */
    public final String secondarySubnetId() {
        return secondarySubnetId;
    }

    /**
     * <p>
     * The ID of the secondary network.
     * </p>
     * 
     * @return The ID of the secondary network.
     */
    public final String secondaryNetworkId() {
        return secondaryNetworkId;
    }

    /**
     * <p>
     * The type of the secondary network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #secondaryNetworkType} will return {@link SecondaryNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #secondaryNetworkTypeAsString}.
     * </p>
     * 
     * @return The type of the secondary network.
     * @see SecondaryNetworkType
     */
    public final SecondaryNetworkType secondaryNetworkType() {
        return SecondaryNetworkType.fromValue(secondaryNetworkType);
    }

    /**
     * <p>
     * The type of the secondary network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #secondaryNetworkType} will return {@link SecondaryNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #secondaryNetworkTypeAsString}.
     * </p>
     * 
     * @return The type of the secondary network.
     * @see SecondaryNetworkType
     */
    public final String secondaryNetworkTypeAsString() {
        return secondaryNetworkType;
    }

    /**
     * <p>
     * Indicates whether source/destination checking is enabled.
     * </p>
     * 
     * @return Indicates whether source/destination checking is enabled.
     */
    public final Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * The status of the secondary interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SecondaryInterfaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the secondary interface.
     * @see SecondaryInterfaceStatus
     */
    public final SecondaryInterfaceStatus status() {
        return SecondaryInterfaceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the secondary interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SecondaryInterfaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the secondary interface.
     * @see SecondaryInterfaceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the secondary interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the secondary interface.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpv4Addresses() ? privateIpv4Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secondaryInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryInterfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secondarySubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryNetworkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecondaryInterface)) {
            return false;
        }
        SecondaryInterface other = (SecondaryInterface) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(attachment(), other.attachment()) && Objects.equals(macAddress(), other.macAddress())
                && Objects.equals(ownerId(), other.ownerId()) && hasPrivateIpv4Addresses() == other.hasPrivateIpv4Addresses()
                && Objects.equals(privateIpv4Addresses(), other.privateIpv4Addresses())
                && Objects.equals(secondaryInterfaceId(), other.secondaryInterfaceId())
                && Objects.equals(secondaryInterfaceArn(), other.secondaryInterfaceArn())
                && Objects.equals(secondaryInterfaceTypeAsString(), other.secondaryInterfaceTypeAsString())
                && Objects.equals(secondarySubnetId(), other.secondarySubnetId())
                && Objects.equals(secondaryNetworkId(), other.secondaryNetworkId())
                && Objects.equals(secondaryNetworkTypeAsString(), other.secondaryNetworkTypeAsString())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecondaryInterface").add("AvailabilityZone", availabilityZone())
                .add("AvailabilityZoneId", availabilityZoneId()).add("Attachment", attachment()).add("MacAddress", macAddress())
                .add("OwnerId", ownerId()).add("PrivateIpv4Addresses", hasPrivateIpv4Addresses() ? privateIpv4Addresses() : null)
                .add("SecondaryInterfaceId", secondaryInterfaceId()).add("SecondaryInterfaceArn", secondaryInterfaceArn())
                .add("SecondaryInterfaceType", secondaryInterfaceTypeAsString()).add("SecondarySubnetId", secondarySubnetId())
                .add("SecondaryNetworkId", secondaryNetworkId()).add("SecondaryNetworkType", secondaryNetworkTypeAsString())
                .add("SourceDestCheck", sourceDestCheck()).add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "Attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        case "MacAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "PrivateIpv4Addresses":
            return Optional.ofNullable(clazz.cast(privateIpv4Addresses()));
        case "SecondaryInterfaceId":
            return Optional.ofNullable(clazz.cast(secondaryInterfaceId()));
        case "SecondaryInterfaceArn":
            return Optional.ofNullable(clazz.cast(secondaryInterfaceArn()));
        case "SecondaryInterfaceType":
            return Optional.ofNullable(clazz.cast(secondaryInterfaceTypeAsString()));
        case "SecondarySubnetId":
            return Optional.ofNullable(clazz.cast(secondarySubnetId()));
        case "SecondaryNetworkId":
            return Optional.ofNullable(clazz.cast(secondaryNetworkId()));
        case "SecondaryNetworkType":
            return Optional.ofNullable(clazz.cast(secondaryNetworkTypeAsString()));
        case "SourceDestCheck":
            return Optional.ofNullable(clazz.cast(sourceDestCheck()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("Attachment", ATTACHMENT_FIELD);
        map.put("MacAddress", MAC_ADDRESS_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("PrivateIpv4AddressSet", PRIVATE_IPV4_ADDRESSES_FIELD);
        map.put("SecondaryInterfaceId", SECONDARY_INTERFACE_ID_FIELD);
        map.put("SecondaryInterfaceArn", SECONDARY_INTERFACE_ARN_FIELD);
        map.put("SecondaryInterfaceType", SECONDARY_INTERFACE_TYPE_FIELD);
        map.put("SecondarySubnetId", SECONDARY_SUBNET_ID_FIELD);
        map.put("SecondaryNetworkId", SECONDARY_NETWORK_ID_FIELD);
        map.put("SecondaryNetworkType", SECONDARY_NETWORK_TYPE_FIELD);
        map.put("SourceDestCheck", SOURCE_DEST_CHECK_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecondaryInterface, T> g) {
        return obj -> g.apply((SecondaryInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecondaryInterface> {
        /**
         * <p>
         * The Availability Zone of the secondary interface.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The ID of the Availability Zone of the secondary interface.
         * </p>
         * 
         * @param availabilityZoneId
         *        The ID of the Availability Zone of the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The attachment information for the secondary interface.
         * </p>
         * 
         * @param attachment
         *        The attachment information for the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(SecondaryInterfaceAttachment attachment);

        /**
         * <p>
         * The attachment information for the secondary interface.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecondaryInterfaceAttachment.Builder}
         * avoiding the need to create one manually via {@link SecondaryInterfaceAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecondaryInterfaceAttachment.Builder#build()} is called
         * immediately and its result is passed to {@link #attachment(SecondaryInterfaceAttachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link SecondaryInterfaceAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(SecondaryInterfaceAttachment)
         */
        default Builder attachment(Consumer<SecondaryInterfaceAttachment.Builder> attachment) {
            return attachment(SecondaryInterfaceAttachment.builder().applyMutation(attachment).build());
        }

        /**
         * <p>
         * The MAC address of the secondary interface.
         * </p>
         * 
         * @param macAddress
         *        The MAC address of the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the secondary interface.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The private IPv4 addresses associated with the secondary interface.
         * </p>
         * 
         * @param privateIpv4Addresses
         *        The private IPv4 addresses associated with the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpv4Addresses(Collection<SecondaryInterfaceIpv4Address> privateIpv4Addresses);

        /**
         * <p>
         * The private IPv4 addresses associated with the secondary interface.
         * </p>
         * 
         * @param privateIpv4Addresses
         *        The private IPv4 addresses associated with the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpv4Addresses(SecondaryInterfaceIpv4Address... privateIpv4Addresses);

        /**
         * <p>
         * The private IPv4 addresses associated with the secondary interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SecondaryInterfaceIpv4Address.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.SecondaryInterfaceIpv4Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SecondaryInterfaceIpv4Address.Builder#build()} is called
         * immediately and its result is passed to {@link #privateIpv4Addresses(List<SecondaryInterfaceIpv4Address>)}.
         * 
         * @param privateIpv4Addresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SecondaryInterfaceIpv4Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpv4Addresses(java.util.Collection<SecondaryInterfaceIpv4Address>)
         */
        Builder privateIpv4Addresses(Consumer<SecondaryInterfaceIpv4Address.Builder>... privateIpv4Addresses);

        /**
         * <p>
         * The ID of the secondary interface.
         * </p>
         * 
         * @param secondaryInterfaceId
         *        The ID of the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryInterfaceId(String secondaryInterfaceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the secondary interface.
         * </p>
         * 
         * @param secondaryInterfaceArn
         *        The Amazon Resource Name (ARN) of the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryInterfaceArn(String secondaryInterfaceArn);

        /**
         * <p>
         * The type of secondary interface.
         * </p>
         * 
         * @param secondaryInterfaceType
         *        The type of secondary interface.
         * @see SecondaryInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryInterfaceType
         */
        Builder secondaryInterfaceType(String secondaryInterfaceType);

        /**
         * <p>
         * The type of secondary interface.
         * </p>
         * 
         * @param secondaryInterfaceType
         *        The type of secondary interface.
         * @see SecondaryInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryInterfaceType
         */
        Builder secondaryInterfaceType(SecondaryInterfaceType secondaryInterfaceType);

        /**
         * <p>
         * The ID of the secondary subnet.
         * </p>
         * 
         * @param secondarySubnetId
         *        The ID of the secondary subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySubnetId(String secondarySubnetId);

        /**
         * <p>
         * The ID of the secondary network.
         * </p>
         * 
         * @param secondaryNetworkId
         *        The ID of the secondary network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryNetworkId(String secondaryNetworkId);

        /**
         * <p>
         * The type of the secondary network.
         * </p>
         * 
         * @param secondaryNetworkType
         *        The type of the secondary network.
         * @see SecondaryNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryNetworkType
         */
        Builder secondaryNetworkType(String secondaryNetworkType);

        /**
         * <p>
         * The type of the secondary network.
         * </p>
         * 
         * @param secondaryNetworkType
         *        The type of the secondary network.
         * @see SecondaryNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryNetworkType
         */
        Builder secondaryNetworkType(SecondaryNetworkType secondaryNetworkType);

        /**
         * <p>
         * Indicates whether source/destination checking is enabled.
         * </p>
         * 
         * @param sourceDestCheck
         *        Indicates whether source/destination checking is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * The status of the secondary interface.
         * </p>
         * 
         * @param status
         *        The status of the secondary interface.
         * @see SecondaryInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryInterfaceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the secondary interface.
         * </p>
         * 
         * @param status
         *        The status of the secondary interface.
         * @see SecondaryInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryInterfaceStatus
         */
        Builder status(SecondaryInterfaceStatus status);

        /**
         * <p>
         * The tags assigned to the secondary interface.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the secondary interface.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the secondary interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String availabilityZoneId;

        private SecondaryInterfaceAttachment attachment;

        private String macAddress;

        private String ownerId;

        private List<SecondaryInterfaceIpv4Address> privateIpv4Addresses = DefaultSdkAutoConstructList.getInstance();

        private String secondaryInterfaceId;

        private String secondaryInterfaceArn;

        private String secondaryInterfaceType;

        private String secondarySubnetId;

        private String secondaryNetworkId;

        private String secondaryNetworkType;

        private Boolean sourceDestCheck;

        private String status;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecondaryInterface model) {
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            attachment(model.attachment);
            macAddress(model.macAddress);
            ownerId(model.ownerId);
            privateIpv4Addresses(model.privateIpv4Addresses);
            secondaryInterfaceId(model.secondaryInterfaceId);
            secondaryInterfaceArn(model.secondaryInterfaceArn);
            secondaryInterfaceType(model.secondaryInterfaceType);
            secondarySubnetId(model.secondarySubnetId);
            secondaryNetworkId(model.secondaryNetworkId);
            secondaryNetworkType(model.secondaryNetworkType);
            sourceDestCheck(model.sourceDestCheck);
            status(model.status);
            tags(model.tags);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final SecondaryInterfaceAttachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(SecondaryInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(SecondaryInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<SecondaryInterfaceIpv4Address.Builder> getPrivateIpv4Addresses() {
            List<SecondaryInterfaceIpv4Address.Builder> result = SecondaryInterfaceIpv4AddressListCopier
                    .copyToBuilder(this.privateIpv4Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpv4Addresses(Collection<SecondaryInterfaceIpv4Address.BuilderImpl> privateIpv4Addresses) {
            this.privateIpv4Addresses = SecondaryInterfaceIpv4AddressListCopier.copyFromBuilder(privateIpv4Addresses);
        }

        @Override
        public final Builder privateIpv4Addresses(Collection<SecondaryInterfaceIpv4Address> privateIpv4Addresses) {
            this.privateIpv4Addresses = SecondaryInterfaceIpv4AddressListCopier.copy(privateIpv4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpv4Addresses(SecondaryInterfaceIpv4Address... privateIpv4Addresses) {
            privateIpv4Addresses(Arrays.asList(privateIpv4Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpv4Addresses(Consumer<SecondaryInterfaceIpv4Address.Builder>... privateIpv4Addresses) {
            privateIpv4Addresses(Stream.of(privateIpv4Addresses)
                    .map(c -> SecondaryInterfaceIpv4Address.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSecondaryInterfaceId() {
            return secondaryInterfaceId;
        }

        public final void setSecondaryInterfaceId(String secondaryInterfaceId) {
            this.secondaryInterfaceId = secondaryInterfaceId;
        }

        @Override
        public final Builder secondaryInterfaceId(String secondaryInterfaceId) {
            this.secondaryInterfaceId = secondaryInterfaceId;
            return this;
        }

        public final String getSecondaryInterfaceArn() {
            return secondaryInterfaceArn;
        }

        public final void setSecondaryInterfaceArn(String secondaryInterfaceArn) {
            this.secondaryInterfaceArn = secondaryInterfaceArn;
        }

        @Override
        public final Builder secondaryInterfaceArn(String secondaryInterfaceArn) {
            this.secondaryInterfaceArn = secondaryInterfaceArn;
            return this;
        }

        public final String getSecondaryInterfaceType() {
            return secondaryInterfaceType;
        }

        public final void setSecondaryInterfaceType(String secondaryInterfaceType) {
            this.secondaryInterfaceType = secondaryInterfaceType;
        }

        @Override
        public final Builder secondaryInterfaceType(String secondaryInterfaceType) {
            this.secondaryInterfaceType = secondaryInterfaceType;
            return this;
        }

        @Override
        public final Builder secondaryInterfaceType(SecondaryInterfaceType secondaryInterfaceType) {
            this.secondaryInterfaceType(secondaryInterfaceType == null ? null : secondaryInterfaceType.toString());
            return this;
        }

        public final String getSecondarySubnetId() {
            return secondarySubnetId;
        }

        public final void setSecondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
        }

        @Override
        public final Builder secondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
            return this;
        }

        public final String getSecondaryNetworkId() {
            return secondaryNetworkId;
        }

        public final void setSecondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
        }

        @Override
        public final Builder secondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
            return this;
        }

        public final String getSecondaryNetworkType() {
            return secondaryNetworkType;
        }

        public final void setSecondaryNetworkType(String secondaryNetworkType) {
            this.secondaryNetworkType = secondaryNetworkType;
        }

        @Override
        public final Builder secondaryNetworkType(String secondaryNetworkType) {
            this.secondaryNetworkType = secondaryNetworkType;
            return this;
        }

        @Override
        public final Builder secondaryNetworkType(SecondaryNetworkType secondaryNetworkType) {
            this.secondaryNetworkType(secondaryNetworkType == null ? null : secondaryNetworkType.toString());
            return this;
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SecondaryInterfaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SecondaryInterface build() {
            return new SecondaryInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
