/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Instance implements SdkPojo, Serializable, ToCopyableBuilder<Instance.Builder, Instance> {
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Architecture")
            .getter(getter(Instance::architectureAsString))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture")
                    .unmarshallLocationName("architecture").build()).build();

    private static final SdkField<List<InstanceBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<InstanceBlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(Instance::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("blockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceBlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceBlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(Instance::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized")
            .getter(getter(Instance::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("ebsOptimized").build()).build();

    private static final SdkField<Boolean> ENA_SUPPORT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnaSupport")
            .getter(getter(Instance::enaSupport))
            .setter(setter(Builder::enaSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport")
                    .unmarshallLocationName("enaSupport").build()).build();

    private static final SdkField<String> HYPERVISOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Hypervisor")
            .getter(getter(Instance::hypervisorAsString))
            .setter(setter(Builder::hypervisor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisor")
                    .unmarshallLocationName("hypervisor").build()).build();

    private static final SdkField<IamInstanceProfile> IAM_INSTANCE_PROFILE_FIELD = SdkField
            .<IamInstanceProfile> builder(MarshallingType.SDK_POJO)
            .memberName("IamInstanceProfile")
            .getter(getter(Instance::iamInstanceProfile))
            .setter(setter(Builder::iamInstanceProfile))
            .constructor(IamInstanceProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile")
                    .unmarshallLocationName("iamInstanceProfile").build()).build();

    private static final SdkField<String> INSTANCE_LIFECYCLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceLifecycle")
            .getter(getter(Instance::instanceLifecycleAsString))
            .setter(setter(Builder::instanceLifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceLifecycle")
                    .unmarshallLocationName("instanceLifecycle").build()).build();

    private static final SdkField<List<ElasticGpuAssociation>> ELASTIC_GPU_ASSOCIATIONS_FIELD = SdkField
            .<List<ElasticGpuAssociation>> builder(MarshallingType.LIST)
            .memberName("ElasticGpuAssociations")
            .getter(getter(Instance::elasticGpuAssociations))
            .setter(setter(Builder::elasticGpuAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuAssociationSet")
                    .unmarshallLocationName("elasticGpuAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ElasticGpuAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticGpuAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<ElasticInferenceAcceleratorAssociation>> ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATIONS_FIELD = SdkField
            .<List<ElasticInferenceAcceleratorAssociation>> builder(MarshallingType.LIST)
            .memberName("ElasticInferenceAcceleratorAssociations")
            .getter(getter(Instance::elasticInferenceAcceleratorAssociations))
            .setter(setter(Builder::elasticInferenceAcceleratorAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ElasticInferenceAcceleratorAssociationSet")
                    .unmarshallLocationName("elasticInferenceAcceleratorAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ElasticInferenceAcceleratorAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticInferenceAcceleratorAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<InstanceNetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<InstanceNetworkInterface>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaces")
            .getter(getter(Instance::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceSet")
                    .unmarshallLocationName("networkInterfaceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceNetworkInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceNetworkInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(Instance::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<String> ROOT_DEVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RootDeviceName")
            .getter(getter(Instance::rootDeviceName))
            .setter(setter(Builder::rootDeviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceName")
                    .unmarshallLocationName("rootDeviceName").build()).build();

    private static final SdkField<String> ROOT_DEVICE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RootDeviceType")
            .getter(getter(Instance::rootDeviceTypeAsString))
            .setter(setter(Builder::rootDeviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceType")
                    .unmarshallLocationName("rootDeviceType").build()).build();

    private static final SdkField<List<GroupIdentifier>> SECURITY_GROUPS_FIELD = SdkField
            .<List<GroupIdentifier>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(Instance::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet")
                    .unmarshallLocationName("groupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<GroupIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SourceDestCheck")
            .getter(getter(Instance::sourceDestCheck))
            .setter(setter(Builder::sourceDestCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck")
                    .unmarshallLocationName("sourceDestCheck").build()).build();

    private static final SdkField<String> SPOT_INSTANCE_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotInstanceRequestId")
            .getter(getter(Instance::spotInstanceRequestId))
            .setter(setter(Builder::spotInstanceRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId")
                    .unmarshallLocationName("spotInstanceRequestId").build()).build();

    private static final SdkField<String> SRIOV_NET_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SriovNetSupport")
            .getter(getter(Instance::sriovNetSupport))
            .setter(setter(Builder::sriovNetSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport")
                    .unmarshallLocationName("sriovNetSupport").build()).build();

    private static final SdkField<StateReason> STATE_REASON_FIELD = SdkField
            .<StateReason> builder(MarshallingType.SDK_POJO)
            .memberName("StateReason")
            .getter(getter(Instance::stateReason))
            .setter(setter(Builder::stateReason))
            .constructor(StateReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason")
                    .unmarshallLocationName("stateReason").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Instance::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VIRTUALIZATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VirtualizationType")
            .getter(getter(Instance::virtualizationTypeAsString))
            .setter(setter(Builder::virtualizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType")
                    .unmarshallLocationName("virtualizationType").build()).build();

    private static final SdkField<CpuOptions> CPU_OPTIONS_FIELD = SdkField
            .<CpuOptions> builder(MarshallingType.SDK_POJO)
            .memberName("CpuOptions")
            .getter(getter(Instance::cpuOptions))
            .setter(setter(Builder::cpuOptions))
            .constructor(CpuOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions")
                    .unmarshallLocationName("cpuOptions").build()).build();

    private static final SdkField<String> CAPACITY_BLOCK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityBlockId")
            .getter(getter(Instance::capacityBlockId))
            .setter(setter(Builder::capacityBlockId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockId")
                    .unmarshallLocationName("capacityBlockId").build()).build();

    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationId")
            .getter(getter(Instance::capacityReservationId))
            .setter(setter(Builder::capacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("capacityReservationId").build()).build();

    private static final SdkField<CapacityReservationSpecificationResponse> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField
            .<CapacityReservationSpecificationResponse> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityReservationSpecification")
            .getter(getter(Instance::capacityReservationSpecification))
            .setter(setter(Builder::capacityReservationSpecification))
            .constructor(CapacityReservationSpecificationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification")
                    .unmarshallLocationName("capacityReservationSpecification").build()).build();

    private static final SdkField<HibernationOptions> HIBERNATION_OPTIONS_FIELD = SdkField
            .<HibernationOptions> builder(MarshallingType.SDK_POJO)
            .memberName("HibernationOptions")
            .getter(getter(Instance::hibernationOptions))
            .setter(setter(Builder::hibernationOptions))
            .constructor(HibernationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions")
                    .unmarshallLocationName("hibernationOptions").build()).build();

    private static final SdkField<List<LicenseConfiguration>> LICENSES_FIELD = SdkField
            .<List<LicenseConfiguration>> builder(MarshallingType.LIST)
            .memberName("Licenses")
            .getter(getter(Instance::licenses))
            .setter(setter(Builder::licenses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSet")
                    .unmarshallLocationName("licenseSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LicenseConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<InstanceMetadataOptionsResponse> METADATA_OPTIONS_FIELD = SdkField
            .<InstanceMetadataOptionsResponse> builder(MarshallingType.SDK_POJO)
            .memberName("MetadataOptions")
            .getter(getter(Instance::metadataOptions))
            .setter(setter(Builder::metadataOptions))
            .constructor(InstanceMetadataOptionsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions")
                    .unmarshallLocationName("metadataOptions").build()).build();

    private static final SdkField<EnclaveOptions> ENCLAVE_OPTIONS_FIELD = SdkField
            .<EnclaveOptions> builder(MarshallingType.SDK_POJO)
            .memberName("EnclaveOptions")
            .getter(getter(Instance::enclaveOptions))
            .setter(setter(Builder::enclaveOptions))
            .constructor(EnclaveOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnclaveOptions")
                    .unmarshallLocationName("enclaveOptions").build()).build();

    private static final SdkField<String> BOOT_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BootMode")
            .getter(getter(Instance::bootModeAsString))
            .setter(setter(Builder::bootMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootMode")
                    .unmarshallLocationName("bootMode").build()).build();

    private static final SdkField<String> PLATFORM_DETAILS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PlatformDetails")
            .getter(getter(Instance::platformDetails))
            .setter(setter(Builder::platformDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformDetails")
                    .unmarshallLocationName("platformDetails").build()).build();

    private static final SdkField<String> USAGE_OPERATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UsageOperation")
            .getter(getter(Instance::usageOperation))
            .setter(setter(Builder::usageOperation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperation")
                    .unmarshallLocationName("usageOperation").build()).build();

    private static final SdkField<Instant> USAGE_OPERATION_UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UsageOperationUpdateTime")
            .getter(getter(Instance::usageOperationUpdateTime))
            .setter(setter(Builder::usageOperationUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperationUpdateTime")
                    .unmarshallLocationName("usageOperationUpdateTime").build()).build();

    private static final SdkField<PrivateDnsNameOptionsResponse> PRIVATE_DNS_NAME_OPTIONS_FIELD = SdkField
            .<PrivateDnsNameOptionsResponse> builder(MarshallingType.SDK_POJO)
            .memberName("PrivateDnsNameOptions")
            .getter(getter(Instance::privateDnsNameOptions))
            .setter(setter(Builder::privateDnsNameOptions))
            .constructor(PrivateDnsNameOptionsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameOptions")
                    .unmarshallLocationName("privateDnsNameOptions").build()).build();

    private static final SdkField<String> IPV6_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6Address")
            .getter(getter(Instance::ipv6Address))
            .setter(setter(Builder::ipv6Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Address")
                    .unmarshallLocationName("ipv6Address").build()).build();

    private static final SdkField<String> TPM_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TpmSupport")
            .getter(getter(Instance::tpmSupport))
            .setter(setter(Builder::tpmSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TpmSupport")
                    .unmarshallLocationName("tpmSupport").build()).build();

    private static final SdkField<InstanceMaintenanceOptions> MAINTENANCE_OPTIONS_FIELD = SdkField
            .<InstanceMaintenanceOptions> builder(MarshallingType.SDK_POJO)
            .memberName("MaintenanceOptions")
            .getter(getter(Instance::maintenanceOptions))
            .setter(setter(Builder::maintenanceOptions))
            .constructor(InstanceMaintenanceOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceOptions")
                    .unmarshallLocationName("maintenanceOptions").build()).build();

    private static final SdkField<String> CURRENT_INSTANCE_BOOT_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentInstanceBootMode")
            .getter(getter(Instance::currentInstanceBootModeAsString))
            .setter(setter(Builder::currentInstanceBootMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInstanceBootMode")
                    .unmarshallLocationName("currentInstanceBootMode").build()).build();

    private static final SdkField<InstanceNetworkPerformanceOptions> NETWORK_PERFORMANCE_OPTIONS_FIELD = SdkField
            .<InstanceNetworkPerformanceOptions> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkPerformanceOptions")
            .getter(getter(Instance::networkPerformanceOptions))
            .setter(setter(Builder::networkPerformanceOptions))
            .constructor(InstanceNetworkPerformanceOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPerformanceOptions")
                    .unmarshallLocationName("networkPerformanceOptions").build()).build();

    private static final SdkField<OperatorResponse> OPERATOR_FIELD = SdkField
            .<OperatorResponse> builder(MarshallingType.SDK_POJO)
            .memberName("Operator")
            .getter(getter(Instance::operator))
            .setter(setter(Builder::operator))
            .constructor(OperatorResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator")
                    .unmarshallLocationName("operator").build()).build();

    private static final SdkField<List<InstanceSecondaryInterface>> SECONDARY_INTERFACES_FIELD = SdkField
            .<List<InstanceSecondaryInterface>> builder(MarshallingType.LIST)
            .memberName("SecondaryInterfaces")
            .getter(getter(Instance::secondaryInterfaces))
            .setter(setter(Builder::secondaryInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryInterfaceSet")
                    .unmarshallLocationName("secondaryInterfaceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceSecondaryInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceSecondaryInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(Instance::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(Instance::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<InstanceState> STATE_FIELD = SdkField
            .<InstanceState> builder(MarshallingType.SDK_POJO)
            .memberName("State")
            .getter(getter(Instance::state))
            .setter(setter(Builder::state))
            .constructor(InstanceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceState")
                    .unmarshallLocationName("instanceState").build()).build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsName")
            .getter(getter(Instance::privateDnsName))
            .setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName")
                    .unmarshallLocationName("privateDnsName").build()).build();

    private static final SdkField<String> PUBLIC_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicDnsName")
            .getter(getter(Instance::publicDnsName))
            .setter(setter(Builder::publicDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName")
                    .unmarshallLocationName("dnsName").build()).build();

    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateTransitionReason")
            .getter(getter(Instance::stateTransitionReason))
            .setter(setter(Builder::stateTransitionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason")
                    .unmarshallLocationName("reason").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyName")
            .getter(getter(Instance::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("keyName").build()).build();

    private static final SdkField<Integer> AMI_LAUNCH_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AmiLaunchIndex")
            .getter(getter(Instance::amiLaunchIndex))
            .setter(setter(Builder::amiLaunchIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiLaunchIndex")
                    .unmarshallLocationName("amiLaunchIndex").build()).build();

    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField
            .<List<ProductCode>> builder(MarshallingType.LIST)
            .memberName("ProductCodes")
            .getter(getter(Instance::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes")
                    .unmarshallLocationName("productCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(Instance::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LaunchTime")
            .getter(getter(Instance::launchTime))
            .setter(setter(Builder::launchTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime")
                    .unmarshallLocationName("launchTime").build()).build();

    private static final SdkField<Placement> PLACEMENT_FIELD = SdkField
            .<Placement> builder(MarshallingType.SDK_POJO)
            .memberName("Placement")
            .getter(getter(Instance::placement))
            .setter(setter(Builder::placement))
            .constructor(Placement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement")
                    .unmarshallLocationName("placement").build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KernelId")
            .getter(getter(Instance::kernelId))
            .setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId")
                    .unmarshallLocationName("kernelId").build()).build();

    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RamdiskId")
            .getter(getter(Instance::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId")
                    .unmarshallLocationName("ramdiskId").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Platform")
            .getter(getter(Instance::platformAsString))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform")
                    .unmarshallLocationName("platform").build()).build();

    private static final SdkField<Monitoring> MONITORING_FIELD = SdkField
            .<Monitoring> builder(MarshallingType.SDK_POJO)
            .memberName("Monitoring")
            .getter(getter(Instance::monitoring))
            .setter(setter(Builder::monitoring))
            .constructor(Monitoring::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring")
                    .unmarshallLocationName("monitoring").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(Instance::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(Instance::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress")
            .getter(getter(Instance::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build()).build();

    private static final SdkField<String> PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIpAddress")
            .getter(getter(Instance::publicIpAddress))
            .setter(setter(Builder::publicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress")
                    .unmarshallLocationName("ipAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_FIELD,
            BLOCK_DEVICE_MAPPINGS_FIELD, CLIENT_TOKEN_FIELD, EBS_OPTIMIZED_FIELD, ENA_SUPPORT_FIELD, HYPERVISOR_FIELD,
            IAM_INSTANCE_PROFILE_FIELD, INSTANCE_LIFECYCLE_FIELD, ELASTIC_GPU_ASSOCIATIONS_FIELD,
            ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATIONS_FIELD, NETWORK_INTERFACES_FIELD, OUTPOST_ARN_FIELD,
            ROOT_DEVICE_NAME_FIELD, ROOT_DEVICE_TYPE_FIELD, SECURITY_GROUPS_FIELD, SOURCE_DEST_CHECK_FIELD,
            SPOT_INSTANCE_REQUEST_ID_FIELD, SRIOV_NET_SUPPORT_FIELD, STATE_REASON_FIELD, TAGS_FIELD, VIRTUALIZATION_TYPE_FIELD,
            CPU_OPTIONS_FIELD, CAPACITY_BLOCK_ID_FIELD, CAPACITY_RESERVATION_ID_FIELD, CAPACITY_RESERVATION_SPECIFICATION_FIELD,
            HIBERNATION_OPTIONS_FIELD, LICENSES_FIELD, METADATA_OPTIONS_FIELD, ENCLAVE_OPTIONS_FIELD, BOOT_MODE_FIELD,
            PLATFORM_DETAILS_FIELD, USAGE_OPERATION_FIELD, USAGE_OPERATION_UPDATE_TIME_FIELD, PRIVATE_DNS_NAME_OPTIONS_FIELD,
            IPV6_ADDRESS_FIELD, TPM_SUPPORT_FIELD, MAINTENANCE_OPTIONS_FIELD, CURRENT_INSTANCE_BOOT_MODE_FIELD,
            NETWORK_PERFORMANCE_OPTIONS_FIELD, OPERATOR_FIELD, SECONDARY_INTERFACES_FIELD, INSTANCE_ID_FIELD, IMAGE_ID_FIELD,
            STATE_FIELD, PRIVATE_DNS_NAME_FIELD, PUBLIC_DNS_NAME_FIELD, STATE_TRANSITION_REASON_FIELD, KEY_NAME_FIELD,
            AMI_LAUNCH_INDEX_FIELD, PRODUCT_CODES_FIELD, INSTANCE_TYPE_FIELD, LAUNCH_TIME_FIELD, PLACEMENT_FIELD,
            KERNEL_ID_FIELD, RAMDISK_ID_FIELD, PLATFORM_FIELD, MONITORING_FIELD, SUBNET_ID_FIELD, VPC_ID_FIELD,
            PRIVATE_IP_ADDRESS_FIELD, PUBLIC_IP_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String architecture;

    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;

    private final String clientToken;

    private final Boolean ebsOptimized;

    private final Boolean enaSupport;

    private final String hypervisor;

    private final IamInstanceProfile iamInstanceProfile;

    private final String instanceLifecycle;

    private final List<ElasticGpuAssociation> elasticGpuAssociations;

    private final List<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations;

    private final List<InstanceNetworkInterface> networkInterfaces;

    private final String outpostArn;

    private final String rootDeviceName;

    private final String rootDeviceType;

    private final List<GroupIdentifier> securityGroups;

    private final Boolean sourceDestCheck;

    private final String spotInstanceRequestId;

    private final String sriovNetSupport;

    private final StateReason stateReason;

    private final List<Tag> tags;

    private final String virtualizationType;

    private final CpuOptions cpuOptions;

    private final String capacityBlockId;

    private final String capacityReservationId;

    private final CapacityReservationSpecificationResponse capacityReservationSpecification;

    private final HibernationOptions hibernationOptions;

    private final List<LicenseConfiguration> licenses;

    private final InstanceMetadataOptionsResponse metadataOptions;

    private final EnclaveOptions enclaveOptions;

    private final String bootMode;

    private final String platformDetails;

    private final String usageOperation;

    private final Instant usageOperationUpdateTime;

    private final PrivateDnsNameOptionsResponse privateDnsNameOptions;

    private final String ipv6Address;

    private final String tpmSupport;

    private final InstanceMaintenanceOptions maintenanceOptions;

    private final String currentInstanceBootMode;

    private final InstanceNetworkPerformanceOptions networkPerformanceOptions;

    private final OperatorResponse operator;

    private final List<InstanceSecondaryInterface> secondaryInterfaces;

    private final String instanceId;

    private final String imageId;

    private final InstanceState state;

    private final String privateDnsName;

    private final String publicDnsName;

    private final String stateTransitionReason;

    private final String keyName;

    private final Integer amiLaunchIndex;

    private final List<ProductCode> productCodes;

    private final String instanceType;

    private final Instant launchTime;

    private final Placement placement;

    private final String kernelId;

    private final String ramdiskId;

    private final String platform;

    private final Monitoring monitoring;

    private final String subnetId;

    private final String vpcId;

    private final String privateIpAddress;

    private final String publicIpAddress;

    private Instance(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.clientToken = builder.clientToken;
        this.ebsOptimized = builder.ebsOptimized;
        this.enaSupport = builder.enaSupport;
        this.hypervisor = builder.hypervisor;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.instanceLifecycle = builder.instanceLifecycle;
        this.elasticGpuAssociations = builder.elasticGpuAssociations;
        this.elasticInferenceAcceleratorAssociations = builder.elasticInferenceAcceleratorAssociations;
        this.networkInterfaces = builder.networkInterfaces;
        this.outpostArn = builder.outpostArn;
        this.rootDeviceName = builder.rootDeviceName;
        this.rootDeviceType = builder.rootDeviceType;
        this.securityGroups = builder.securityGroups;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
        this.virtualizationType = builder.virtualizationType;
        this.cpuOptions = builder.cpuOptions;
        this.capacityBlockId = builder.capacityBlockId;
        this.capacityReservationId = builder.capacityReservationId;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.hibernationOptions = builder.hibernationOptions;
        this.licenses = builder.licenses;
        this.metadataOptions = builder.metadataOptions;
        this.enclaveOptions = builder.enclaveOptions;
        this.bootMode = builder.bootMode;
        this.platformDetails = builder.platformDetails;
        this.usageOperation = builder.usageOperation;
        this.usageOperationUpdateTime = builder.usageOperationUpdateTime;
        this.privateDnsNameOptions = builder.privateDnsNameOptions;
        this.ipv6Address = builder.ipv6Address;
        this.tpmSupport = builder.tpmSupport;
        this.maintenanceOptions = builder.maintenanceOptions;
        this.currentInstanceBootMode = builder.currentInstanceBootMode;
        this.networkPerformanceOptions = builder.networkPerformanceOptions;
        this.operator = builder.operator;
        this.secondaryInterfaces = builder.secondaryInterfaces;
        this.instanceId = builder.instanceId;
        this.imageId = builder.imageId;
        this.state = builder.state;
        this.privateDnsName = builder.privateDnsName;
        this.publicDnsName = builder.publicDnsName;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.keyName = builder.keyName;
        this.amiLaunchIndex = builder.amiLaunchIndex;
        this.productCodes = builder.productCodes;
        this.instanceType = builder.instanceType;
        this.launchTime = builder.launchTime;
        this.placement = builder.placement;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.platform = builder.platform;
        this.monitoring = builder.monitoring;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.privateIpAddress = builder.privateIpAddress;
        this.publicIpAddress = builder.publicIpAddress;
    }

    /**
     * <p>
     * The architecture of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The architecture of the image.
     * @see ArchitectureValues
     */
    public final ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(architecture);
    }

    /**
     * <p>
     * The architecture of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The architecture of the image.
     * @see ArchitectureValues
     */
    public final String architectureAsString() {
        return architecture;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any block device mapping entries for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return Any block device mapping entries for the instance.
     */
    public final List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The idempotency token you provided when you launched the instance, if applicable.
     * </p>
     * 
     * @return The idempotency token you provided when you launched the instance, if applicable.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput
     * to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't
     * available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     * </p>
     * 
     * @return Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
     *         throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This
     *         optimization isn't available with all instance types. Additional usage charges apply when using an EBS
     *         Optimized instance.
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with ENA is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with ENA is enabled.
     */
    public final Boolean enaSupport() {
        return enaSupport;
    }

    /**
     * <p>
     * The hypervisor type of the instance. The value <code>xen</code> is used for both Xen and Nitro hypervisors.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hypervisor} will
     * return {@link HypervisorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hypervisorAsString}.
     * </p>
     * 
     * @return The hypervisor type of the instance. The value <code>xen</code> is used for both Xen and Nitro
     *         hypervisors.
     * @see HypervisorType
     */
    public final HypervisorType hypervisor() {
        return HypervisorType.fromValue(hypervisor);
    }

    /**
     * <p>
     * The hypervisor type of the instance. The value <code>xen</code> is used for both Xen and Nitro hypervisors.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hypervisor} will
     * return {@link HypervisorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hypervisorAsString}.
     * </p>
     * 
     * @return The hypervisor type of the instance. The value <code>xen</code> is used for both Xen and Nitro
     *         hypervisors.
     * @see HypervisorType
     */
    public final String hypervisorAsString() {
        return hypervisor;
    }

    /**
     * <p>
     * The IAM instance profile associated with the instance, if applicable.
     * </p>
     * 
     * @return The IAM instance profile associated with the instance, if applicable.
     */
    public final IamInstanceProfile iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * Indicates whether this is a Spot Instance or a Scheduled Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceLifecycle}
     * will return {@link InstanceLifecycleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceLifecycleAsString}.
     * </p>
     * 
     * @return Indicates whether this is a Spot Instance or a Scheduled Instance.
     * @see InstanceLifecycleType
     */
    public final InstanceLifecycleType instanceLifecycle() {
        return InstanceLifecycleType.fromValue(instanceLifecycle);
    }

    /**
     * <p>
     * Indicates whether this is a Spot Instance or a Scheduled Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceLifecycle}
     * will return {@link InstanceLifecycleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceLifecycleAsString}.
     * </p>
     * 
     * @return Indicates whether this is a Spot Instance or a Scheduled Instance.
     * @see InstanceLifecycleType
     */
    public final String instanceLifecycleAsString() {
        return instanceLifecycle;
    }

    /**
     * For responses, this returns true if the service returned a value for the ElasticGpuAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasElasticGpuAssociations() {
        return elasticGpuAssociations != null && !(elasticGpuAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Deprecated.
     * </p>
     * <note>
     * <p>
     * Amazon Elastic Graphics reached end of life on January 8, 2024.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElasticGpuAssociations} method.
     * </p>
     * 
     * @return Deprecated.</p> <note>
     *         <p>
     *         Amazon Elastic Graphics reached end of life on January 8, 2024.
     *         </p>
     */
    public final List<ElasticGpuAssociation> elasticGpuAssociations() {
        return elasticGpuAssociations;
    }

    /**
     * For responses, this returns true if the service returned a value for the ElasticInferenceAcceleratorAssociations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasElasticInferenceAcceleratorAssociations() {
        return elasticInferenceAcceleratorAssociations != null
                && !(elasticInferenceAcceleratorAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Deprecated
     * </p>
     * <note>
     * <p>
     * Amazon Elastic Inference is no longer available.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasElasticInferenceAcceleratorAssociations} method.
     * </p>
     * 
     * @return Deprecated</p> <note>
     *         <p>
     *         Amazon Elastic Inference is no longer available.
     *         </p>
     */
    public final List<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations() {
        return elasticInferenceAcceleratorAssociations;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfaces property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network interfaces for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaces} method.
     * </p>
     * 
     * @return The network interfaces for the instance.
     */
    public final List<InstanceNetworkInterface> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The device name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * 
     * @return The device name of the root device volume (for example, <code>/dev/sda1</code>).
     */
    public final String rootDeviceName() {
        return rootDeviceName;
    }

    /**
     * <p>
     * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootDeviceTypeAsString}.
     * </p>
     * 
     * @return The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * @see DeviceType
     */
    public final DeviceType rootDeviceType() {
        return DeviceType.fromValue(rootDeviceType);
    }

    /**
     * <p>
     * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootDeviceTypeAsString}.
     * </p>
     * 
     * @return The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * @see DeviceType
     */
    public final String rootDeviceTypeAsString() {
        return rootDeviceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The security groups for the instance.
     */
    public final List<GroupIdentifier> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Indicates whether source/destination checking is enabled.
     * </p>
     * 
     * @return Indicates whether source/destination checking is enabled.
     */
    public final Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * If the request is a Spot Instance request, the ID of the request.
     * </p>
     * 
     * @return If the request is a Spot Instance request, the ID of the request.
     */
    public final String spotInstanceRequestId() {
        return spotInstanceRequestId;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public final String sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * The reason for the most recent state transition.
     * </p>
     * 
     * @return The reason for the most recent state transition.
     */
    public final StateReason stateReason() {
        return stateReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the instance.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The virtualization type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualizationType} will return {@link VirtualizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #virtualizationTypeAsString}.
     * </p>
     * 
     * @return The virtualization type of the instance.
     * @see VirtualizationType
     */
    public final VirtualizationType virtualizationType() {
        return VirtualizationType.fromValue(virtualizationType);
    }

    /**
     * <p>
     * The virtualization type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualizationType} will return {@link VirtualizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #virtualizationTypeAsString}.
     * </p>
     * 
     * @return The virtualization type of the instance.
     * @see VirtualizationType
     */
    public final String virtualizationTypeAsString() {
        return virtualizationType;
    }

    /**
     * <p>
     * The CPU options for the instance.
     * </p>
     * 
     * @return The CPU options for the instance.
     */
    public final CpuOptions cpuOptions() {
        return cpuOptions;
    }

    /**
     * <p>
     * The ID of the Capacity Block.
     * </p>
     * <note>
     * <p>
     * For P5 instances, a Capacity Block ID refers to a group of instances. For Trn2u instances, a capacity block ID
     * refers to an EC2 UltraServer.
     * </p>
     * </note>
     * 
     * @return The ID of the Capacity Block.</p> <note>
     *         <p>
     *         For P5 instances, a Capacity Block ID refers to a group of instances. For Trn2u instances, a capacity
     *         block ID refers to an EC2 UltraServer.
     *         </p>
     */
    public final String capacityBlockId() {
        return capacityBlockId;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the Capacity Reservation.
     */
    public final String capacityReservationId() {
        return capacityReservationId;
    }

    /**
     * <p>
     * Information about the Capacity Reservation targeting option.
     * </p>
     * 
     * @return Information about the Capacity Reservation targeting option.
     */
    public final CapacityReservationSpecificationResponse capacityReservationSpecification() {
        return capacityReservationSpecification;
    }

    /**
     * <p>
     * Indicates whether the instance is enabled for hibernation.
     * </p>
     * 
     * @return Indicates whether the instance is enabled for hibernation.
     */
    public final HibernationOptions hibernationOptions() {
        return hibernationOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Licenses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLicenses() {
        return licenses != null && !(licenses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The license configurations for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenses} method.
     * </p>
     * 
     * @return The license configurations for the instance.
     */
    public final List<LicenseConfiguration> licenses() {
        return licenses;
    }

    /**
     * <p>
     * The metadata options for the instance.
     * </p>
     * 
     * @return The metadata options for the instance.
     */
    public final InstanceMetadataOptionsResponse metadataOptions() {
        return metadataOptions;
    }

    /**
     * <p>
     * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
     * </p>
     * 
     * @return Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
     */
    public final EnclaveOptions enclaveOptions() {
        return enclaveOptions;
    }

    /**
     * <p>
     * The boot mode that was specified by the AMI. If the value is <code>uefi-preferred</code>, the AMI supports both
     * UEFI and Legacy BIOS. The <code>currentInstanceBootMode</code> parameter is the boot mode that is used to boot
     * the instance at launch or start.
     * </p>
     * <note>
     * <p>
     * The operating system contained in the AMI must be configured to support the specified boot mode.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot
     * modes</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootModeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return The boot mode that was specified by the AMI. If the value is <code>uefi-preferred</code>, the AMI
     *         supports both UEFI and Legacy BIOS. The <code>currentInstanceBootMode</code> parameter is the boot mode
     *         that is used to boot the instance at launch or start.</p> <note>
     *         <p>
     *         The operating system contained in the AMI must be configured to support the specified boot mode.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon
     *         EC2 User Guide</i>.
     * @see BootModeValues
     */
    public final BootModeValues bootMode() {
        return BootModeValues.fromValue(bootMode);
    }

    /**
     * <p>
     * The boot mode that was specified by the AMI. If the value is <code>uefi-preferred</code>, the AMI supports both
     * UEFI and Legacy BIOS. The <code>currentInstanceBootMode</code> parameter is the boot mode that is used to boot
     * the instance at launch or start.
     * </p>
     * <note>
     * <p>
     * The operating system contained in the AMI must be configured to support the specified boot mode.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot
     * modes</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootModeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return The boot mode that was specified by the AMI. If the value is <code>uefi-preferred</code>, the AMI
     *         supports both UEFI and Legacy BIOS. The <code>currentInstanceBootMode</code> parameter is the boot mode
     *         that is used to boot the instance at launch or start.</p> <note>
     *         <p>
     *         The operating system contained in the AMI must be configured to support the specified boot mode.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon
     *         EC2 User Guide</i>.
     * @see BootModeValues
     */
    public final String bootModeAsString() {
        return bootMode;
    }

    /**
     * <p>
     * The platform details value for the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information
     * fields</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The platform details value for the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing
     *         information fields</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final String platformDetails() {
        return platformDetails;
    }

    /**
     * <p>
     * The usage operation value for the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information
     * fields</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The usage operation value for the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing
     *         information fields</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final String usageOperation() {
        return usageOperation;
    }

    /**
     * <p>
     * The time that the usage operation was last updated.
     * </p>
     * 
     * @return The time that the usage operation was last updated.
     */
    public final Instant usageOperationUpdateTime() {
        return usageOperationUpdateTime;
    }

    /**
     * <p>
     * The options for the instance hostname.
     * </p>
     * 
     * @return The options for the instance hostname.
     */
    public final PrivateDnsNameOptionsResponse privateDnsNameOptions() {
        return privateDnsNameOptions;
    }

    /**
     * <p>
     * The IPv6 address assigned to the instance.
     * </p>
     * 
     * @return The IPv6 address assigned to the instance.
     */
    public final String ipv6Address() {
        return ipv6Address;
    }

    /**
     * <p>
     * If the instance is configured for NitroTPM support, the value is <code>v2.0</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon EC2 User
     * Guide</i>.
     * </p>
     * 
     * @return If the instance is configured for NitroTPM support, the value is <code>v2.0</code>. For more information,
     *         see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the
     *         <i>Amazon EC2 User Guide</i>.
     */
    public final String tpmSupport() {
        return tpmSupport;
    }

    /**
     * <p>
     * Provides information on the recovery and maintenance options of your instance.
     * </p>
     * 
     * @return Provides information on the recovery and maintenance options of your instance.
     */
    public final InstanceMaintenanceOptions maintenanceOptions() {
        return maintenanceOptions;
    }

    /**
     * <p>
     * The boot mode that is used to boot the instance at launch or start. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon EC2 User
     * Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #currentInstanceBootMode} will return {@link InstanceBootModeValues#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #currentInstanceBootModeAsString}.
     * </p>
     * 
     * @return The boot mode that is used to boot the instance at launch or start. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon
     *         EC2 User Guide</i>.
     * @see InstanceBootModeValues
     */
    public final InstanceBootModeValues currentInstanceBootMode() {
        return InstanceBootModeValues.fromValue(currentInstanceBootMode);
    }

    /**
     * <p>
     * The boot mode that is used to boot the instance at launch or start. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon EC2 User
     * Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #currentInstanceBootMode} will return {@link InstanceBootModeValues#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #currentInstanceBootModeAsString}.
     * </p>
     * 
     * @return The boot mode that is used to boot the instance at launch or start. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon
     *         EC2 User Guide</i>.
     * @see InstanceBootModeValues
     */
    public final String currentInstanceBootModeAsString() {
        return currentInstanceBootMode;
    }

    /**
     * <p>
     * Contains settings for the network performance options for your instance.
     * </p>
     * 
     * @return Contains settings for the network performance options for your instance.
     */
    public final InstanceNetworkPerformanceOptions networkPerformanceOptions() {
        return networkPerformanceOptions;
    }

    /**
     * <p>
     * The service provider that manages the instance.
     * </p>
     * 
     * @return The service provider that manages the instance.
     */
    public final OperatorResponse operator() {
        return operator;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondaryInterfaces property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecondaryInterfaces() {
        return secondaryInterfaces != null && !(secondaryInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The secondary interfaces for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondaryInterfaces} method.
     * </p>
     * 
     * @return The secondary interfaces for the instance.
     */
    public final List<InstanceSecondaryInterface> secondaryInterfaces() {
        return secondaryInterfaces;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ID of the AMI used to launch the instance.
     * </p>
     * 
     * @return The ID of the AMI used to launch the instance.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * 
     * @return The current state of the instance.
     */
    public final InstanceState state() {
        return state;
    }

    /**
     * <p>
     * [IPv4 only] The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside the
     * Amazon EC2 network. This name is not available until the instance enters the <code>running</code> state.
     * </p>
     * <p>
     * The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS resolution
     * and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your VPC, your custom
     * domain name servers must resolve the hostname as appropriate.
     * </p>
     * 
     * @return [IPv4 only] The private DNS hostname name assigned to the instance. This DNS hostname can only be used
     *         inside the Amazon EC2 network. This name is not available until the instance enters the
     *         <code>running</code> state. </p>
     *         <p>
     *         The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS
     *         resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your
     *         VPC, your custom domain name servers must resolve the hostname as appropriate.
     */
    public final String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The public DNS name assigned to the instance. This name is not available until the instance enters the
     * <code>running</code> state. This name is only available if you've enabled DNS hostnames for your VPC. The format
     * of this name depends on the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hostname-types.html#public-hostnames">public hostname
     * type</a>.
     * </p>
     * 
     * @return The public DNS name assigned to the instance. This name is not available until the instance enters the
     *         <code>running</code> state. This name is only available if you've enabled DNS hostnames for your VPC. The
     *         format of this name depends on the <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hostname-types.html#public-hostnames">public
     *         hostname type</a>.
     */
    public final String publicDnsName() {
        return publicDnsName;
    }

    /**
     * <p>
     * The reason for the most recent state transition. This might be an empty string.
     * </p>
     * 
     * @return The reason for the most recent state transition. This might be an empty string.
     */
    public final String stateTransitionReason() {
        return stateTransitionReason;
    }

    /**
     * <p>
     * The name of the key pair, if this instance was launched with an associated key pair.
     * </p>
     * 
     * @return The name of the key pair, if this instance was launched with an associated key pair.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The AMI launch index, which can be used to find this instance in the launch group.
     * </p>
     * 
     * @return The AMI launch index, which can be used to find this instance in the launch group.
     */
    public final Integer amiLaunchIndex() {
        return amiLaunchIndex;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductCodes() {
        return productCodes != null && !(productCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product codes attached to this instance, if applicable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductCodes} method.
     * </p>
     * 
     * @return The product codes attached to this instance, if applicable.
     */
    public final List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The time that the instance was last launched. To determine the time that instance was first launched, see the
     * attachment time for the primary network interface.
     * </p>
     * 
     * @return The time that the instance was last launched. To determine the time that instance was first launched, see
     *         the attachment time for the primary network interface.
     */
    public final Instant launchTime() {
        return launchTime;
    }

    /**
     * <p>
     * The location where the instance launched, if applicable.
     * </p>
     * 
     * @return The location where the instance launched, if applicable.
     */
    public final Placement placement() {
        return placement;
    }

    /**
     * <p>
     * The kernel associated with this instance, if applicable.
     * </p>
     * 
     * @return The kernel associated with this instance, if applicable.
     */
    public final String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The RAM disk associated with this instance, if applicable.
     * </p>
     * 
     * @return The RAM disk associated with this instance, if applicable.
     */
    public final String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The platform. This value is <code>windows</code> for Windows instances; otherwise, it is empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform. This value is <code>windows</code> for Windows instances; otherwise, it is empty.
     * @see PlatformValues
     */
    public final PlatformValues platform() {
        return PlatformValues.fromValue(platform);
    }

    /**
     * <p>
     * The platform. This value is <code>windows</code> for Windows instances; otherwise, it is empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform. This value is <code>windows</code> for Windows instances; otherwise, it is empty.
     * @see PlatformValues
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The monitoring for the instance.
     * </p>
     * 
     * @return The monitoring for the instance.
     */
    public final Monitoring monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * The ID of the subnet in which the instance is running.
     * </p>
     * 
     * @return The ID of the subnet in which the instance is running.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ID of the VPC in which the instance is running.
     * </p>
     * 
     * @return The ID of the VPC in which the instance is running.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The private IPv4 address assigned to the instance.
     * </p>
     * 
     * @return The private IPv4 address assigned to the instance.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * The public IPv4 address, or the Carrier IP address assigned to the instance, if applicable.
     * </p>
     * <p>
     * A Carrier IP address only applies to an instance launched in a subnet associated with a Wavelength Zone.
     * </p>
     * 
     * @return The public IPv4 address, or the Carrier IP address assigned to the instance, if applicable.</p>
     *         <p>
     *         A Carrier IP address only applies to an instance launched in a subnet associated with a Wavelength Zone.
     */
    public final String publicIpAddress() {
        return publicIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(instanceLifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasElasticGpuAssociations() ? elasticGpuAssociations() : null);
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasElasticInferenceAcceleratorAssociations() ? elasticInferenceAcceleratorAssociations()
                        : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaces() ? networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(spotInstanceRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(virtualizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockId());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hibernationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenses() ? licenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metadataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(enclaveOptions());
        hashCode = 31 * hashCode + Objects.hashCode(bootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformDetails());
        hashCode = 31 * hashCode + Objects.hashCode(usageOperation());
        hashCode = 31 * hashCode + Objects.hashCode(usageOperationUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsNameOptions());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Address());
        hashCode = 31 * hashCode + Objects.hashCode(tpmSupport());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(currentInstanceBootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(networkPerformanceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(operator());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondaryInterfaces() ? secondaryInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(amiLaunchIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductCodes() ? productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(architectureAsString(), other.architectureAsString())
                && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(enaSupport(), other.enaSupport())
                && Objects.equals(hypervisorAsString(), other.hypervisorAsString())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && Objects.equals(instanceLifecycleAsString(), other.instanceLifecycleAsString())
                && hasElasticGpuAssociations() == other.hasElasticGpuAssociations()
                && Objects.equals(elasticGpuAssociations(), other.elasticGpuAssociations())
                && hasElasticInferenceAcceleratorAssociations() == other.hasElasticInferenceAcceleratorAssociations()
                && Objects.equals(elasticInferenceAcceleratorAssociations(), other.elasticInferenceAcceleratorAssociations())
                && hasNetworkInterfaces() == other.hasNetworkInterfaces()
                && Objects.equals(networkInterfaces(), other.networkInterfaces())
                && Objects.equals(outpostArn(), other.outpostArn()) && Objects.equals(rootDeviceName(), other.rootDeviceName())
                && Objects.equals(rootDeviceTypeAsString(), other.rootDeviceTypeAsString())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck())
                && Objects.equals(spotInstanceRequestId(), other.spotInstanceRequestId())
                && Objects.equals(sriovNetSupport(), other.sriovNetSupport())
                && Objects.equals(stateReason(), other.stateReason()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(virtualizationTypeAsString(), other.virtualizationTypeAsString())
                && Objects.equals(cpuOptions(), other.cpuOptions()) && Objects.equals(capacityBlockId(), other.capacityBlockId())
                && Objects.equals(capacityReservationId(), other.capacityReservationId())
                && Objects.equals(capacityReservationSpecification(), other.capacityReservationSpecification())
                && Objects.equals(hibernationOptions(), other.hibernationOptions()) && hasLicenses() == other.hasLicenses()
                && Objects.equals(licenses(), other.licenses()) && Objects.equals(metadataOptions(), other.metadataOptions())
                && Objects.equals(enclaveOptions(), other.enclaveOptions())
                && Objects.equals(bootModeAsString(), other.bootModeAsString())
                && Objects.equals(platformDetails(), other.platformDetails())
                && Objects.equals(usageOperation(), other.usageOperation())
                && Objects.equals(usageOperationUpdateTime(), other.usageOperationUpdateTime())
                && Objects.equals(privateDnsNameOptions(), other.privateDnsNameOptions())
                && Objects.equals(ipv6Address(), other.ipv6Address()) && Objects.equals(tpmSupport(), other.tpmSupport())
                && Objects.equals(maintenanceOptions(), other.maintenanceOptions())
                && Objects.equals(currentInstanceBootModeAsString(), other.currentInstanceBootModeAsString())
                && Objects.equals(networkPerformanceOptions(), other.networkPerformanceOptions())
                && Objects.equals(operator(), other.operator()) && hasSecondaryInterfaces() == other.hasSecondaryInterfaces()
                && Objects.equals(secondaryInterfaces(), other.secondaryInterfaces())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(state(), other.state()) && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(publicDnsName(), other.publicDnsName())
                && Objects.equals(stateTransitionReason(), other.stateTransitionReason())
                && Objects.equals(keyName(), other.keyName()) && Objects.equals(amiLaunchIndex(), other.amiLaunchIndex())
                && hasProductCodes() == other.hasProductCodes() && Objects.equals(productCodes(), other.productCodes())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(launchTime(), other.launchTime()) && Objects.equals(placement(), other.placement())
                && Objects.equals(kernelId(), other.kernelId()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(monitoring(), other.monitoring()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(publicIpAddress(), other.publicIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("Instance")
                .add("Architecture", architectureAsString())
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("ClientToken", clientToken())
                .add("EbsOptimized", ebsOptimized())
                .add("EnaSupport", enaSupport())
                .add("Hypervisor", hypervisorAsString())
                .add("IamInstanceProfile", iamInstanceProfile())
                .add("InstanceLifecycle", instanceLifecycleAsString())
                .add("ElasticGpuAssociations", hasElasticGpuAssociations() ? elasticGpuAssociations() : null)
                .add("ElasticInferenceAcceleratorAssociations",
                        hasElasticInferenceAcceleratorAssociations() ? elasticInferenceAcceleratorAssociations() : null)
                .add("NetworkInterfaces", hasNetworkInterfaces() ? networkInterfaces() : null).add("OutpostArn", outpostArn())
                .add("RootDeviceName", rootDeviceName()).add("RootDeviceType", rootDeviceTypeAsString())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("SourceDestCheck", sourceDestCheck())
                .add("SpotInstanceRequestId", spotInstanceRequestId()).add("SriovNetSupport", sriovNetSupport())
                .add("StateReason", stateReason()).add("Tags", hasTags() ? tags() : null)
                .add("VirtualizationType", virtualizationTypeAsString()).add("CpuOptions", cpuOptions())
                .add("CapacityBlockId", capacityBlockId()).add("CapacityReservationId", capacityReservationId())
                .add("CapacityReservationSpecification", capacityReservationSpecification())
                .add("HibernationOptions", hibernationOptions()).add("Licenses", hasLicenses() ? licenses() : null)
                .add("MetadataOptions", metadataOptions()).add("EnclaveOptions", enclaveOptions())
                .add("BootMode", bootModeAsString()).add("PlatformDetails", platformDetails())
                .add("UsageOperation", usageOperation()).add("UsageOperationUpdateTime", usageOperationUpdateTime())
                .add("PrivateDnsNameOptions", privateDnsNameOptions()).add("Ipv6Address", ipv6Address())
                .add("TpmSupport", tpmSupport()).add("MaintenanceOptions", maintenanceOptions())
                .add("CurrentInstanceBootMode", currentInstanceBootModeAsString())
                .add("NetworkPerformanceOptions", networkPerformanceOptions()).add("Operator", operator())
                .add("SecondaryInterfaces", hasSecondaryInterfaces() ? secondaryInterfaces() : null)
                .add("InstanceId", instanceId()).add("ImageId", imageId()).add("State", state())
                .add("PrivateDnsName", privateDnsName()).add("PublicDnsName", publicDnsName())
                .add("StateTransitionReason", stateTransitionReason()).add("KeyName", keyName())
                .add("AmiLaunchIndex", amiLaunchIndex()).add("ProductCodes", hasProductCodes() ? productCodes() : null)
                .add("InstanceType", instanceTypeAsString()).add("LaunchTime", launchTime()).add("Placement", placement())
                .add("KernelId", kernelId()).add("RamdiskId", ramdiskId()).add("Platform", platformAsString())
                .add("Monitoring", monitoring()).add("SubnetId", subnetId()).add("VpcId", vpcId())
                .add("PrivateIpAddress", privateIpAddress()).add("PublicIpAddress", publicIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "EnaSupport":
            return Optional.ofNullable(clazz.cast(enaSupport()));
        case "Hypervisor":
            return Optional.ofNullable(clazz.cast(hypervisorAsString()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "InstanceLifecycle":
            return Optional.ofNullable(clazz.cast(instanceLifecycleAsString()));
        case "ElasticGpuAssociations":
            return Optional.ofNullable(clazz.cast(elasticGpuAssociations()));
        case "ElasticInferenceAcceleratorAssociations":
            return Optional.ofNullable(clazz.cast(elasticInferenceAcceleratorAssociations()));
        case "NetworkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "RootDeviceName":
            return Optional.ofNullable(clazz.cast(rootDeviceName()));
        case "RootDeviceType":
            return Optional.ofNullable(clazz.cast(rootDeviceTypeAsString()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SourceDestCheck":
            return Optional.ofNullable(clazz.cast(sourceDestCheck()));
        case "SpotInstanceRequestId":
            return Optional.ofNullable(clazz.cast(spotInstanceRequestId()));
        case "SriovNetSupport":
            return Optional.ofNullable(clazz.cast(sriovNetSupport()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VirtualizationType":
            return Optional.ofNullable(clazz.cast(virtualizationTypeAsString()));
        case "CpuOptions":
            return Optional.ofNullable(clazz.cast(cpuOptions()));
        case "CapacityBlockId":
            return Optional.ofNullable(clazz.cast(capacityBlockId()));
        case "CapacityReservationId":
            return Optional.ofNullable(clazz.cast(capacityReservationId()));
        case "CapacityReservationSpecification":
            return Optional.ofNullable(clazz.cast(capacityReservationSpecification()));
        case "HibernationOptions":
            return Optional.ofNullable(clazz.cast(hibernationOptions()));
        case "Licenses":
            return Optional.ofNullable(clazz.cast(licenses()));
        case "MetadataOptions":
            return Optional.ofNullable(clazz.cast(metadataOptions()));
        case "EnclaveOptions":
            return Optional.ofNullable(clazz.cast(enclaveOptions()));
        case "BootMode":
            return Optional.ofNullable(clazz.cast(bootModeAsString()));
        case "PlatformDetails":
            return Optional.ofNullable(clazz.cast(platformDetails()));
        case "UsageOperation":
            return Optional.ofNullable(clazz.cast(usageOperation()));
        case "UsageOperationUpdateTime":
            return Optional.ofNullable(clazz.cast(usageOperationUpdateTime()));
        case "PrivateDnsNameOptions":
            return Optional.ofNullable(clazz.cast(privateDnsNameOptions()));
        case "Ipv6Address":
            return Optional.ofNullable(clazz.cast(ipv6Address()));
        case "TpmSupport":
            return Optional.ofNullable(clazz.cast(tpmSupport()));
        case "MaintenanceOptions":
            return Optional.ofNullable(clazz.cast(maintenanceOptions()));
        case "CurrentInstanceBootMode":
            return Optional.ofNullable(clazz.cast(currentInstanceBootModeAsString()));
        case "NetworkPerformanceOptions":
            return Optional.ofNullable(clazz.cast(networkPerformanceOptions()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operator()));
        case "SecondaryInterfaces":
            return Optional.ofNullable(clazz.cast(secondaryInterfaces()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "PublicDnsName":
            return Optional.ofNullable(clazz.cast(publicDnsName()));
        case "StateTransitionReason":
            return Optional.ofNullable(clazz.cast(stateTransitionReason()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "AmiLaunchIndex":
            return Optional.ofNullable(clazz.cast(amiLaunchIndex()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "LaunchTime":
            return Optional.ofNullable(clazz.cast(launchTime()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placement()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "Monitoring":
            return Optional.ofNullable(clazz.cast(monitoring()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "PublicIpAddress":
            return Optional.ofNullable(clazz.cast(publicIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Architecture", ARCHITECTURE_FIELD);
        map.put("BlockDeviceMapping", BLOCK_DEVICE_MAPPINGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
        map.put("EnaSupport", ENA_SUPPORT_FIELD);
        map.put("Hypervisor", HYPERVISOR_FIELD);
        map.put("IamInstanceProfile", IAM_INSTANCE_PROFILE_FIELD);
        map.put("InstanceLifecycle", INSTANCE_LIFECYCLE_FIELD);
        map.put("ElasticGpuAssociationSet", ELASTIC_GPU_ASSOCIATIONS_FIELD);
        map.put("ElasticInferenceAcceleratorAssociationSet", ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATIONS_FIELD);
        map.put("NetworkInterfaceSet", NETWORK_INTERFACES_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("RootDeviceName", ROOT_DEVICE_NAME_FIELD);
        map.put("RootDeviceType", ROOT_DEVICE_TYPE_FIELD);
        map.put("GroupSet", SECURITY_GROUPS_FIELD);
        map.put("SourceDestCheck", SOURCE_DEST_CHECK_FIELD);
        map.put("SpotInstanceRequestId", SPOT_INSTANCE_REQUEST_ID_FIELD);
        map.put("SriovNetSupport", SRIOV_NET_SUPPORT_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("VirtualizationType", VIRTUALIZATION_TYPE_FIELD);
        map.put("CpuOptions", CPU_OPTIONS_FIELD);
        map.put("CapacityBlockId", CAPACITY_BLOCK_ID_FIELD);
        map.put("CapacityReservationId", CAPACITY_RESERVATION_ID_FIELD);
        map.put("CapacityReservationSpecification", CAPACITY_RESERVATION_SPECIFICATION_FIELD);
        map.put("HibernationOptions", HIBERNATION_OPTIONS_FIELD);
        map.put("LicenseSet", LICENSES_FIELD);
        map.put("MetadataOptions", METADATA_OPTIONS_FIELD);
        map.put("EnclaveOptions", ENCLAVE_OPTIONS_FIELD);
        map.put("BootMode", BOOT_MODE_FIELD);
        map.put("PlatformDetails", PLATFORM_DETAILS_FIELD);
        map.put("UsageOperation", USAGE_OPERATION_FIELD);
        map.put("UsageOperationUpdateTime", USAGE_OPERATION_UPDATE_TIME_FIELD);
        map.put("PrivateDnsNameOptions", PRIVATE_DNS_NAME_OPTIONS_FIELD);
        map.put("Ipv6Address", IPV6_ADDRESS_FIELD);
        map.put("TpmSupport", TPM_SUPPORT_FIELD);
        map.put("MaintenanceOptions", MAINTENANCE_OPTIONS_FIELD);
        map.put("CurrentInstanceBootMode", CURRENT_INSTANCE_BOOT_MODE_FIELD);
        map.put("NetworkPerformanceOptions", NETWORK_PERFORMANCE_OPTIONS_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        map.put("SecondaryInterfaceSet", SECONDARY_INTERFACES_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("InstanceState", STATE_FIELD);
        map.put("PrivateDnsName", PRIVATE_DNS_NAME_FIELD);
        map.put("DnsName", PUBLIC_DNS_NAME_FIELD);
        map.put("Reason", STATE_TRANSITION_REASON_FIELD);
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("AmiLaunchIndex", AMI_LAUNCH_INDEX_FIELD);
        map.put("ProductCodes", PRODUCT_CODES_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("LaunchTime", LAUNCH_TIME_FIELD);
        map.put("Placement", PLACEMENT_FIELD);
        map.put("KernelId", KERNEL_ID_FIELD);
        map.put("RamdiskId", RAMDISK_ID_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("Monitoring", MONITORING_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
        map.put("IpAddress", PUBLIC_IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(ArchitectureValues architecture);

        /**
         * <p>
         * Any block device mapping entries for the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * Any block device mapping entries for the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * Any block device mapping entries for the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #blockDeviceMappings(List<InstanceBlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(java.util.Collection<InstanceBlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * The idempotency token you provided when you launched the instance, if applicable.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token you provided when you launched the instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         * throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This
         * optimization isn't available with all instance types. Additional usage charges apply when using an EBS
         * Optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This
         *        optimization isn't available with all instance types. Additional usage charges apply when using an EBS
         *        Optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * Specifies whether enhanced networking with ENA is enabled.
         * </p>
         * 
         * @param enaSupport
         *        Specifies whether enhanced networking with ENA is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(Boolean enaSupport);

        /**
         * <p>
         * The hypervisor type of the instance. The value <code>xen</code> is used for both Xen and Nitro hypervisors.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the instance. The value <code>xen</code> is used for both Xen and Nitro
         *        hypervisors.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * The hypervisor type of the instance. The value <code>xen</code> is used for both Xen and Nitro hypervisors.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the instance. The value <code>xen</code> is used for both Xen and Nitro
         *        hypervisors.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(HypervisorType hypervisor);

        /**
         * <p>
         * The IAM instance profile associated with the instance, if applicable.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile associated with the instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile);

        /**
         * <p>
         * The IAM instance profile associated with the instance, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamInstanceProfile.Builder} avoiding the
         * need to create one manually via {@link IamInstanceProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamInstanceProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #iamInstanceProfile(IamInstanceProfile)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link IamInstanceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(IamInstanceProfile)
         */
        default Builder iamInstanceProfile(Consumer<IamInstanceProfile.Builder> iamInstanceProfile) {
            return iamInstanceProfile(IamInstanceProfile.builder().applyMutation(iamInstanceProfile).build());
        }

        /**
         * <p>
         * Indicates whether this is a Spot Instance or a Scheduled Instance.
         * </p>
         * 
         * @param instanceLifecycle
         *        Indicates whether this is a Spot Instance or a Scheduled Instance.
         * @see InstanceLifecycleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceLifecycleType
         */
        Builder instanceLifecycle(String instanceLifecycle);

        /**
         * <p>
         * Indicates whether this is a Spot Instance or a Scheduled Instance.
         * </p>
         * 
         * @param instanceLifecycle
         *        Indicates whether this is a Spot Instance or a Scheduled Instance.
         * @see InstanceLifecycleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceLifecycleType
         */
        Builder instanceLifecycle(InstanceLifecycleType instanceLifecycle);

        /**
         * <p>
         * Deprecated.
         * </p>
         * <note>
         * <p>
         * Amazon Elastic Graphics reached end of life on January 8, 2024.
         * </p>
         * </note>
         * 
         * @param elasticGpuAssociations
         *        Deprecated.</p> <note>
         *        <p>
         *        Amazon Elastic Graphics reached end of life on January 8, 2024.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuAssociations(Collection<ElasticGpuAssociation> elasticGpuAssociations);

        /**
         * <p>
         * Deprecated.
         * </p>
         * <note>
         * <p>
         * Amazon Elastic Graphics reached end of life on January 8, 2024.
         * </p>
         * </note>
         * 
         * @param elasticGpuAssociations
         *        Deprecated.</p> <note>
         *        <p>
         *        Amazon Elastic Graphics reached end of life on January 8, 2024.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuAssociations(ElasticGpuAssociation... elasticGpuAssociations);

        /**
         * <p>
         * Deprecated.
         * </p>
         * <note>
         * <p>
         * Amazon Elastic Graphics reached end of life on January 8, 2024.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation.Builder#build()} is called immediately
         * and its result is passed to {@link #elasticGpuAssociations(List<ElasticGpuAssociation>)}.
         * 
         * @param elasticGpuAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticGpuAssociations(java.util.Collection<ElasticGpuAssociation>)
         */
        Builder elasticGpuAssociations(Consumer<ElasticGpuAssociation.Builder>... elasticGpuAssociations);

        /**
         * <p>
         * Deprecated
         * </p>
         * <note>
         * <p>
         * Amazon Elastic Inference is no longer available.
         * </p>
         * </note>
         * 
         * @param elasticInferenceAcceleratorAssociations
         *        Deprecated</p> <note>
         *        <p>
         *        Amazon Elastic Inference is no longer available.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAcceleratorAssociations(
                Collection<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations);

        /**
         * <p>
         * Deprecated
         * </p>
         * <note>
         * <p>
         * Amazon Elastic Inference is no longer available.
         * </p>
         * </note>
         * 
         * @param elasticInferenceAcceleratorAssociations
         *        Deprecated</p> <note>
         *        <p>
         *        Amazon Elastic Inference is no longer available.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAcceleratorAssociations(
                ElasticInferenceAcceleratorAssociation... elasticInferenceAcceleratorAssociations);

        /**
         * <p>
         * Deprecated
         * </p>
         * <note>
         * <p>
         * Amazon Elastic Inference is no longer available.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #elasticInferenceAcceleratorAssociations(List<ElasticInferenceAcceleratorAssociation>)}.
         * 
         * @param elasticInferenceAcceleratorAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticInferenceAcceleratorAssociations(java.util.Collection<ElasticInferenceAcceleratorAssociation>)
         */
        Builder elasticInferenceAcceleratorAssociations(
                Consumer<ElasticInferenceAcceleratorAssociation.Builder>... elasticInferenceAcceleratorAssociations);

        /**
         * <p>
         * The network interfaces for the instance.
         * </p>
         * 
         * @param networkInterfaces
         *        The network interfaces for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<InstanceNetworkInterface> networkInterfaces);

        /**
         * <p>
         * The network interfaces for the instance.
         * </p>
         * 
         * @param networkInterfaces
         *        The network interfaces for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(InstanceNetworkInterface... networkInterfaces);

        /**
         * <p>
         * The network interfaces for the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface.Builder#build()} is called
         * immediately and its result is passed to {@link #networkInterfaces(List<InstanceNetworkInterface>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(java.util.Collection<InstanceNetworkInterface>)
         */
        Builder networkInterfaces(Consumer<InstanceNetworkInterface.Builder>... networkInterfaces);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * </p>
         * 
         * @param rootDeviceName
         *        The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceName(String rootDeviceName);

        /**
         * <p>
         * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(String rootDeviceType);

        /**
         * <p>
         * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(DeviceType rootDeviceType);

        /**
         * <p>
         * The security groups for the instance.
         * </p>
         * 
         * @param securityGroups
         *        The security groups for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<GroupIdentifier> securityGroups);

        /**
         * <p>
         * The security groups for the instance.
         * </p>
         * 
         * @param securityGroups
         *        The security groups for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(GroupIdentifier... securityGroups);

        /**
         * <p>
         * The security groups for the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.GroupIdentifier.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.GroupIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.GroupIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #securityGroups(List<GroupIdentifier>)}.
         * 
         * @param securityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.GroupIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroups(java.util.Collection<GroupIdentifier>)
         */
        Builder securityGroups(Consumer<GroupIdentifier.Builder>... securityGroups);

        /**
         * <p>
         * Indicates whether source/destination checking is enabled.
         * </p>
         * 
         * @param sourceDestCheck
         *        Indicates whether source/destination checking is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * If the request is a Spot Instance request, the ID of the request.
         * </p>
         * 
         * @param spotInstanceRequestId
         *        If the request is a Spot Instance request, the ID of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestId(String spotInstanceRequestId);

        /**
         * <p>
         * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * 
         * @param sriovNetSupport
         *        Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(String sriovNetSupport);

        /**
         * <p>
         * The reason for the most recent state transition.
         * </p>
         * 
         * @param stateReason
         *        The reason for the most recent state transition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(StateReason stateReason);

        /**
         * <p>
         * The reason for the most recent state transition.
         * </p>
         * This is a convenience method that creates an instance of the {@link StateReason.Builder} avoiding the need to
         * create one manually via {@link StateReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StateReason.Builder#build()} is called immediately and its result
         * is passed to {@link #stateReason(StateReason)}.
         * 
         * @param stateReason
         *        a consumer that will call methods on {@link StateReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateReason(StateReason)
         */
        default Builder stateReason(Consumer<StateReason.Builder> stateReason) {
            return stateReason(StateReason.builder().applyMutation(stateReason).build());
        }

        /**
         * <p>
         * Any tags assigned to the instance.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the instance.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The virtualization type of the instance.
         * </p>
         * 
         * @param virtualizationType
         *        The virtualization type of the instance.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(String virtualizationType);

        /**
         * <p>
         * The virtualization type of the instance.
         * </p>
         * 
         * @param virtualizationType
         *        The virtualization type of the instance.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(VirtualizationType virtualizationType);

        /**
         * <p>
         * The CPU options for the instance.
         * </p>
         * 
         * @param cpuOptions
         *        The CPU options for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuOptions(CpuOptions cpuOptions);

        /**
         * <p>
         * The CPU options for the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link CpuOptions.Builder} avoiding the need to
         * create one manually via {@link CpuOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CpuOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #cpuOptions(CpuOptions)}.
         * 
         * @param cpuOptions
         *        a consumer that will call methods on {@link CpuOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpuOptions(CpuOptions)
         */
        default Builder cpuOptions(Consumer<CpuOptions.Builder> cpuOptions) {
            return cpuOptions(CpuOptions.builder().applyMutation(cpuOptions).build());
        }

        /**
         * <p>
         * The ID of the Capacity Block.
         * </p>
         * <note>
         * <p>
         * For P5 instances, a Capacity Block ID refers to a group of instances. For Trn2u instances, a capacity block
         * ID refers to an EC2 UltraServer.
         * </p>
         * </note>
         * 
         * @param capacityBlockId
         *        The ID of the Capacity Block.</p> <note>
         *        <p>
         *        For P5 instances, a Capacity Block ID refers to a group of instances. For Trn2u instances, a capacity
         *        block ID refers to an EC2 UltraServer.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockId(String capacityBlockId);

        /**
         * <p>
         * The ID of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationId
         *        The ID of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationId(String capacityReservationId);

        /**
         * <p>
         * Information about the Capacity Reservation targeting option.
         * </p>
         * 
         * @param capacityReservationSpecification
         *        Information about the Capacity Reservation targeting option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationSpecification(CapacityReservationSpecificationResponse capacityReservationSpecification);

        /**
         * <p>
         * Information about the Capacity Reservation targeting option.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CapacityReservationSpecificationResponse.Builder} avoiding the need to create one manually via
         * {@link CapacityReservationSpecificationResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservationSpecificationResponse.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #capacityReservationSpecification(CapacityReservationSpecificationResponse)}.
         * 
         * @param capacityReservationSpecification
         *        a consumer that will call methods on {@link CapacityReservationSpecificationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationSpecification(CapacityReservationSpecificationResponse)
         */
        default Builder capacityReservationSpecification(
                Consumer<CapacityReservationSpecificationResponse.Builder> capacityReservationSpecification) {
            return capacityReservationSpecification(CapacityReservationSpecificationResponse.builder()
                    .applyMutation(capacityReservationSpecification).build());
        }

        /**
         * <p>
         * Indicates whether the instance is enabled for hibernation.
         * </p>
         * 
         * @param hibernationOptions
         *        Indicates whether the instance is enabled for hibernation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hibernationOptions(HibernationOptions hibernationOptions);

        /**
         * <p>
         * Indicates whether the instance is enabled for hibernation.
         * </p>
         * This is a convenience method that creates an instance of the {@link HibernationOptions.Builder} avoiding the
         * need to create one manually via {@link HibernationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HibernationOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #hibernationOptions(HibernationOptions)}.
         * 
         * @param hibernationOptions
         *        a consumer that will call methods on {@link HibernationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hibernationOptions(HibernationOptions)
         */
        default Builder hibernationOptions(Consumer<HibernationOptions.Builder> hibernationOptions) {
            return hibernationOptions(HibernationOptions.builder().applyMutation(hibernationOptions).build());
        }

        /**
         * <p>
         * The license configurations for the instance.
         * </p>
         * 
         * @param licenses
         *        The license configurations for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenses(Collection<LicenseConfiguration> licenses);

        /**
         * <p>
         * The license configurations for the instance.
         * </p>
         * 
         * @param licenses
         *        The license configurations for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenses(LicenseConfiguration... licenses);

        /**
         * <p>
         * The license configurations for the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.LicenseConfiguration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.LicenseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.LicenseConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #licenses(List<LicenseConfiguration>)}.
         * 
         * @param licenses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.LicenseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenses(java.util.Collection<LicenseConfiguration>)
         */
        Builder licenses(Consumer<LicenseConfiguration.Builder>... licenses);

        /**
         * <p>
         * The metadata options for the instance.
         * </p>
         * 
         * @param metadataOptions
         *        The metadata options for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOptions(InstanceMetadataOptionsResponse metadataOptions);

        /**
         * <p>
         * The metadata options for the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceMetadataOptionsResponse.Builder}
         * avoiding the need to create one manually via {@link InstanceMetadataOptionsResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMetadataOptionsResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #metadataOptions(InstanceMetadataOptionsResponse)}.
         * 
         * @param metadataOptions
         *        a consumer that will call methods on {@link InstanceMetadataOptionsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataOptions(InstanceMetadataOptionsResponse)
         */
        default Builder metadataOptions(Consumer<InstanceMetadataOptionsResponse.Builder> metadataOptions) {
            return metadataOptions(InstanceMetadataOptionsResponse.builder().applyMutation(metadataOptions).build());
        }

        /**
         * <p>
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
         * </p>
         * 
         * @param enclaveOptions
         *        Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enclaveOptions(EnclaveOptions enclaveOptions);

        /**
         * <p>
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnclaveOptions.Builder} avoiding the need
         * to create one manually via {@link EnclaveOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnclaveOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #enclaveOptions(EnclaveOptions)}.
         * 
         * @param enclaveOptions
         *        a consumer that will call methods on {@link EnclaveOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enclaveOptions(EnclaveOptions)
         */
        default Builder enclaveOptions(Consumer<EnclaveOptions.Builder> enclaveOptions) {
            return enclaveOptions(EnclaveOptions.builder().applyMutation(enclaveOptions).build());
        }

        /**
         * <p>
         * The boot mode that was specified by the AMI. If the value is <code>uefi-preferred</code>, the AMI supports
         * both UEFI and Legacy BIOS. The <code>currentInstanceBootMode</code> parameter is the boot mode that is used
         * to boot the instance at launch or start.
         * </p>
         * <note>
         * <p>
         * The operating system contained in the AMI must be configured to support the specified boot mode.
         * </p>
         * </note>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot
         * modes</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param bootMode
         *        The boot mode that was specified by the AMI. If the value is <code>uefi-preferred</code>, the AMI
         *        supports both UEFI and Legacy BIOS. The <code>currentInstanceBootMode</code> parameter is the boot
         *        mode that is used to boot the instance at launch or start.</p> <note>
         *        <p>
         *        The operating system contained in the AMI must be configured to support the specified boot mode.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the
         *        <i>Amazon EC2 User Guide</i>.
         * @see BootModeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootModeValues
         */
        Builder bootMode(String bootMode);

        /**
         * <p>
         * The boot mode that was specified by the AMI. If the value is <code>uefi-preferred</code>, the AMI supports
         * both UEFI and Legacy BIOS. The <code>currentInstanceBootMode</code> parameter is the boot mode that is used
         * to boot the instance at launch or start.
         * </p>
         * <note>
         * <p>
         * The operating system contained in the AMI must be configured to support the specified boot mode.
         * </p>
         * </note>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot
         * modes</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param bootMode
         *        The boot mode that was specified by the AMI. If the value is <code>uefi-preferred</code>, the AMI
         *        supports both UEFI and Legacy BIOS. The <code>currentInstanceBootMode</code> parameter is the boot
         *        mode that is used to boot the instance at launch or start.</p> <note>
         *        <p>
         *        The operating system contained in the AMI must be configured to support the specified boot mode.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the
         *        <i>Amazon EC2 User Guide</i>.
         * @see BootModeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootModeValues
         */
        Builder bootMode(BootModeValues bootMode);

        /**
         * <p>
         * The platform details value for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information
         * fields</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param platformDetails
         *        The platform details value for the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing
         *        information fields</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformDetails(String platformDetails);

        /**
         * <p>
         * The usage operation value for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information
         * fields</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param usageOperation
         *        The usage operation value for the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing
         *        information fields</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageOperation(String usageOperation);

        /**
         * <p>
         * The time that the usage operation was last updated.
         * </p>
         * 
         * @param usageOperationUpdateTime
         *        The time that the usage operation was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageOperationUpdateTime(Instant usageOperationUpdateTime);

        /**
         * <p>
         * The options for the instance hostname.
         * </p>
         * 
         * @param privateDnsNameOptions
         *        The options for the instance hostname.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsNameOptions(PrivateDnsNameOptionsResponse privateDnsNameOptions);

        /**
         * <p>
         * The options for the instance hostname.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivateDnsNameOptionsResponse.Builder}
         * avoiding the need to create one manually via {@link PrivateDnsNameOptionsResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivateDnsNameOptionsResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #privateDnsNameOptions(PrivateDnsNameOptionsResponse)}.
         * 
         * @param privateDnsNameOptions
         *        a consumer that will call methods on {@link PrivateDnsNameOptionsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateDnsNameOptions(PrivateDnsNameOptionsResponse)
         */
        default Builder privateDnsNameOptions(Consumer<PrivateDnsNameOptionsResponse.Builder> privateDnsNameOptions) {
            return privateDnsNameOptions(PrivateDnsNameOptionsResponse.builder().applyMutation(privateDnsNameOptions).build());
        }

        /**
         * <p>
         * The IPv6 address assigned to the instance.
         * </p>
         * 
         * @param ipv6Address
         *        The IPv6 address assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Address(String ipv6Address);

        /**
         * <p>
         * If the instance is configured for NitroTPM support, the value is <code>v2.0</code>. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon EC2
         * User Guide</i>.
         * </p>
         * 
         * @param tpmSupport
         *        If the instance is configured for NitroTPM support, the value is <code>v2.0</code>. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon
         *        EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tpmSupport(String tpmSupport);

        /**
         * <p>
         * Provides information on the recovery and maintenance options of your instance.
         * </p>
         * 
         * @param maintenanceOptions
         *        Provides information on the recovery and maintenance options of your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceOptions(InstanceMaintenanceOptions maintenanceOptions);

        /**
         * <p>
         * Provides information on the recovery and maintenance options of your instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceMaintenanceOptions.Builder}
         * avoiding the need to create one manually via {@link InstanceMaintenanceOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMaintenanceOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #maintenanceOptions(InstanceMaintenanceOptions)}.
         * 
         * @param maintenanceOptions
         *        a consumer that will call methods on {@link InstanceMaintenanceOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceOptions(InstanceMaintenanceOptions)
         */
        default Builder maintenanceOptions(Consumer<InstanceMaintenanceOptions.Builder> maintenanceOptions) {
            return maintenanceOptions(InstanceMaintenanceOptions.builder().applyMutation(maintenanceOptions).build());
        }

        /**
         * <p>
         * The boot mode that is used to boot the instance at launch or start. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon EC2
         * User Guide</i>.
         * </p>
         * 
         * @param currentInstanceBootMode
         *        The boot mode that is used to boot the instance at launch or start. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the
         *        <i>Amazon EC2 User Guide</i>.
         * @see InstanceBootModeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceBootModeValues
         */
        Builder currentInstanceBootMode(String currentInstanceBootMode);

        /**
         * <p>
         * The boot mode that is used to boot the instance at launch or start. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon EC2
         * User Guide</i>.
         * </p>
         * 
         * @param currentInstanceBootMode
         *        The boot mode that is used to boot the instance at launch or start. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the
         *        <i>Amazon EC2 User Guide</i>.
         * @see InstanceBootModeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceBootModeValues
         */
        Builder currentInstanceBootMode(InstanceBootModeValues currentInstanceBootMode);

        /**
         * <p>
         * Contains settings for the network performance options for your instance.
         * </p>
         * 
         * @param networkPerformanceOptions
         *        Contains settings for the network performance options for your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPerformanceOptions(InstanceNetworkPerformanceOptions networkPerformanceOptions);

        /**
         * <p>
         * Contains settings for the network performance options for your instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InstanceNetworkPerformanceOptions.Builder} avoiding the need to create one manually via
         * {@link InstanceNetworkPerformanceOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceNetworkPerformanceOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #networkPerformanceOptions(InstanceNetworkPerformanceOptions)}.
         * 
         * @param networkPerformanceOptions
         *        a consumer that will call methods on {@link InstanceNetworkPerformanceOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkPerformanceOptions(InstanceNetworkPerformanceOptions)
         */
        default Builder networkPerformanceOptions(Consumer<InstanceNetworkPerformanceOptions.Builder> networkPerformanceOptions) {
            return networkPerformanceOptions(InstanceNetworkPerformanceOptions.builder().applyMutation(networkPerformanceOptions)
                    .build());
        }

        /**
         * <p>
         * The service provider that manages the instance.
         * </p>
         * 
         * @param operator
         *        The service provider that manages the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operator(OperatorResponse operator);

        /**
         * <p>
         * The service provider that manages the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link OperatorResponse.Builder} avoiding the
         * need to create one manually via {@link OperatorResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OperatorResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #operator(OperatorResponse)}.
         * 
         * @param operator
         *        a consumer that will call methods on {@link OperatorResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operator(OperatorResponse)
         */
        default Builder operator(Consumer<OperatorResponse.Builder> operator) {
            return operator(OperatorResponse.builder().applyMutation(operator).build());
        }

        /**
         * <p>
         * The secondary interfaces for the instance.
         * </p>
         * 
         * @param secondaryInterfaces
         *        The secondary interfaces for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryInterfaces(Collection<InstanceSecondaryInterface> secondaryInterfaces);

        /**
         * <p>
         * The secondary interfaces for the instance.
         * </p>
         * 
         * @param secondaryInterfaces
         *        The secondary interfaces for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryInterfaces(InstanceSecondaryInterface... secondaryInterfaces);

        /**
         * <p>
         * The secondary interfaces for the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterface.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterface#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterface.Builder#build()} is called
         * immediately and its result is passed to {@link #secondaryInterfaces(List<InstanceSecondaryInterface>)}.
         * 
         * @param secondaryInterfaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryInterfaces(java.util.Collection<InstanceSecondaryInterface>)
         */
        Builder secondaryInterfaces(Consumer<InstanceSecondaryInterface.Builder>... secondaryInterfaces);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ID of the AMI used to launch the instance.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI used to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param state
         *        The current state of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(InstanceState state);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceState.Builder} avoiding the need
         * to create one manually via {@link InstanceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(InstanceState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(InstanceState)
         */
        default Builder state(Consumer<InstanceState.Builder> state) {
            return state(InstanceState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * [IPv4 only] The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside
         * the Amazon EC2 network. This name is not available until the instance enters the <code>running</code> state.
         * </p>
         * <p>
         * The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS
         * resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your VPC,
         * your custom domain name servers must resolve the hostname as appropriate.
         * </p>
         * 
         * @param privateDnsName
         *        [IPv4 only] The private DNS hostname name assigned to the instance. This DNS hostname can only be used
         *        inside the Amazon EC2 network. This name is not available until the instance enters the
         *        <code>running</code> state. </p>
         *        <p>
         *        The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS
         *        resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your
         *        VPC, your custom domain name servers must resolve the hostname as appropriate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The public DNS name assigned to the instance. This name is not available until the instance enters the
         * <code>running</code> state. This name is only available if you've enabled DNS hostnames for your VPC. The
         * format of this name depends on the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hostname-types.html#public-hostnames">public
         * hostname type</a>.
         * </p>
         * 
         * @param publicDnsName
         *        The public DNS name assigned to the instance. This name is not available until the instance enters the
         *        <code>running</code> state. This name is only available if you've enabled DNS hostnames for your VPC.
         *        The format of this name depends on the <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hostname-types.html#public-hostnames">public
         *        hostname type</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDnsName(String publicDnsName);

        /**
         * <p>
         * The reason for the most recent state transition. This might be an empty string.
         * </p>
         * 
         * @param stateTransitionReason
         *        The reason for the most recent state transition. This might be an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTransitionReason(String stateTransitionReason);

        /**
         * <p>
         * The name of the key pair, if this instance was launched with an associated key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair, if this instance was launched with an associated key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The AMI launch index, which can be used to find this instance in the launch group.
         * </p>
         * 
         * @param amiLaunchIndex
         *        The AMI launch index, which can be used to find this instance in the launch group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiLaunchIndex(Integer amiLaunchIndex);

        /**
         * <p>
         * The product codes attached to this instance, if applicable.
         * </p>
         * 
         * @param productCodes
         *        The product codes attached to this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * The product codes attached to this instance, if applicable.
         * </p>
         * 
         * @param productCodes
         *        The product codes attached to this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The product codes attached to this instance, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ProductCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder#build()} is called immediately and its
         * result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(java.util.Collection<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The time that the instance was last launched. To determine the time that instance was first launched, see the
         * attachment time for the primary network interface.
         * </p>
         * 
         * @param launchTime
         *        The time that the instance was last launched. To determine the time that instance was first launched,
         *        see the attachment time for the primary network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTime(Instant launchTime);

        /**
         * <p>
         * The location where the instance launched, if applicable.
         * </p>
         * 
         * @param placement
         *        The location where the instance launched, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(Placement placement);

        /**
         * <p>
         * The location where the instance launched, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the {@link Placement.Builder} avoiding the need to
         * create one manually via {@link Placement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Placement.Builder#build()} is called immediately and its result
         * is passed to {@link #placement(Placement)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link Placement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(Placement)
         */
        default Builder placement(Consumer<Placement.Builder> placement) {
            return placement(Placement.builder().applyMutation(placement).build());
        }

        /**
         * <p>
         * The kernel associated with this instance, if applicable.
         * </p>
         * 
         * @param kernelId
         *        The kernel associated with this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The RAM disk associated with this instance, if applicable.
         * </p>
         * 
         * @param ramdiskId
         *        The RAM disk associated with this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The platform. This value is <code>windows</code> for Windows instances; otherwise, it is empty.
         * </p>
         * 
         * @param platform
         *        The platform. This value is <code>windows</code> for Windows instances; otherwise, it is empty.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform. This value is <code>windows</code> for Windows instances; otherwise, it is empty.
         * </p>
         * 
         * @param platform
         *        The platform. This value is <code>windows</code> for Windows instances; otherwise, it is empty.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(PlatformValues platform);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * 
         * @param monitoring
         *        The monitoring for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(Monitoring monitoring);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link Monitoring.Builder} avoiding the need to
         * create one manually via {@link Monitoring#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Monitoring.Builder#build()} is called immediately and its result
         * is passed to {@link #monitoring(Monitoring)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link Monitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(Monitoring)
         */
        default Builder monitoring(Consumer<Monitoring.Builder> monitoring) {
            return monitoring(Monitoring.builder().applyMutation(monitoring).build());
        }

        /**
         * <p>
         * The ID of the subnet in which the instance is running.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in which the instance is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The ID of the VPC in which the instance is running.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC in which the instance is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The private IPv4 address assigned to the instance.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IPv4 address assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The public IPv4 address, or the Carrier IP address assigned to the instance, if applicable.
         * </p>
         * <p>
         * A Carrier IP address only applies to an instance launched in a subnet associated with a Wavelength Zone.
         * </p>
         * 
         * @param publicIpAddress
         *        The public IPv4 address, or the Carrier IP address assigned to the instance, if applicable.</p>
         *        <p>
         *        A Carrier IP address only applies to an instance launched in a subnet associated with a Wavelength
         *        Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpAddress(String publicIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private String architecture;

        private List<InstanceBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private Boolean ebsOptimized;

        private Boolean enaSupport;

        private String hypervisor;

        private IamInstanceProfile iamInstanceProfile;

        private String instanceLifecycle;

        private List<ElasticGpuAssociation> elasticGpuAssociations = DefaultSdkAutoConstructList.getInstance();

        private List<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations = DefaultSdkAutoConstructList
                .getInstance();

        private List<InstanceNetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private String outpostArn;

        private String rootDeviceName;

        private String rootDeviceType;

        private List<GroupIdentifier> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private Boolean sourceDestCheck;

        private String spotInstanceRequestId;

        private String sriovNetSupport;

        private StateReason stateReason;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String virtualizationType;

        private CpuOptions cpuOptions;

        private String capacityBlockId;

        private String capacityReservationId;

        private CapacityReservationSpecificationResponse capacityReservationSpecification;

        private HibernationOptions hibernationOptions;

        private List<LicenseConfiguration> licenses = DefaultSdkAutoConstructList.getInstance();

        private InstanceMetadataOptionsResponse metadataOptions;

        private EnclaveOptions enclaveOptions;

        private String bootMode;

        private String platformDetails;

        private String usageOperation;

        private Instant usageOperationUpdateTime;

        private PrivateDnsNameOptionsResponse privateDnsNameOptions;

        private String ipv6Address;

        private String tpmSupport;

        private InstanceMaintenanceOptions maintenanceOptions;

        private String currentInstanceBootMode;

        private InstanceNetworkPerformanceOptions networkPerformanceOptions;

        private OperatorResponse operator;

        private List<InstanceSecondaryInterface> secondaryInterfaces = DefaultSdkAutoConstructList.getInstance();

        private String instanceId;

        private String imageId;

        private InstanceState state;

        private String privateDnsName;

        private String publicDnsName;

        private String stateTransitionReason;

        private String keyName;

        private Integer amiLaunchIndex;

        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private String instanceType;

        private Instant launchTime;

        private Placement placement;

        private String kernelId;

        private String ramdiskId;

        private String platform;

        private Monitoring monitoring;

        private String subnetId;

        private String vpcId;

        private String privateIpAddress;

        private String publicIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            architecture(model.architecture);
            blockDeviceMappings(model.blockDeviceMappings);
            clientToken(model.clientToken);
            ebsOptimized(model.ebsOptimized);
            enaSupport(model.enaSupport);
            hypervisor(model.hypervisor);
            iamInstanceProfile(model.iamInstanceProfile);
            instanceLifecycle(model.instanceLifecycle);
            elasticGpuAssociations(model.elasticGpuAssociations);
            elasticInferenceAcceleratorAssociations(model.elasticInferenceAcceleratorAssociations);
            networkInterfaces(model.networkInterfaces);
            outpostArn(model.outpostArn);
            rootDeviceName(model.rootDeviceName);
            rootDeviceType(model.rootDeviceType);
            securityGroups(model.securityGroups);
            sourceDestCheck(model.sourceDestCheck);
            spotInstanceRequestId(model.spotInstanceRequestId);
            sriovNetSupport(model.sriovNetSupport);
            stateReason(model.stateReason);
            tags(model.tags);
            virtualizationType(model.virtualizationType);
            cpuOptions(model.cpuOptions);
            capacityBlockId(model.capacityBlockId);
            capacityReservationId(model.capacityReservationId);
            capacityReservationSpecification(model.capacityReservationSpecification);
            hibernationOptions(model.hibernationOptions);
            licenses(model.licenses);
            metadataOptions(model.metadataOptions);
            enclaveOptions(model.enclaveOptions);
            bootMode(model.bootMode);
            platformDetails(model.platformDetails);
            usageOperation(model.usageOperation);
            usageOperationUpdateTime(model.usageOperationUpdateTime);
            privateDnsNameOptions(model.privateDnsNameOptions);
            ipv6Address(model.ipv6Address);
            tpmSupport(model.tpmSupport);
            maintenanceOptions(model.maintenanceOptions);
            currentInstanceBootMode(model.currentInstanceBootMode);
            networkPerformanceOptions(model.networkPerformanceOptions);
            operator(model.operator);
            secondaryInterfaces(model.secondaryInterfaces);
            instanceId(model.instanceId);
            imageId(model.imageId);
            state(model.state);
            privateDnsName(model.privateDnsName);
            publicDnsName(model.publicDnsName);
            stateTransitionReason(model.stateTransitionReason);
            keyName(model.keyName);
            amiLaunchIndex(model.amiLaunchIndex);
            productCodes(model.productCodes);
            instanceType(model.instanceType);
            launchTime(model.launchTime);
            placement(model.placement);
            kernelId(model.kernelId);
            ramdiskId(model.ramdiskId);
            platform(model.platform);
            monitoring(model.monitoring);
            subnetId(model.subnetId);
            vpcId(model.vpcId);
            privateIpAddress(model.privateIpAddress);
            publicIpAddress(model.publicIpAddress);
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final List<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<InstanceBlockDeviceMapping.Builder> result = InstanceBlockDeviceMappingListCopier
                    .copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings)
                    .map(c -> InstanceBlockDeviceMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final Boolean getEnaSupport() {
            return enaSupport;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final String getHypervisor() {
            return hypervisor;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public final Builder hypervisor(HypervisorType hypervisor) {
            this.hypervisor(hypervisor == null ? null : hypervisor.toString());
            return this;
        }

        public final IamInstanceProfile.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getInstanceLifecycle() {
            return instanceLifecycle;
        }

        public final void setInstanceLifecycle(String instanceLifecycle) {
            this.instanceLifecycle = instanceLifecycle;
        }

        @Override
        public final Builder instanceLifecycle(String instanceLifecycle) {
            this.instanceLifecycle = instanceLifecycle;
            return this;
        }

        @Override
        public final Builder instanceLifecycle(InstanceLifecycleType instanceLifecycle) {
            this.instanceLifecycle(instanceLifecycle == null ? null : instanceLifecycle.toString());
            return this;
        }

        public final List<ElasticGpuAssociation.Builder> getElasticGpuAssociations() {
            List<ElasticGpuAssociation.Builder> result = ElasticGpuAssociationListCopier
                    .copyToBuilder(this.elasticGpuAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticGpuAssociations(Collection<ElasticGpuAssociation.BuilderImpl> elasticGpuAssociations) {
            this.elasticGpuAssociations = ElasticGpuAssociationListCopier.copyFromBuilder(elasticGpuAssociations);
        }

        @Override
        public final Builder elasticGpuAssociations(Collection<ElasticGpuAssociation> elasticGpuAssociations) {
            this.elasticGpuAssociations = ElasticGpuAssociationListCopier.copy(elasticGpuAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuAssociations(ElasticGpuAssociation... elasticGpuAssociations) {
            elasticGpuAssociations(Arrays.asList(elasticGpuAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuAssociations(Consumer<ElasticGpuAssociation.Builder>... elasticGpuAssociations) {
            elasticGpuAssociations(Stream.of(elasticGpuAssociations)
                    .map(c -> ElasticGpuAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ElasticInferenceAcceleratorAssociation.Builder> getElasticInferenceAcceleratorAssociations() {
            List<ElasticInferenceAcceleratorAssociation.Builder> result = ElasticInferenceAcceleratorAssociationListCopier
                    .copyToBuilder(this.elasticInferenceAcceleratorAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticInferenceAcceleratorAssociations(
                Collection<ElasticInferenceAcceleratorAssociation.BuilderImpl> elasticInferenceAcceleratorAssociations) {
            this.elasticInferenceAcceleratorAssociations = ElasticInferenceAcceleratorAssociationListCopier
                    .copyFromBuilder(elasticInferenceAcceleratorAssociations);
        }

        @Override
        public final Builder elasticInferenceAcceleratorAssociations(
                Collection<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations) {
            this.elasticInferenceAcceleratorAssociations = ElasticInferenceAcceleratorAssociationListCopier
                    .copy(elasticInferenceAcceleratorAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAcceleratorAssociations(
                ElasticInferenceAcceleratorAssociation... elasticInferenceAcceleratorAssociations) {
            elasticInferenceAcceleratorAssociations(Arrays.asList(elasticInferenceAcceleratorAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAcceleratorAssociations(
                Consumer<ElasticInferenceAcceleratorAssociation.Builder>... elasticInferenceAcceleratorAssociations) {
            elasticInferenceAcceleratorAssociations(Stream.of(elasticInferenceAcceleratorAssociations)
                    .map(c -> ElasticInferenceAcceleratorAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<InstanceNetworkInterface.Builder> getNetworkInterfaces() {
            List<InstanceNetworkInterface.Builder> result = InstanceNetworkInterfaceListCopier
                    .copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterface> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterface... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterface.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces).map(c -> InstanceNetworkInterface.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getRootDeviceName() {
            return rootDeviceName;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final String getRootDeviceType() {
            return rootDeviceType;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(DeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType == null ? null : rootDeviceType.toString());
            return this;
        }

        public final List<GroupIdentifier.Builder> getSecurityGroups() {
            List<GroupIdentifier.Builder> result = GroupIdentifierListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<GroupIdentifier.BuilderImpl> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(GroupIdentifier... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<GroupIdentifier.Builder>... securityGroups) {
            securityGroups(Stream.of(securityGroups).map(c -> GroupIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final String getSpotInstanceRequestId() {
            return spotInstanceRequestId;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final String getSriovNetSupport() {
            return sriovNetSupport;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final StateReason.Builder getStateReason() {
            return stateReason != null ? stateReason.toBuilder() : null;
        }

        public final void setStateReason(StateReason.BuilderImpl stateReason) {
            this.stateReason = stateReason != null ? stateReason.build() : null;
        }

        @Override
        public final Builder stateReason(StateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVirtualizationType() {
            return virtualizationType;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType == null ? null : virtualizationType.toString());
            return this;
        }

        public final CpuOptions.Builder getCpuOptions() {
            return cpuOptions != null ? cpuOptions.toBuilder() : null;
        }

        public final void setCpuOptions(CpuOptions.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        @Override
        public final Builder cpuOptions(CpuOptions cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final String getCapacityBlockId() {
            return capacityBlockId;
        }

        public final void setCapacityBlockId(String capacityBlockId) {
            this.capacityBlockId = capacityBlockId;
        }

        @Override
        public final Builder capacityBlockId(String capacityBlockId) {
            this.capacityBlockId = capacityBlockId;
            return this;
        }

        public final String getCapacityReservationId() {
            return capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final CapacityReservationSpecificationResponse.Builder getCapacityReservationSpecification() {
            return capacityReservationSpecification != null ? capacityReservationSpecification.toBuilder() : null;
        }

        public final void setCapacityReservationSpecification(
                CapacityReservationSpecificationResponse.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification
                    .build() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(
                CapacityReservationSpecificationResponse capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final HibernationOptions.Builder getHibernationOptions() {
            return hibernationOptions != null ? hibernationOptions.toBuilder() : null;
        }

        public final void setHibernationOptions(HibernationOptions.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        @Override
        public final Builder hibernationOptions(HibernationOptions hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final List<LicenseConfiguration.Builder> getLicenses() {
            List<LicenseConfiguration.Builder> result = LicenseListCopier.copyToBuilder(this.licenses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenses(Collection<LicenseConfiguration.BuilderImpl> licenses) {
            this.licenses = LicenseListCopier.copyFromBuilder(licenses);
        }

        @Override
        public final Builder licenses(Collection<LicenseConfiguration> licenses) {
            this.licenses = LicenseListCopier.copy(licenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenses(LicenseConfiguration... licenses) {
            licenses(Arrays.asList(licenses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenses(Consumer<LicenseConfiguration.Builder>... licenses) {
            licenses(Stream.of(licenses).map(c -> LicenseConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstanceMetadataOptionsResponse.Builder getMetadataOptions() {
            return metadataOptions != null ? metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(InstanceMetadataOptionsResponse.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(InstanceMetadataOptionsResponse metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final EnclaveOptions.Builder getEnclaveOptions() {
            return enclaveOptions != null ? enclaveOptions.toBuilder() : null;
        }

        public final void setEnclaveOptions(EnclaveOptions.BuilderImpl enclaveOptions) {
            this.enclaveOptions = enclaveOptions != null ? enclaveOptions.build() : null;
        }

        @Override
        public final Builder enclaveOptions(EnclaveOptions enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        public final String getBootMode() {
            return bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootModeValues bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        public final String getPlatformDetails() {
            return platformDetails;
        }

        public final void setPlatformDetails(String platformDetails) {
            this.platformDetails = platformDetails;
        }

        @Override
        public final Builder platformDetails(String platformDetails) {
            this.platformDetails = platformDetails;
            return this;
        }

        public final String getUsageOperation() {
            return usageOperation;
        }

        public final void setUsageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
        }

        @Override
        public final Builder usageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
            return this;
        }

        public final Instant getUsageOperationUpdateTime() {
            return usageOperationUpdateTime;
        }

        public final void setUsageOperationUpdateTime(Instant usageOperationUpdateTime) {
            this.usageOperationUpdateTime = usageOperationUpdateTime;
        }

        @Override
        public final Builder usageOperationUpdateTime(Instant usageOperationUpdateTime) {
            this.usageOperationUpdateTime = usageOperationUpdateTime;
            return this;
        }

        public final PrivateDnsNameOptionsResponse.Builder getPrivateDnsNameOptions() {
            return privateDnsNameOptions != null ? privateDnsNameOptions.toBuilder() : null;
        }

        public final void setPrivateDnsNameOptions(PrivateDnsNameOptionsResponse.BuilderImpl privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions != null ? privateDnsNameOptions.build() : null;
        }

        @Override
        public final Builder privateDnsNameOptions(PrivateDnsNameOptionsResponse privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions;
            return this;
        }

        public final String getIpv6Address() {
            return ipv6Address;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        @Override
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public final String getTpmSupport() {
            return tpmSupport;
        }

        public final void setTpmSupport(String tpmSupport) {
            this.tpmSupport = tpmSupport;
        }

        @Override
        public final Builder tpmSupport(String tpmSupport) {
            this.tpmSupport = tpmSupport;
            return this;
        }

        public final InstanceMaintenanceOptions.Builder getMaintenanceOptions() {
            return maintenanceOptions != null ? maintenanceOptions.toBuilder() : null;
        }

        public final void setMaintenanceOptions(InstanceMaintenanceOptions.BuilderImpl maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions != null ? maintenanceOptions.build() : null;
        }

        @Override
        public final Builder maintenanceOptions(InstanceMaintenanceOptions maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions;
            return this;
        }

        public final String getCurrentInstanceBootMode() {
            return currentInstanceBootMode;
        }

        public final void setCurrentInstanceBootMode(String currentInstanceBootMode) {
            this.currentInstanceBootMode = currentInstanceBootMode;
        }

        @Override
        public final Builder currentInstanceBootMode(String currentInstanceBootMode) {
            this.currentInstanceBootMode = currentInstanceBootMode;
            return this;
        }

        @Override
        public final Builder currentInstanceBootMode(InstanceBootModeValues currentInstanceBootMode) {
            this.currentInstanceBootMode(currentInstanceBootMode == null ? null : currentInstanceBootMode.toString());
            return this;
        }

        public final InstanceNetworkPerformanceOptions.Builder getNetworkPerformanceOptions() {
            return networkPerformanceOptions != null ? networkPerformanceOptions.toBuilder() : null;
        }

        public final void setNetworkPerformanceOptions(InstanceNetworkPerformanceOptions.BuilderImpl networkPerformanceOptions) {
            this.networkPerformanceOptions = networkPerformanceOptions != null ? networkPerformanceOptions.build() : null;
        }

        @Override
        public final Builder networkPerformanceOptions(InstanceNetworkPerformanceOptions networkPerformanceOptions) {
            this.networkPerformanceOptions = networkPerformanceOptions;
            return this;
        }

        public final OperatorResponse.Builder getOperator() {
            return operator != null ? operator.toBuilder() : null;
        }

        public final void setOperator(OperatorResponse.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorResponse operator) {
            this.operator = operator;
            return this;
        }

        public final List<InstanceSecondaryInterface.Builder> getSecondaryInterfaces() {
            List<InstanceSecondaryInterface.Builder> result = InstanceSecondaryInterfaceListCopier
                    .copyToBuilder(this.secondaryInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryInterfaces(Collection<InstanceSecondaryInterface.BuilderImpl> secondaryInterfaces) {
            this.secondaryInterfaces = InstanceSecondaryInterfaceListCopier.copyFromBuilder(secondaryInterfaces);
        }

        @Override
        public final Builder secondaryInterfaces(Collection<InstanceSecondaryInterface> secondaryInterfaces) {
            this.secondaryInterfaces = InstanceSecondaryInterfaceListCopier.copy(secondaryInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryInterfaces(InstanceSecondaryInterface... secondaryInterfaces) {
            secondaryInterfaces(Arrays.asList(secondaryInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryInterfaces(Consumer<InstanceSecondaryInterface.Builder>... secondaryInterfaces) {
            secondaryInterfaces(Stream.of(secondaryInterfaces)
                    .map(c -> InstanceSecondaryInterface.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final InstanceState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final String getPublicDnsName() {
            return publicDnsName;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final String getStateTransitionReason() {
            return stateTransitionReason;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final Integer getAmiLaunchIndex() {
            return amiLaunchIndex;
        }

        public final void setAmiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
        }

        @Override
        public final Builder amiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
            return this;
        }

        public final List<ProductCode.Builder> getProductCodes() {
            List<ProductCode.Builder> result = ProductCodeListCopier.copyToBuilder(this.productCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Instant getLaunchTime() {
            return launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final Placement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final String getKernelId() {
            return kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final Monitoring.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        public final void setMonitoring(Monitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        public final Builder monitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final String getPublicIpAddress() {
            return publicIpAddress;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
