/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a single AMI in the ancestry chain and its source (parent) AMI.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageAncestryEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageAncestryEntry.Builder, ImageAncestryEntry> {
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate")
            .getter(getter(ImageAncestryEntry::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate")
                    .unmarshallLocationName("creationDate").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(ImageAncestryEntry::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> IMAGE_OWNER_ALIAS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageOwnerAlias")
            .getter(getter(ImageAncestryEntry::imageOwnerAlias))
            .setter(setter(Builder::imageOwnerAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageOwnerAlias")
                    .unmarshallLocationName("imageOwnerAlias").build()).build();

    private static final SdkField<String> SOURCE_IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceImageId")
            .getter(getter(ImageAncestryEntry::sourceImageId))
            .setter(setter(Builder::sourceImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageId")
                    .unmarshallLocationName("sourceImageId").build()).build();

    private static final SdkField<String> SOURCE_IMAGE_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceImageRegion")
            .getter(getter(ImageAncestryEntry::sourceImageRegion))
            .setter(setter(Builder::sourceImageRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageRegion")
                    .unmarshallLocationName("sourceImageRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD,
            IMAGE_ID_FIELD, IMAGE_OWNER_ALIAS_FIELD, SOURCE_IMAGE_ID_FIELD, SOURCE_IMAGE_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant creationDate;

    private final String imageId;

    private final String imageOwnerAlias;

    private final String sourceImageId;

    private final String sourceImageRegion;

    private ImageAncestryEntry(BuilderImpl builder) {
        this.creationDate = builder.creationDate;
        this.imageId = builder.imageId;
        this.imageOwnerAlias = builder.imageOwnerAlias;
        this.sourceImageId = builder.sourceImageId;
        this.sourceImageRegion = builder.sourceImageRegion;
    }

    /**
     * <p>
     * The date and time when this AMI was created.
     * </p>
     * 
     * @return The date and time when this AMI was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The ID of this AMI.
     * </p>
     * 
     * @return The ID of this AMI.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The owner alias (<code>amazon</code> | <code>aws-backup-vault</code> | <code>aws-marketplace</code> ) of this
     * AMI, if one is assigned. Otherwise, the value is <code>null</code>.
     * </p>
     * 
     * @return The owner alias (<code>amazon</code> | <code>aws-backup-vault</code> | <code>aws-marketplace</code> ) of
     *         this AMI, if one is assigned. Otherwise, the value is <code>null</code>.
     */
    public final String imageOwnerAlias() {
        return imageOwnerAlias;
    }

    /**
     * <p>
     * The ID of the parent AMI.
     * </p>
     * 
     * @return The ID of the parent AMI.
     */
    public final String sourceImageId() {
        return sourceImageId;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the parent AMI.
     * </p>
     * 
     * @return The Amazon Web Services Region of the parent AMI.
     */
    public final String sourceImageRegion() {
        return sourceImageRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(imageOwnerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(sourceImageId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceImageRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageAncestryEntry)) {
            return false;
        }
        ImageAncestryEntry other = (ImageAncestryEntry) obj;
        return Objects.equals(creationDate(), other.creationDate()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(imageOwnerAlias(), other.imageOwnerAlias())
                && Objects.equals(sourceImageId(), other.sourceImageId())
                && Objects.equals(sourceImageRegion(), other.sourceImageRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageAncestryEntry").add("CreationDate", creationDate()).add("ImageId", imageId())
                .add("ImageOwnerAlias", imageOwnerAlias()).add("SourceImageId", sourceImageId())
                .add("SourceImageRegion", sourceImageRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ImageOwnerAlias":
            return Optional.ofNullable(clazz.cast(imageOwnerAlias()));
        case "SourceImageId":
            return Optional.ofNullable(clazz.cast(sourceImageId()));
        case "SourceImageRegion":
            return Optional.ofNullable(clazz.cast(sourceImageRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("ImageOwnerAlias", IMAGE_OWNER_ALIAS_FIELD);
        map.put("SourceImageId", SOURCE_IMAGE_ID_FIELD);
        map.put("SourceImageRegion", SOURCE_IMAGE_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageAncestryEntry, T> g) {
        return obj -> g.apply((ImageAncestryEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageAncestryEntry> {
        /**
         * <p>
         * The date and time when this AMI was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time when this AMI was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The ID of this AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of this AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The owner alias (<code>amazon</code> | <code>aws-backup-vault</code> | <code>aws-marketplace</code> ) of this
         * AMI, if one is assigned. Otherwise, the value is <code>null</code>.
         * </p>
         * 
         * @param imageOwnerAlias
         *        The owner alias (<code>amazon</code> | <code>aws-backup-vault</code> | <code>aws-marketplace</code> )
         *        of this AMI, if one is assigned. Otherwise, the value is <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageOwnerAlias(String imageOwnerAlias);

        /**
         * <p>
         * The ID of the parent AMI.
         * </p>
         * 
         * @param sourceImageId
         *        The ID of the parent AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImageId(String sourceImageId);

        /**
         * <p>
         * The Amazon Web Services Region of the parent AMI.
         * </p>
         * 
         * @param sourceImageRegion
         *        The Amazon Web Services Region of the parent AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImageRegion(String sourceImageRegion);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationDate;

        private String imageId;

        private String imageOwnerAlias;

        private String sourceImageId;

        private String sourceImageRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageAncestryEntry model) {
            creationDate(model.creationDate);
            imageId(model.imageId);
            imageOwnerAlias(model.imageOwnerAlias);
            sourceImageId(model.sourceImageId);
            sourceImageRegion(model.sourceImageRegion);
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getImageOwnerAlias() {
            return imageOwnerAlias;
        }

        public final void setImageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
        }

        @Override
        public final Builder imageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
            return this;
        }

        public final String getSourceImageId() {
            return sourceImageId;
        }

        public final void setSourceImageId(String sourceImageId) {
            this.sourceImageId = sourceImageId;
        }

        @Override
        public final Builder sourceImageId(String sourceImageId) {
            this.sourceImageId = sourceImageId;
            return this;
        }

        public final String getSourceImageRegion() {
            return sourceImageRegion;
        }

        public final void setSourceImageRegion(String sourceImageRegion) {
            this.sourceImageRegion = sourceImageRegion;
        }

        @Override
        public final Builder sourceImageRegion(String sourceImageRegion) {
            this.sourceImageRegion = sourceImageRegion;
            return this;
        }

        @Override
        public ImageAncestryEntry build() {
            return new ImageAncestryEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
