/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCapacityReservationTopologyResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeCapacityReservationTopologyResponse.Builder, DescribeCapacityReservationTopologyResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeCapacityReservationTopologyResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<CapacityReservationTopology>> CAPACITY_RESERVATIONS_FIELD = SdkField
            .<List<CapacityReservationTopology>> builder(MarshallingType.LIST)
            .memberName("CapacityReservations")
            .getter(getter(DescribeCapacityReservationTopologyResponse::capacityReservations))
            .setter(setter(Builder::capacityReservations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSet")
                    .unmarshallLocationName("capacityReservationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CapacityReservationTopology> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityReservationTopology::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CAPACITY_RESERVATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<CapacityReservationTopology> capacityReservations;

    private DescribeCapacityReservationTopologyResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.capacityReservations = builder.capacityReservations;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityReservations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapacityReservations() {
        return capacityReservations != null && !(capacityReservations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the topology of each Capacity Reservation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityReservations} method.
     * </p>
     * 
     * @return Information about the topology of each Capacity Reservation.
     */
    public final List<CapacityReservationTopology> capacityReservations() {
        return capacityReservations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityReservations() ? capacityReservations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityReservationTopologyResponse)) {
            return false;
        }
        DescribeCapacityReservationTopologyResponse other = (DescribeCapacityReservationTopologyResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasCapacityReservations() == other.hasCapacityReservations()
                && Objects.equals(capacityReservations(), other.capacityReservations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCapacityReservationTopologyResponse").add("NextToken", nextToken())
                .add("CapacityReservations", hasCapacityReservations() ? capacityReservations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CapacityReservations":
            return Optional.ofNullable(clazz.cast(capacityReservations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("CapacityReservationSet", CAPACITY_RESERVATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityReservationTopologyResponse, T> g) {
        return obj -> g.apply((DescribeCapacityReservationTopologyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCapacityReservationTopologyResponse> {
        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the topology of each Capacity Reservation.
         * </p>
         * 
         * @param capacityReservations
         *        Information about the topology of each Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservations(Collection<CapacityReservationTopology> capacityReservations);

        /**
         * <p>
         * Information about the topology of each Capacity Reservation.
         * </p>
         * 
         * @param capacityReservations
         *        Information about the topology of each Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservations(CapacityReservationTopology... capacityReservations);

        /**
         * <p>
         * Information about the topology of each Capacity Reservation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CapacityReservationTopology.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.CapacityReservationTopology#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CapacityReservationTopology.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityReservations(List<CapacityReservationTopology>)}.
         * 
         * @param capacityReservations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CapacityReservationTopology.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservations(java.util.Collection<CapacityReservationTopology>)
         */
        Builder capacityReservations(Consumer<CapacityReservationTopology.Builder>... capacityReservations);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<CapacityReservationTopology> capacityReservations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityReservationTopologyResponse model) {
            super(model);
            nextToken(model.nextToken);
            capacityReservations(model.capacityReservations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CapacityReservationTopology.Builder> getCapacityReservations() {
            List<CapacityReservationTopology.Builder> result = CapacityReservationTopologySetCopier
                    .copyToBuilder(this.capacityReservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityReservations(Collection<CapacityReservationTopology.BuilderImpl> capacityReservations) {
            this.capacityReservations = CapacityReservationTopologySetCopier.copyFromBuilder(capacityReservations);
        }

        @Override
        public final Builder capacityReservations(Collection<CapacityReservationTopology> capacityReservations) {
            this.capacityReservations = CapacityReservationTopologySetCopier.copy(capacityReservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservations(CapacityReservationTopology... capacityReservations) {
            capacityReservations(Arrays.asList(capacityReservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservations(Consumer<CapacityReservationTopology.Builder>... capacityReservations) {
            capacityReservations(Stream.of(capacityReservations)
                    .map(c -> CapacityReservationTopology.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCapacityReservationTopologyResponse build() {
            return new DescribeCapacityReservationTopologyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
