/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform.internal;

import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.awscore.util.AwsHostNameUtils;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4FamilyHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.SignerConstant;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.protocols.query.AwsEc2ProtocolFactory;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.CopySnapshotRequest;
import software.amazon.awssdk.services.ec2.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public final class GeneratePreSignUrlInterceptor
implements ExecutionInterceptor {
    private static final ClientEndpointProvider CUSTOM_ENDPOINT_PROVIDER_LOCALHOST = ClientEndpointProvider.forEndpointOverride((URI)URI.create("http://localhost"));
    private static final AwsEc2ProtocolFactory PROTOCOL_FACTORY = ((AwsEc2ProtocolFactory.Builder)AwsEc2ProtocolFactory.builder().clientConfiguration(SdkClientConfiguration.builder().option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER, (Object)CUSTOM_ENDPOINT_PROVIDER_LOCALHOST).build())).build();
    private static final CopySnapshotRequestMarshaller MARSHALLER = new CopySnapshotRequestMarshaller((AwsQueryProtocolFactory)PROTOCOL_FACTORY);
    private final Clock testClock;

    public GeneratePreSignUrlInterceptor() {
        this.testClock = null;
    }

    @SdkTestInternalApi
    GeneratePreSignUrlInterceptor(Clock testClock) {
        this.testClock = testClock;
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest request = context.httpRequest();
        SdkRequest originalRequest = context.request();
        if (originalRequest instanceof CopySnapshotRequest) {
            CopySnapshotRequest originalCopySnapshotRequest = (CopySnapshotRequest)originalRequest;
            if (originalCopySnapshotRequest.presignedUrl() != null) {
                return request;
            }
            String serviceName = "ec2";
            String sourceRegion = originalCopySnapshotRequest.sourceRegion();
            String sourceSnapshotId = originalCopySnapshotRequest.sourceSnapshotId();
            String destinationRegion = originalCopySnapshotRequest.destinationRegion();
            if (destinationRegion == null) {
                destinationRegion = ((Region)AwsHostNameUtils.parseSigningRegion((String)request.host(), (String)serviceName).orElseThrow(() -> new IllegalArgumentException("Could not determine region for " + request.host()))).id();
            }
            URI endPointSource = this.createEndpoint(sourceRegion, serviceName);
            SdkHttpFullRequest requestForPresigning = this.generateRequestForPresigning(sourceSnapshotId, sourceRegion, destinationRegion).toBuilder().uri(endPointSource).method(SdkHttpMethod.GET).build();
            URI presignedUrl = this.sraPresignRequest(executionAttributes, requestForPresigning, sourceRegion);
            return (SdkHttpRequest)((SdkHttpRequest.Builder)request.toBuilder()).putRawQueryParameter("DestinationRegion", destinationRegion).putRawQueryParameter("PresignedUrl", presignedUrl.toString()).build();
        }
        return request;
    }

    private URI sraPresignRequest(ExecutionAttributes executionAttributes, SdkHttpFullRequest request, String signingRegion) {
        SelectedAuthScheme selectedAuthScheme = (SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
        Instant signingInstant = this.testClock != null ? this.testClock.instant() : Instant.now();
        Clock signingClock = Clock.fixed(signingInstant, ZoneOffset.UTC);
        Duration expirationDuration = SignerConstant.PRESIGN_URL_MAX_EXPIRATION_DURATION;
        return this.doSraPresign(request, selectedAuthScheme, signingRegion, signingClock, expirationDuration);
    }

    private <T extends Identity> URI doSraPresign(SdkHttpFullRequest request, SelectedAuthScheme<T> selectedAuthScheme, String signingRegion, Clock signingClock, Duration expirationDuration) {
        CompletableFuture identityFuture = selectedAuthScheme.identity();
        Identity identity = (Identity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture);
        SignRequest.Builder signRequestBuilder = (SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)SignRequest.builder((Identity)identity).putProperty(AwsV4FamilyHttpSigner.AUTH_LOCATION, (Object)AwsV4FamilyHttpSigner.AuthLocation.QUERY_STRING)).putProperty(AwsV4FamilyHttpSigner.EXPIRATION_DURATION, (Object)expirationDuration)).putProperty(HttpSigner.SIGNING_CLOCK, (Object)signingClock)).request((SdkHttpRequest)request)).payload((Object)request.contentStreamProvider().orElse(null));
        AuthSchemeOption authSchemeOption = selectedAuthScheme.authSchemeOption();
        authSchemeOption.forEachSignerProperty((arg_0, arg_1) -> ((SignRequest.Builder)signRequestBuilder).putProperty(arg_0, arg_1));
        signRequestBuilder.putProperty(AwsV4HttpSigner.REGION_NAME, (Object)signingRegion);
        HttpSigner signer = selectedAuthScheme.signer();
        SignedRequest signedRequest = signer.sign((SignRequest)signRequestBuilder.build());
        return signedRequest.request().getUri();
    }

    private SdkHttpFullRequest generateRequestForPresigning(String sourceSnapshotId, String sourceRegion, String destinationRegion) {
        CopySnapshotRequest copySnapshotRequest = (CopySnapshotRequest)((Object)CopySnapshotRequest.builder().sourceSnapshotId(sourceSnapshotId).sourceRegion(sourceRegion).destinationRegion(destinationRegion).build());
        return MARSHALLER.marshall(copySnapshotRequest);
    }

    private URI createEndpoint(String regionName, String serviceName) {
        Region region = Region.of((String)regionName);
        if (region == null) {
            throw SdkClientException.builder().message("{" + serviceName + ", " + regionName + "} was not found in region metadata. Update to latest version of SDK and try again.").build();
        }
        URI endpoint = Ec2Client.serviceMetadata().endpointFor(region);
        if (endpoint.getScheme() == null) {
            return URI.create("https://" + endpoint);
        }
        return endpoint;
    }
}

