/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredResourceCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredResourceCidrsResponse;
import software.amazon.awssdk.services.ec2.model.IpamDiscoveredResourceCidr;

public class GetIpamDiscoveredResourceCidrsPublisher
implements SdkPublisher<GetIpamDiscoveredResourceCidrsResponse> {
    private final Ec2AsyncClient client;
    private final GetIpamDiscoveredResourceCidrsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetIpamDiscoveredResourceCidrsPublisher(Ec2AsyncClient client, GetIpamDiscoveredResourceCidrsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetIpamDiscoveredResourceCidrsPublisher(Ec2AsyncClient client, GetIpamDiscoveredResourceCidrsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetIpamDiscoveredResourceCidrsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetIpamDiscoveredResourceCidrsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamDiscoveredResourceCidr> ipamDiscoveredResourceCidrs() {
        return this.flatMapIterable(response -> response.ipamDiscoveredResourceCidrs());
    }

    private class GetIpamDiscoveredResourceCidrsResponseFetcher
    implements AsyncPageFetcher<GetIpamDiscoveredResourceCidrsResponse> {
        private GetIpamDiscoveredResourceCidrsResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamDiscoveredResourceCidrsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetIpamDiscoveredResourceCidrsResponse> nextPage(GetIpamDiscoveredResourceCidrsResponse previousPage) {
            if (previousPage == null) {
                return GetIpamDiscoveredResourceCidrsPublisher.this.client.getIpamDiscoveredResourceCidrs(GetIpamDiscoveredResourceCidrsPublisher.this.firstRequest);
            }
            return GetIpamDiscoveredResourceCidrsPublisher.this.client.getIpamDiscoveredResourceCidrs((GetIpamDiscoveredResourceCidrsRequest)((Object)GetIpamDiscoveredResourceCidrsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

