/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSecondarySubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecondarySubnetsResponse;
import software.amazon.awssdk.services.ec2.model.SecondarySubnet;

public class DescribeSecondarySubnetsPublisher
implements SdkPublisher<DescribeSecondarySubnetsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeSecondarySubnetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSecondarySubnetsPublisher(Ec2AsyncClient client, DescribeSecondarySubnetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSecondarySubnetsPublisher(Ec2AsyncClient client, DescribeSecondarySubnetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSecondarySubnetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSecondarySubnetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecondarySubnet> secondarySubnets() {
        return this.flatMapIterable(response -> response.secondarySubnets());
    }

    private class DescribeSecondarySubnetsResponseFetcher
    implements AsyncPageFetcher<DescribeSecondarySubnetsResponse> {
        private DescribeSecondarySubnetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSecondarySubnetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSecondarySubnetsResponse> nextPage(DescribeSecondarySubnetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSecondarySubnetsPublisher.this.client.describeSecondarySubnets(DescribeSecondarySubnetsPublisher.this.firstRequest);
            }
            return DescribeSecondarySubnetsPublisher.this.client.describeSecondarySubnets((DescribeSecondarySubnetsRequest)((Object)DescribeSecondarySubnetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

