/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceLoggingConfiguration;

public class DescribeVerifiedAccessInstanceLoggingConfigurationsPublisher
implements SdkPublisher<DescribeVerifiedAccessInstanceLoggingConfigurationsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVerifiedAccessInstanceLoggingConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVerifiedAccessInstanceLoggingConfigurationsPublisher(Ec2AsyncClient client, DescribeVerifiedAccessInstanceLoggingConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVerifiedAccessInstanceLoggingConfigurationsPublisher(Ec2AsyncClient client, DescribeVerifiedAccessInstanceLoggingConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVerifiedAccessInstanceLoggingConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVerifiedAccessInstanceLoggingConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VerifiedAccessInstanceLoggingConfiguration> loggingConfigurations() {
        return this.flatMapIterable(response -> response.loggingConfigurations());
    }

    private class DescribeVerifiedAccessInstanceLoggingConfigurationsResponseFetcher
    implements AsyncPageFetcher<DescribeVerifiedAccessInstanceLoggingConfigurationsResponse> {
        private DescribeVerifiedAccessInstanceLoggingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVerifiedAccessInstanceLoggingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVerifiedAccessInstanceLoggingConfigurationsResponse> nextPage(DescribeVerifiedAccessInstanceLoggingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVerifiedAccessInstanceLoggingConfigurationsPublisher.this.client.describeVerifiedAccessInstanceLoggingConfigurations(DescribeVerifiedAccessInstanceLoggingConfigurationsPublisher.this.firstRequest);
            }
            return DescribeVerifiedAccessInstanceLoggingConfigurationsPublisher.this.client.describeVerifiedAccessInstanceLoggingConfigurations((DescribeVerifiedAccessInstanceLoggingConfigurationsRequest)((Object)DescribeVerifiedAccessInstanceLoggingConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

