/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRuleCondition;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRuleConditionSetCopier;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRuleType;
import software.amazon.awssdk.services.ec2.model.IpamResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamPrefixListResolverRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamPrefixListResolverRule> {
    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleType").getter(IpamPrefixListResolverRule.getter(IpamPrefixListResolverRule::ruleTypeAsString)).setter(IpamPrefixListResolverRule.setter(Builder::ruleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleType").unmarshallLocationName("ruleType").build()}).build();
    private static final SdkField<String> STATIC_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StaticCidr").getter(IpamPrefixListResolverRule.getter(IpamPrefixListResolverRule::staticCidr)).setter(IpamPrefixListResolverRule.setter(Builder::staticCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticCidr").unmarshallLocationName("staticCidr").build()}).build();
    private static final SdkField<String> IPAM_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamScopeId").getter(IpamPrefixListResolverRule.getter(IpamPrefixListResolverRule::ipamScopeId)).setter(IpamPrefixListResolverRule.setter(Builder::ipamScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScopeId").unmarshallLocationName("ipamScopeId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(IpamPrefixListResolverRule.getter(IpamPrefixListResolverRule::resourceTypeAsString)).setter(IpamPrefixListResolverRule.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<List<IpamPrefixListResolverRuleCondition>> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Conditions").getter(IpamPrefixListResolverRule.getter(IpamPrefixListResolverRule::conditions)).setter(IpamPrefixListResolverRule.setter(Builder::conditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionSet").unmarshallLocationName("conditionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamPrefixListResolverRuleCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_TYPE_FIELD, STATIC_CIDR_FIELD, IPAM_SCOPE_ID_FIELD, RESOURCE_TYPE_FIELD, CONDITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpamPrefixListResolverRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ruleType;
    private final String staticCidr;
    private final String ipamScopeId;
    private final String resourceType;
    private final List<IpamPrefixListResolverRuleCondition> conditions;

    private IpamPrefixListResolverRule(BuilderImpl builder) {
        this.ruleType = builder.ruleType;
        this.staticCidr = builder.staticCidr;
        this.ipamScopeId = builder.ipamScopeId;
        this.resourceType = builder.resourceType;
        this.conditions = builder.conditions;
    }

    public final IpamPrefixListResolverRuleType ruleType() {
        return IpamPrefixListResolverRuleType.fromValue(this.ruleType);
    }

    public final String ruleTypeAsString() {
        return this.ruleType;
    }

    public final String staticCidr() {
        return this.staticCidr;
    }

    public final String ipamScopeId() {
        return this.ipamScopeId;
    }

    public final IpamResourceType resourceType() {
        return IpamResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasConditions() {
        return this.conditions != null && !(this.conditions instanceof SdkAutoConstructList);
    }

    public final List<IpamPrefixListResolverRuleCondition> conditions() {
        return this.conditions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditions() ? this.conditions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPrefixListResolverRule)) {
            return false;
        }
        IpamPrefixListResolverRule other = (IpamPrefixListResolverRule)obj;
        return Objects.equals(this.ruleTypeAsString(), other.ruleTypeAsString()) && Objects.equals(this.staticCidr(), other.staticCidr()) && Objects.equals(this.ipamScopeId(), other.ipamScopeId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasConditions() == other.hasConditions() && Objects.equals(this.conditions(), other.conditions());
    }

    public final String toString() {
        return ToString.builder((String)"IpamPrefixListResolverRule").add("RuleType", (Object)this.ruleTypeAsString()).add("StaticCidr", (Object)this.staticCidr()).add("IpamScopeId", (Object)this.ipamScopeId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Conditions", this.hasConditions() ? this.conditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleType": {
                return Optional.ofNullable(clazz.cast(this.ruleTypeAsString()));
            }
            case "StaticCidr": {
                return Optional.ofNullable(clazz.cast(this.staticCidr()));
            }
            case "IpamScopeId": {
                return Optional.ofNullable(clazz.cast(this.ipamScopeId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "Conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleType", RULE_TYPE_FIELD);
        map.put("StaticCidr", STATIC_CIDR_FIELD);
        map.put("IpamScopeId", IPAM_SCOPE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ConditionSet", CONDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamPrefixListResolverRule, T> g) {
        return obj -> g.apply((IpamPrefixListResolverRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleType;
        private String staticCidr;
        private String ipamScopeId;
        private String resourceType;
        private List<IpamPrefixListResolverRuleCondition> conditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPrefixListResolverRule model) {
            this.ruleType(model.ruleType);
            this.staticCidr(model.staticCidr);
            this.ipamScopeId(model.ipamScopeId);
            this.resourceType(model.resourceType);
            this.conditions(model.conditions);
        }

        public final String getRuleType() {
            return this.ruleType;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(IpamPrefixListResolverRuleType ruleType) {
            this.ruleType(ruleType == null ? null : ruleType.toString());
            return this;
        }

        public final String getStaticCidr() {
            return this.staticCidr;
        }

        public final void setStaticCidr(String staticCidr) {
            this.staticCidr = staticCidr;
        }

        @Override
        public final Builder staticCidr(String staticCidr) {
            this.staticCidr = staticCidr;
            return this;
        }

        public final String getIpamScopeId() {
            return this.ipamScopeId;
        }

        public final void setIpamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
        }

        @Override
        public final Builder ipamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<IpamPrefixListResolverRuleCondition.Builder> getConditions() {
            List<IpamPrefixListResolverRuleCondition.Builder> result = IpamPrefixListResolverRuleConditionSetCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<IpamPrefixListResolverRuleCondition.BuilderImpl> conditions) {
            this.conditions = IpamPrefixListResolverRuleConditionSetCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<IpamPrefixListResolverRuleCondition> conditions) {
            this.conditions = IpamPrefixListResolverRuleConditionSetCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(IpamPrefixListResolverRuleCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<IpamPrefixListResolverRuleCondition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (IpamPrefixListResolverRuleCondition)((IpamPrefixListResolverRuleCondition.Builder)IpamPrefixListResolverRuleCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IpamPrefixListResolverRule build() {
            return new IpamPrefixListResolverRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamPrefixListResolverRule> {
        public Builder ruleType(String var1);

        public Builder ruleType(IpamPrefixListResolverRuleType var1);

        public Builder staticCidr(String var1);

        public Builder ipamScopeId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(IpamResourceType var1);

        public Builder conditions(Collection<IpamPrefixListResolverRuleCondition> var1);

        public Builder conditions(IpamPrefixListResolverRuleCondition ... var1);

        public Builder conditions(Consumer<IpamPrefixListResolverRuleCondition.Builder> ... var1);
    }
}

