/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTable;

public class DescribeTransitGatewayPolicyTablesPublisher
implements SdkPublisher<DescribeTransitGatewayPolicyTablesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeTransitGatewayPolicyTablesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTransitGatewayPolicyTablesPublisher(Ec2AsyncClient client, DescribeTransitGatewayPolicyTablesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTransitGatewayPolicyTablesPublisher(Ec2AsyncClient client, DescribeTransitGatewayPolicyTablesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTransitGatewayPolicyTablesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTransitGatewayPolicyTablesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransitGatewayPolicyTable> transitGatewayPolicyTables() {
        return this.flatMapIterable(response -> response.transitGatewayPolicyTables());
    }

    private class DescribeTransitGatewayPolicyTablesResponseFetcher
    implements AsyncPageFetcher<DescribeTransitGatewayPolicyTablesResponse> {
        private DescribeTransitGatewayPolicyTablesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayPolicyTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTransitGatewayPolicyTablesResponse> nextPage(DescribeTransitGatewayPolicyTablesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayPolicyTablesPublisher.this.client.describeTransitGatewayPolicyTables(DescribeTransitGatewayPolicyTablesPublisher.this.firstRequest);
            }
            return DescribeTransitGatewayPolicyTablesPublisher.this.client.describeTransitGatewayPolicyTables((DescribeTransitGatewayPolicyTablesRequest)((Object)DescribeTransitGatewayPolicyTablesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

