/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.VpcEncryptionControlExclusionStateInput;
import software.amazon.awssdk.services.ec2.model.VpcEncryptionControlMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcEncryptionControlRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpcEncryptionControlRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyVpcEncryptionControlRequest.getter(ModifyVpcEncryptionControlRequest::dryRun)).setter(ModifyVpcEncryptionControlRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> VPC_ENCRYPTION_CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEncryptionControlId").getter(ModifyVpcEncryptionControlRequest.getter(ModifyVpcEncryptionControlRequest::vpcEncryptionControlId)).setter(ModifyVpcEncryptionControlRequest.setter(Builder::vpcEncryptionControlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEncryptionControlId").unmarshallLocationName("VpcEncryptionControlId").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(ModifyVpcEncryptionControlRequest.getter(ModifyVpcEncryptionControlRequest::modeAsString)).setter(ModifyVpcEncryptionControlRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").unmarshallLocationName("Mode").build()}).build();
    private static final SdkField<String> INTERNET_GATEWAY_EXCLUSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InternetGatewayExclusion").getter(ModifyVpcEncryptionControlRequest.getter(ModifyVpcEncryptionControlRequest::internetGatewayExclusionAsString)).setter(ModifyVpcEncryptionControlRequest.setter(Builder::internetGatewayExclusion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayExclusion").unmarshallLocationName("InternetGatewayExclusion").build()}).build();
    private static final SdkField<String> EGRESS_ONLY_INTERNET_GATEWAY_EXCLUSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EgressOnlyInternetGatewayExclusion").getter(ModifyVpcEncryptionControlRequest.getter(ModifyVpcEncryptionControlRequest::egressOnlyInternetGatewayExclusionAsString)).setter(ModifyVpcEncryptionControlRequest.setter(Builder::egressOnlyInternetGatewayExclusion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewayExclusion").unmarshallLocationName("EgressOnlyInternetGatewayExclusion").build()}).build();
    private static final SdkField<String> NAT_GATEWAY_EXCLUSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NatGatewayExclusion").getter(ModifyVpcEncryptionControlRequest.getter(ModifyVpcEncryptionControlRequest::natGatewayExclusionAsString)).setter(ModifyVpcEncryptionControlRequest.setter(Builder::natGatewayExclusion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayExclusion").unmarshallLocationName("NatGatewayExclusion").build()}).build();
    private static final SdkField<String> VIRTUAL_PRIVATE_GATEWAY_EXCLUSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VirtualPrivateGatewayExclusion").getter(ModifyVpcEncryptionControlRequest.getter(ModifyVpcEncryptionControlRequest::virtualPrivateGatewayExclusionAsString)).setter(ModifyVpcEncryptionControlRequest.setter(Builder::virtualPrivateGatewayExclusion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualPrivateGatewayExclusion").unmarshallLocationName("VirtualPrivateGatewayExclusion").build()}).build();
    private static final SdkField<String> VPC_PEERING_EXCLUSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcPeeringExclusion").getter(ModifyVpcEncryptionControlRequest.getter(ModifyVpcEncryptionControlRequest::vpcPeeringExclusionAsString)).setter(ModifyVpcEncryptionControlRequest.setter(Builder::vpcPeeringExclusion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringExclusion").unmarshallLocationName("VpcPeeringExclusion").build()}).build();
    private static final SdkField<String> LAMBDA_EXCLUSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LambdaExclusion").getter(ModifyVpcEncryptionControlRequest.getter(ModifyVpcEncryptionControlRequest::lambdaExclusionAsString)).setter(ModifyVpcEncryptionControlRequest.setter(Builder::lambdaExclusion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaExclusion").unmarshallLocationName("LambdaExclusion").build()}).build();
    private static final SdkField<String> VPC_LATTICE_EXCLUSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcLatticeExclusion").getter(ModifyVpcEncryptionControlRequest.getter(ModifyVpcEncryptionControlRequest::vpcLatticeExclusionAsString)).setter(ModifyVpcEncryptionControlRequest.setter(Builder::vpcLatticeExclusion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcLatticeExclusion").unmarshallLocationName("VpcLatticeExclusion").build()}).build();
    private static final SdkField<String> ELASTIC_FILE_SYSTEM_EXCLUSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticFileSystemExclusion").getter(ModifyVpcEncryptionControlRequest.getter(ModifyVpcEncryptionControlRequest::elasticFileSystemExclusionAsString)).setter(ModifyVpcEncryptionControlRequest.setter(Builder::elasticFileSystemExclusion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticFileSystemExclusion").unmarshallLocationName("ElasticFileSystemExclusion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, VPC_ENCRYPTION_CONTROL_ID_FIELD, MODE_FIELD, INTERNET_GATEWAY_EXCLUSION_FIELD, EGRESS_ONLY_INTERNET_GATEWAY_EXCLUSION_FIELD, NAT_GATEWAY_EXCLUSION_FIELD, VIRTUAL_PRIVATE_GATEWAY_EXCLUSION_FIELD, VPC_PEERING_EXCLUSION_FIELD, LAMBDA_EXCLUSION_FIELD, VPC_LATTICE_EXCLUSION_FIELD, ELASTIC_FILE_SYSTEM_EXCLUSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyVpcEncryptionControlRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String vpcEncryptionControlId;
    private final String mode;
    private final String internetGatewayExclusion;
    private final String egressOnlyInternetGatewayExclusion;
    private final String natGatewayExclusion;
    private final String virtualPrivateGatewayExclusion;
    private final String vpcPeeringExclusion;
    private final String lambdaExclusion;
    private final String vpcLatticeExclusion;
    private final String elasticFileSystemExclusion;

    private ModifyVpcEncryptionControlRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.vpcEncryptionControlId = builder.vpcEncryptionControlId;
        this.mode = builder.mode;
        this.internetGatewayExclusion = builder.internetGatewayExclusion;
        this.egressOnlyInternetGatewayExclusion = builder.egressOnlyInternetGatewayExclusion;
        this.natGatewayExclusion = builder.natGatewayExclusion;
        this.virtualPrivateGatewayExclusion = builder.virtualPrivateGatewayExclusion;
        this.vpcPeeringExclusion = builder.vpcPeeringExclusion;
        this.lambdaExclusion = builder.lambdaExclusion;
        this.vpcLatticeExclusion = builder.vpcLatticeExclusion;
        this.elasticFileSystemExclusion = builder.elasticFileSystemExclusion;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String vpcEncryptionControlId() {
        return this.vpcEncryptionControlId;
    }

    public final VpcEncryptionControlMode mode() {
        return VpcEncryptionControlMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final VpcEncryptionControlExclusionStateInput internetGatewayExclusion() {
        return VpcEncryptionControlExclusionStateInput.fromValue(this.internetGatewayExclusion);
    }

    public final String internetGatewayExclusionAsString() {
        return this.internetGatewayExclusion;
    }

    public final VpcEncryptionControlExclusionStateInput egressOnlyInternetGatewayExclusion() {
        return VpcEncryptionControlExclusionStateInput.fromValue(this.egressOnlyInternetGatewayExclusion);
    }

    public final String egressOnlyInternetGatewayExclusionAsString() {
        return this.egressOnlyInternetGatewayExclusion;
    }

    public final VpcEncryptionControlExclusionStateInput natGatewayExclusion() {
        return VpcEncryptionControlExclusionStateInput.fromValue(this.natGatewayExclusion);
    }

    public final String natGatewayExclusionAsString() {
        return this.natGatewayExclusion;
    }

    public final VpcEncryptionControlExclusionStateInput virtualPrivateGatewayExclusion() {
        return VpcEncryptionControlExclusionStateInput.fromValue(this.virtualPrivateGatewayExclusion);
    }

    public final String virtualPrivateGatewayExclusionAsString() {
        return this.virtualPrivateGatewayExclusion;
    }

    public final VpcEncryptionControlExclusionStateInput vpcPeeringExclusion() {
        return VpcEncryptionControlExclusionStateInput.fromValue(this.vpcPeeringExclusion);
    }

    public final String vpcPeeringExclusionAsString() {
        return this.vpcPeeringExclusion;
    }

    public final VpcEncryptionControlExclusionStateInput lambdaExclusion() {
        return VpcEncryptionControlExclusionStateInput.fromValue(this.lambdaExclusion);
    }

    public final String lambdaExclusionAsString() {
        return this.lambdaExclusion;
    }

    public final VpcEncryptionControlExclusionStateInput vpcLatticeExclusion() {
        return VpcEncryptionControlExclusionStateInput.fromValue(this.vpcLatticeExclusion);
    }

    public final String vpcLatticeExclusionAsString() {
        return this.vpcLatticeExclusion;
    }

    public final VpcEncryptionControlExclusionStateInput elasticFileSystemExclusion() {
        return VpcEncryptionControlExclusionStateInput.fromValue(this.elasticFileSystemExclusion);
    }

    public final String elasticFileSystemExclusionAsString() {
        return this.elasticFileSystemExclusion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEncryptionControlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.internetGatewayExclusionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressOnlyInternetGatewayExclusionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayExclusionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualPrivateGatewayExclusionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringExclusionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaExclusionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcLatticeExclusionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticFileSystemExclusionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEncryptionControlRequest)) {
            return false;
        }
        ModifyVpcEncryptionControlRequest other = (ModifyVpcEncryptionControlRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.vpcEncryptionControlId(), other.vpcEncryptionControlId()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.internetGatewayExclusionAsString(), other.internetGatewayExclusionAsString()) && Objects.equals(this.egressOnlyInternetGatewayExclusionAsString(), other.egressOnlyInternetGatewayExclusionAsString()) && Objects.equals(this.natGatewayExclusionAsString(), other.natGatewayExclusionAsString()) && Objects.equals(this.virtualPrivateGatewayExclusionAsString(), other.virtualPrivateGatewayExclusionAsString()) && Objects.equals(this.vpcPeeringExclusionAsString(), other.vpcPeeringExclusionAsString()) && Objects.equals(this.lambdaExclusionAsString(), other.lambdaExclusionAsString()) && Objects.equals(this.vpcLatticeExclusionAsString(), other.vpcLatticeExclusionAsString()) && Objects.equals(this.elasticFileSystemExclusionAsString(), other.elasticFileSystemExclusionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVpcEncryptionControlRequest").add("DryRun", (Object)this.dryRun()).add("VpcEncryptionControlId", (Object)this.vpcEncryptionControlId()).add("Mode", (Object)this.modeAsString()).add("InternetGatewayExclusion", (Object)this.internetGatewayExclusionAsString()).add("EgressOnlyInternetGatewayExclusion", (Object)this.egressOnlyInternetGatewayExclusionAsString()).add("NatGatewayExclusion", (Object)this.natGatewayExclusionAsString()).add("VirtualPrivateGatewayExclusion", (Object)this.virtualPrivateGatewayExclusionAsString()).add("VpcPeeringExclusion", (Object)this.vpcPeeringExclusionAsString()).add("LambdaExclusion", (Object)this.lambdaExclusionAsString()).add("VpcLatticeExclusion", (Object)this.vpcLatticeExclusionAsString()).add("ElasticFileSystemExclusion", (Object)this.elasticFileSystemExclusionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "VpcEncryptionControlId": {
                return Optional.ofNullable(clazz.cast(this.vpcEncryptionControlId()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "InternetGatewayExclusion": {
                return Optional.ofNullable(clazz.cast(this.internetGatewayExclusionAsString()));
            }
            case "EgressOnlyInternetGatewayExclusion": {
                return Optional.ofNullable(clazz.cast(this.egressOnlyInternetGatewayExclusionAsString()));
            }
            case "NatGatewayExclusion": {
                return Optional.ofNullable(clazz.cast(this.natGatewayExclusionAsString()));
            }
            case "VirtualPrivateGatewayExclusion": {
                return Optional.ofNullable(clazz.cast(this.virtualPrivateGatewayExclusionAsString()));
            }
            case "VpcPeeringExclusion": {
                return Optional.ofNullable(clazz.cast(this.vpcPeeringExclusionAsString()));
            }
            case "LambdaExclusion": {
                return Optional.ofNullable(clazz.cast(this.lambdaExclusionAsString()));
            }
            case "VpcLatticeExclusion": {
                return Optional.ofNullable(clazz.cast(this.vpcLatticeExclusionAsString()));
            }
            case "ElasticFileSystemExclusion": {
                return Optional.ofNullable(clazz.cast(this.elasticFileSystemExclusionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("VpcEncryptionControlId", VPC_ENCRYPTION_CONTROL_ID_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("InternetGatewayExclusion", INTERNET_GATEWAY_EXCLUSION_FIELD);
        map.put("EgressOnlyInternetGatewayExclusion", EGRESS_ONLY_INTERNET_GATEWAY_EXCLUSION_FIELD);
        map.put("NatGatewayExclusion", NAT_GATEWAY_EXCLUSION_FIELD);
        map.put("VirtualPrivateGatewayExclusion", VIRTUAL_PRIVATE_GATEWAY_EXCLUSION_FIELD);
        map.put("VpcPeeringExclusion", VPC_PEERING_EXCLUSION_FIELD);
        map.put("LambdaExclusion", LAMBDA_EXCLUSION_FIELD);
        map.put("VpcLatticeExclusion", VPC_LATTICE_EXCLUSION_FIELD);
        map.put("ElasticFileSystemExclusion", ELASTIC_FILE_SYSTEM_EXCLUSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEncryptionControlRequest, T> g) {
        return obj -> g.apply((ModifyVpcEncryptionControlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String vpcEncryptionControlId;
        private String mode;
        private String internetGatewayExclusion;
        private String egressOnlyInternetGatewayExclusion;
        private String natGatewayExclusion;
        private String virtualPrivateGatewayExclusion;
        private String vpcPeeringExclusion;
        private String lambdaExclusion;
        private String vpcLatticeExclusion;
        private String elasticFileSystemExclusion;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEncryptionControlRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.vpcEncryptionControlId(model.vpcEncryptionControlId);
            this.mode(model.mode);
            this.internetGatewayExclusion(model.internetGatewayExclusion);
            this.egressOnlyInternetGatewayExclusion(model.egressOnlyInternetGatewayExclusion);
            this.natGatewayExclusion(model.natGatewayExclusion);
            this.virtualPrivateGatewayExclusion(model.virtualPrivateGatewayExclusion);
            this.vpcPeeringExclusion(model.vpcPeeringExclusion);
            this.lambdaExclusion(model.lambdaExclusion);
            this.vpcLatticeExclusion(model.vpcLatticeExclusion);
            this.elasticFileSystemExclusion(model.elasticFileSystemExclusion);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getVpcEncryptionControlId() {
            return this.vpcEncryptionControlId;
        }

        public final void setVpcEncryptionControlId(String vpcEncryptionControlId) {
            this.vpcEncryptionControlId = vpcEncryptionControlId;
        }

        @Override
        public final Builder vpcEncryptionControlId(String vpcEncryptionControlId) {
            this.vpcEncryptionControlId = vpcEncryptionControlId;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(VpcEncryptionControlMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getInternetGatewayExclusion() {
            return this.internetGatewayExclusion;
        }

        public final void setInternetGatewayExclusion(String internetGatewayExclusion) {
            this.internetGatewayExclusion = internetGatewayExclusion;
        }

        @Override
        public final Builder internetGatewayExclusion(String internetGatewayExclusion) {
            this.internetGatewayExclusion = internetGatewayExclusion;
            return this;
        }

        @Override
        public final Builder internetGatewayExclusion(VpcEncryptionControlExclusionStateInput internetGatewayExclusion) {
            this.internetGatewayExclusion(internetGatewayExclusion == null ? null : internetGatewayExclusion.toString());
            return this;
        }

        public final String getEgressOnlyInternetGatewayExclusion() {
            return this.egressOnlyInternetGatewayExclusion;
        }

        public final void setEgressOnlyInternetGatewayExclusion(String egressOnlyInternetGatewayExclusion) {
            this.egressOnlyInternetGatewayExclusion = egressOnlyInternetGatewayExclusion;
        }

        @Override
        public final Builder egressOnlyInternetGatewayExclusion(String egressOnlyInternetGatewayExclusion) {
            this.egressOnlyInternetGatewayExclusion = egressOnlyInternetGatewayExclusion;
            return this;
        }

        @Override
        public final Builder egressOnlyInternetGatewayExclusion(VpcEncryptionControlExclusionStateInput egressOnlyInternetGatewayExclusion) {
            this.egressOnlyInternetGatewayExclusion(egressOnlyInternetGatewayExclusion == null ? null : egressOnlyInternetGatewayExclusion.toString());
            return this;
        }

        public final String getNatGatewayExclusion() {
            return this.natGatewayExclusion;
        }

        public final void setNatGatewayExclusion(String natGatewayExclusion) {
            this.natGatewayExclusion = natGatewayExclusion;
        }

        @Override
        public final Builder natGatewayExclusion(String natGatewayExclusion) {
            this.natGatewayExclusion = natGatewayExclusion;
            return this;
        }

        @Override
        public final Builder natGatewayExclusion(VpcEncryptionControlExclusionStateInput natGatewayExclusion) {
            this.natGatewayExclusion(natGatewayExclusion == null ? null : natGatewayExclusion.toString());
            return this;
        }

        public final String getVirtualPrivateGatewayExclusion() {
            return this.virtualPrivateGatewayExclusion;
        }

        public final void setVirtualPrivateGatewayExclusion(String virtualPrivateGatewayExclusion) {
            this.virtualPrivateGatewayExclusion = virtualPrivateGatewayExclusion;
        }

        @Override
        public final Builder virtualPrivateGatewayExclusion(String virtualPrivateGatewayExclusion) {
            this.virtualPrivateGatewayExclusion = virtualPrivateGatewayExclusion;
            return this;
        }

        @Override
        public final Builder virtualPrivateGatewayExclusion(VpcEncryptionControlExclusionStateInput virtualPrivateGatewayExclusion) {
            this.virtualPrivateGatewayExclusion(virtualPrivateGatewayExclusion == null ? null : virtualPrivateGatewayExclusion.toString());
            return this;
        }

        public final String getVpcPeeringExclusion() {
            return this.vpcPeeringExclusion;
        }

        public final void setVpcPeeringExclusion(String vpcPeeringExclusion) {
            this.vpcPeeringExclusion = vpcPeeringExclusion;
        }

        @Override
        public final Builder vpcPeeringExclusion(String vpcPeeringExclusion) {
            this.vpcPeeringExclusion = vpcPeeringExclusion;
            return this;
        }

        @Override
        public final Builder vpcPeeringExclusion(VpcEncryptionControlExclusionStateInput vpcPeeringExclusion) {
            this.vpcPeeringExclusion(vpcPeeringExclusion == null ? null : vpcPeeringExclusion.toString());
            return this;
        }

        public final String getLambdaExclusion() {
            return this.lambdaExclusion;
        }

        public final void setLambdaExclusion(String lambdaExclusion) {
            this.lambdaExclusion = lambdaExclusion;
        }

        @Override
        public final Builder lambdaExclusion(String lambdaExclusion) {
            this.lambdaExclusion = lambdaExclusion;
            return this;
        }

        @Override
        public final Builder lambdaExclusion(VpcEncryptionControlExclusionStateInput lambdaExclusion) {
            this.lambdaExclusion(lambdaExclusion == null ? null : lambdaExclusion.toString());
            return this;
        }

        public final String getVpcLatticeExclusion() {
            return this.vpcLatticeExclusion;
        }

        public final void setVpcLatticeExclusion(String vpcLatticeExclusion) {
            this.vpcLatticeExclusion = vpcLatticeExclusion;
        }

        @Override
        public final Builder vpcLatticeExclusion(String vpcLatticeExclusion) {
            this.vpcLatticeExclusion = vpcLatticeExclusion;
            return this;
        }

        @Override
        public final Builder vpcLatticeExclusion(VpcEncryptionControlExclusionStateInput vpcLatticeExclusion) {
            this.vpcLatticeExclusion(vpcLatticeExclusion == null ? null : vpcLatticeExclusion.toString());
            return this;
        }

        public final String getElasticFileSystemExclusion() {
            return this.elasticFileSystemExclusion;
        }

        public final void setElasticFileSystemExclusion(String elasticFileSystemExclusion) {
            this.elasticFileSystemExclusion = elasticFileSystemExclusion;
        }

        @Override
        public final Builder elasticFileSystemExclusion(String elasticFileSystemExclusion) {
            this.elasticFileSystemExclusion = elasticFileSystemExclusion;
            return this;
        }

        @Override
        public final Builder elasticFileSystemExclusion(VpcEncryptionControlExclusionStateInput elasticFileSystemExclusion) {
            this.elasticFileSystemExclusion(elasticFileSystemExclusion == null ? null : elasticFileSystemExclusion.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEncryptionControlRequest build() {
            return new ModifyVpcEncryptionControlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpcEncryptionControlRequest> {
        public Builder dryRun(Boolean var1);

        public Builder vpcEncryptionControlId(String var1);

        public Builder mode(String var1);

        public Builder mode(VpcEncryptionControlMode var1);

        public Builder internetGatewayExclusion(String var1);

        public Builder internetGatewayExclusion(VpcEncryptionControlExclusionStateInput var1);

        public Builder egressOnlyInternetGatewayExclusion(String var1);

        public Builder egressOnlyInternetGatewayExclusion(VpcEncryptionControlExclusionStateInput var1);

        public Builder natGatewayExclusion(String var1);

        public Builder natGatewayExclusion(VpcEncryptionControlExclusionStateInput var1);

        public Builder virtualPrivateGatewayExclusion(String var1);

        public Builder virtualPrivateGatewayExclusion(VpcEncryptionControlExclusionStateInput var1);

        public Builder vpcPeeringExclusion(String var1);

        public Builder vpcPeeringExclusion(VpcEncryptionControlExclusionStateInput var1);

        public Builder lambdaExclusion(String var1);

        public Builder lambdaExclusion(VpcEncryptionControlExclusionStateInput var1);

        public Builder vpcLatticeExclusion(String var1);

        public Builder vpcLatticeExclusion(VpcEncryptionControlExclusionStateInput var1);

        public Builder elasticFileSystemExclusion(String var1);

        public Builder elasticFileSystemExclusion(VpcEncryptionControlExclusionStateInput var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

