/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRoute;

public class SearchTransitGatewayRoutesIterable
implements SdkIterable<SearchTransitGatewayRoutesResponse> {
    private final Ec2Client client;
    private final SearchTransitGatewayRoutesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchTransitGatewayRoutesIterable(Ec2Client client, SearchTransitGatewayRoutesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchTransitGatewayRoutesResponseFetcher();
    }

    public Iterator<SearchTransitGatewayRoutesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayRoute> routes() {
        Function<SearchTransitGatewayRoutesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routes() != null) {
                return response.routes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchTransitGatewayRoutesResponseFetcher
    implements SyncPageFetcher<SearchTransitGatewayRoutesResponse> {
        private SearchTransitGatewayRoutesResponseFetcher() {
        }

        public boolean hasNextPage(SearchTransitGatewayRoutesResponse previousPage) {
            return previousPage.additionalRoutesAvailable() != null && previousPage.additionalRoutesAvailable() != false;
        }

        public SearchTransitGatewayRoutesResponse nextPage(SearchTransitGatewayRoutesResponse previousPage) {
            if (previousPage == null) {
                return SearchTransitGatewayRoutesIterable.this.client.searchTransitGatewayRoutes(SearchTransitGatewayRoutesIterable.this.firstRequest);
            }
            return SearchTransitGatewayRoutesIterable.this.client.searchTransitGatewayRoutes((SearchTransitGatewayRoutesRequest)((Object)SearchTransitGatewayRoutesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

