/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainAssociation;

public class GetTransitGatewayMulticastDomainAssociationsPublisher
implements SdkPublisher<GetTransitGatewayMulticastDomainAssociationsResponse> {
    private final Ec2AsyncClient client;
    private final GetTransitGatewayMulticastDomainAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTransitGatewayMulticastDomainAssociationsPublisher(Ec2AsyncClient client, GetTransitGatewayMulticastDomainAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTransitGatewayMulticastDomainAssociationsPublisher(Ec2AsyncClient client, GetTransitGatewayMulticastDomainAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTransitGatewayMulticastDomainAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTransitGatewayMulticastDomainAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransitGatewayMulticastDomainAssociation> multicastDomainAssociations() {
        return this.flatMapIterable(response -> response.multicastDomainAssociations());
    }

    private class GetTransitGatewayMulticastDomainAssociationsResponseFetcher
    implements AsyncPageFetcher<GetTransitGatewayMulticastDomainAssociationsResponse> {
        private GetTransitGatewayMulticastDomainAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetTransitGatewayMulticastDomainAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetTransitGatewayMulticastDomainAssociationsResponse> nextPage(GetTransitGatewayMulticastDomainAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetTransitGatewayMulticastDomainAssociationsPublisher.this.client.getTransitGatewayMulticastDomainAssociations(GetTransitGatewayMulticastDomainAssociationsPublisher.this.firstRequest);
            }
            return GetTransitGatewayMulticastDomainAssociationsPublisher.this.client.getTransitGatewayMulticastDomainAssociations((GetTransitGatewayMulticastDomainAssociationsRequest)((Object)GetTransitGatewayMulticastDomainAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

