/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesResponse;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessInstance;

public class DescribeVerifiedAccessInstancesPublisher
implements SdkPublisher<DescribeVerifiedAccessInstancesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVerifiedAccessInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVerifiedAccessInstancesPublisher(Ec2AsyncClient client, DescribeVerifiedAccessInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVerifiedAccessInstancesPublisher(Ec2AsyncClient client, DescribeVerifiedAccessInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVerifiedAccessInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVerifiedAccessInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VerifiedAccessInstance> verifiedAccessInstances() {
        return this.flatMapIterable(response -> response.verifiedAccessInstances());
    }

    private class DescribeVerifiedAccessInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeVerifiedAccessInstancesResponse> {
        private DescribeVerifiedAccessInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVerifiedAccessInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVerifiedAccessInstancesResponse> nextPage(DescribeVerifiedAccessInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeVerifiedAccessInstancesPublisher.this.client.describeVerifiedAccessInstances(DescribeVerifiedAccessInstancesPublisher.this.firstRequest);
            }
            return DescribeVerifiedAccessInstancesPublisher.this.client.describeVerifiedAccessInstances((DescribeVerifiedAccessInstancesRequest)((Object)DescribeVerifiedAccessInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

