/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServerEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServerEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.RouteServerEndpoint;

public class DescribeRouteServerEndpointsPublisher
implements SdkPublisher<DescribeRouteServerEndpointsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeRouteServerEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRouteServerEndpointsPublisher(Ec2AsyncClient client, DescribeRouteServerEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRouteServerEndpointsPublisher(Ec2AsyncClient client, DescribeRouteServerEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRouteServerEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRouteServerEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RouteServerEndpoint> routeServerEndpoints() {
        return this.flatMapIterable(response -> response.routeServerEndpoints());
    }

    private class DescribeRouteServerEndpointsResponseFetcher
    implements AsyncPageFetcher<DescribeRouteServerEndpointsResponse> {
        private DescribeRouteServerEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRouteServerEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRouteServerEndpointsResponse> nextPage(DescribeRouteServerEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRouteServerEndpointsPublisher.this.client.describeRouteServerEndpoints(DescribeRouteServerEndpointsPublisher.this.firstRequest);
            }
            return DescribeRouteServerEndpointsPublisher.this.client.describeRouteServerEndpoints((DescribeRouteServerEndpointsRequest)((Object)DescribeRouteServerEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

