/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeImageUsageReportEntriesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImageUsageReportEntriesResponse;
import software.amazon.awssdk.services.ec2.model.ImageUsageReportEntry;

public class DescribeImageUsageReportEntriesPublisher
implements SdkPublisher<DescribeImageUsageReportEntriesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeImageUsageReportEntriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeImageUsageReportEntriesPublisher(Ec2AsyncClient client, DescribeImageUsageReportEntriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeImageUsageReportEntriesPublisher(Ec2AsyncClient client, DescribeImageUsageReportEntriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeImageUsageReportEntriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeImageUsageReportEntriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImageUsageReportEntry> imageUsageReportEntries() {
        return this.flatMapIterable(response -> response.imageUsageReportEntries());
    }

    private class DescribeImageUsageReportEntriesResponseFetcher
    implements AsyncPageFetcher<DescribeImageUsageReportEntriesResponse> {
        private DescribeImageUsageReportEntriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImageUsageReportEntriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeImageUsageReportEntriesResponse> nextPage(DescribeImageUsageReportEntriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeImageUsageReportEntriesPublisher.this.client.describeImageUsageReportEntries(DescribeImageUsageReportEntriesPublisher.this.firstRequest);
            }
            return DescribeImageUsageReportEntriesPublisher.this.client.describeImageUsageReportEntries((DescribeImageUsageReportEntriesRequest)((Object)DescribeImageUsageReportEntriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

