/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse;
import software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeAnalysis;

public class DescribeNetworkInsightsAccessScopeAnalysesPublisher
implements SdkPublisher<DescribeNetworkInsightsAccessScopeAnalysesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeNetworkInsightsAccessScopeAnalysesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeNetworkInsightsAccessScopeAnalysesPublisher(Ec2AsyncClient client, DescribeNetworkInsightsAccessScopeAnalysesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeNetworkInsightsAccessScopeAnalysesPublisher(Ec2AsyncClient client, DescribeNetworkInsightsAccessScopeAnalysesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeNetworkInsightsAccessScopeAnalysesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeNetworkInsightsAccessScopeAnalysesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NetworkInsightsAccessScopeAnalysis> networkInsightsAccessScopeAnalyses() {
        return this.flatMapIterable(response -> response.networkInsightsAccessScopeAnalyses());
    }

    private class DescribeNetworkInsightsAccessScopeAnalysesResponseFetcher
    implements AsyncPageFetcher<DescribeNetworkInsightsAccessScopeAnalysesResponse> {
        private DescribeNetworkInsightsAccessScopeAnalysesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNetworkInsightsAccessScopeAnalysesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeNetworkInsightsAccessScopeAnalysesResponse> nextPage(DescribeNetworkInsightsAccessScopeAnalysesResponse previousPage) {
            if (previousPage == null) {
                return DescribeNetworkInsightsAccessScopeAnalysesPublisher.this.client.describeNetworkInsightsAccessScopeAnalyses(DescribeNetworkInsightsAccessScopeAnalysesPublisher.this.firstRequest);
            }
            return DescribeNetworkInsightsAccessScopeAnalysesPublisher.this.client.describeNetworkInsightsAccessScopeAnalyses((DescribeNetworkInsightsAccessScopeAnalysesRequest)((Object)DescribeNetworkInsightsAccessScopeAnalysesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

