/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroup;

public class SearchTransitGatewayMulticastGroupsPublisher
implements SdkPublisher<SearchTransitGatewayMulticastGroupsResponse> {
    private final Ec2AsyncClient client;
    private final SearchTransitGatewayMulticastGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchTransitGatewayMulticastGroupsPublisher(Ec2AsyncClient client, SearchTransitGatewayMulticastGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchTransitGatewayMulticastGroupsPublisher(Ec2AsyncClient client, SearchTransitGatewayMulticastGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchTransitGatewayMulticastGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchTransitGatewayMulticastGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransitGatewayMulticastGroup> multicastGroups() {
        return this.flatMapIterable(response -> response.multicastGroups());
    }

    private class SearchTransitGatewayMulticastGroupsResponseFetcher
    implements AsyncPageFetcher<SearchTransitGatewayMulticastGroupsResponse> {
        private SearchTransitGatewayMulticastGroupsResponseFetcher() {
        }

        public boolean hasNextPage(SearchTransitGatewayMulticastGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchTransitGatewayMulticastGroupsResponse> nextPage(SearchTransitGatewayMulticastGroupsResponse previousPage) {
            if (previousPage == null) {
                return SearchTransitGatewayMulticastGroupsPublisher.this.client.searchTransitGatewayMulticastGroups(SearchTransitGatewayMulticastGroupsPublisher.this.firstRequest);
            }
            return SearchTransitGatewayMulticastGroupsPublisher.this.client.searchTransitGatewayMulticastGroups((SearchTransitGatewayMulticastGroupsRequest)((Object)SearchTransitGatewayMulticastGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

