/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnection;

public class DescribeVpcPeeringConnectionsPublisher
implements SdkPublisher<DescribeVpcPeeringConnectionsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVpcPeeringConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVpcPeeringConnectionsPublisher(Ec2AsyncClient client, DescribeVpcPeeringConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVpcPeeringConnectionsPublisher(Ec2AsyncClient client, DescribeVpcPeeringConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVpcPeeringConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVpcPeeringConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VpcPeeringConnection> vpcPeeringConnections() {
        return this.flatMapIterable(response -> response.vpcPeeringConnections());
    }

    private class DescribeVpcPeeringConnectionsResponseFetcher
    implements AsyncPageFetcher<DescribeVpcPeeringConnectionsResponse> {
        private DescribeVpcPeeringConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcPeeringConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVpcPeeringConnectionsResponse> nextPage(DescribeVpcPeeringConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcPeeringConnectionsPublisher.this.client.describeVpcPeeringConnections(DescribeVpcPeeringConnectionsPublisher.this.firstRequest);
            }
            return DescribeVpcPeeringConnectionsPublisher.this.client.describeVpcPeeringConnections((DescribeVpcPeeringConnectionsRequest)((Object)DescribeVpcPeeringConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

