/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.ClassicLinkDnsSupport;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportResponse;

public class DescribeVpcClassicLinkDnsSupportPublisher
implements SdkPublisher<DescribeVpcClassicLinkDnsSupportResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVpcClassicLinkDnsSupportRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVpcClassicLinkDnsSupportPublisher(Ec2AsyncClient client, DescribeVpcClassicLinkDnsSupportRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVpcClassicLinkDnsSupportPublisher(Ec2AsyncClient client, DescribeVpcClassicLinkDnsSupportRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVpcClassicLinkDnsSupportResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVpcClassicLinkDnsSupportResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClassicLinkDnsSupport> vpcs() {
        return this.flatMapIterable(response -> response.vpcs());
    }

    private class DescribeVpcClassicLinkDnsSupportResponseFetcher
    implements AsyncPageFetcher<DescribeVpcClassicLinkDnsSupportResponse> {
        private DescribeVpcClassicLinkDnsSupportResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcClassicLinkDnsSupportResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVpcClassicLinkDnsSupportResponse> nextPage(DescribeVpcClassicLinkDnsSupportResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcClassicLinkDnsSupportPublisher.this.client.describeVpcClassicLinkDnsSupport(DescribeVpcClassicLinkDnsSupportPublisher.this.firstRequest);
            }
            return DescribeVpcClassicLinkDnsSupportPublisher.this.client.describeVpcClassicLinkDnsSupport((DescribeVpcClassicLinkDnsSupportRequest)((Object)DescribeVpcClassicLinkDnsSupportPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

