/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.VolumeModification;

public class DescribeVolumesModificationsPublisher
implements SdkPublisher<DescribeVolumesModificationsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVolumesModificationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVolumesModificationsPublisher(Ec2AsyncClient client, DescribeVolumesModificationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVolumesModificationsPublisher(Ec2AsyncClient client, DescribeVolumesModificationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVolumesModificationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVolumesModificationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VolumeModification> volumesModifications() {
        return this.flatMapIterable(response -> response.volumesModifications());
    }

    private class DescribeVolumesModificationsResponseFetcher
    implements AsyncPageFetcher<DescribeVolumesModificationsResponse> {
        private DescribeVolumesModificationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVolumesModificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVolumesModificationsResponse> nextPage(DescribeVolumesModificationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVolumesModificationsPublisher.this.client.describeVolumesModifications(DescribeVolumesModificationsPublisher.this.firstRequest);
            }
            return DescribeVolumesModificationsPublisher.this.client.describeVolumesModifications((DescribeVolumesModificationsRequest)((Object)DescribeVolumesModificationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

