/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsResponse;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorSession;

public class DescribeTrafficMirrorSessionsPublisher
implements SdkPublisher<DescribeTrafficMirrorSessionsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeTrafficMirrorSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTrafficMirrorSessionsPublisher(Ec2AsyncClient client, DescribeTrafficMirrorSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTrafficMirrorSessionsPublisher(Ec2AsyncClient client, DescribeTrafficMirrorSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTrafficMirrorSessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTrafficMirrorSessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrafficMirrorSession> trafficMirrorSessions() {
        return this.flatMapIterable(response -> response.trafficMirrorSessions());
    }

    private class DescribeTrafficMirrorSessionsResponseFetcher
    implements AsyncPageFetcher<DescribeTrafficMirrorSessionsResponse> {
        private DescribeTrafficMirrorSessionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrafficMirrorSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTrafficMirrorSessionsResponse> nextPage(DescribeTrafficMirrorSessionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrafficMirrorSessionsPublisher.this.client.describeTrafficMirrorSessions(DescribeTrafficMirrorSessionsPublisher.this.firstRequest);
            }
            return DescribeTrafficMirrorSessionsPublisher.this.client.describeTrafficMirrorSessions((DescribeTrafficMirrorSessionsRequest)((Object)DescribeTrafficMirrorSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

