/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.SecurityGroup;

public class DescribeSecurityGroupsPublisher
implements SdkPublisher<DescribeSecurityGroupsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeSecurityGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSecurityGroupsPublisher(Ec2AsyncClient client, DescribeSecurityGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSecurityGroupsPublisher(Ec2AsyncClient client, DescribeSecurityGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSecurityGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSecurityGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityGroup> securityGroups() {
        return this.flatMapIterable(response -> response.securityGroups());
    }

    private class DescribeSecurityGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeSecurityGroupsResponse> {
        private DescribeSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSecurityGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSecurityGroupsResponse> nextPage(DescribeSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSecurityGroupsPublisher.this.client.describeSecurityGroups(DescribeSecurityGroupsPublisher.this.firstRequest);
            }
            return DescribeSecurityGroupsPublisher.this.client.describeSecurityGroups((DescribeSecurityGroupsRequest)((Object)DescribeSecurityGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

