/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTable;

public class DescribeLocalGatewayRouteTablesPublisher
implements SdkPublisher<DescribeLocalGatewayRouteTablesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeLocalGatewayRouteTablesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLocalGatewayRouteTablesPublisher(Ec2AsyncClient client, DescribeLocalGatewayRouteTablesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLocalGatewayRouteTablesPublisher(Ec2AsyncClient client, DescribeLocalGatewayRouteTablesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLocalGatewayRouteTablesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLocalGatewayRouteTablesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LocalGatewayRouteTable> localGatewayRouteTables() {
        return this.flatMapIterable(response -> response.localGatewayRouteTables());
    }

    private class DescribeLocalGatewayRouteTablesResponseFetcher
    implements AsyncPageFetcher<DescribeLocalGatewayRouteTablesResponse> {
        private DescribeLocalGatewayRouteTablesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLocalGatewayRouteTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeLocalGatewayRouteTablesResponse> nextPage(DescribeLocalGatewayRouteTablesResponse previousPage) {
            if (previousPage == null) {
                return DescribeLocalGatewayRouteTablesPublisher.this.client.describeLocalGatewayRouteTables(DescribeLocalGatewayRouteTablesPublisher.this.firstRequest);
            }
            return DescribeLocalGatewayRouteTablesPublisher.this.client.describeLocalGatewayRouteTables((DescribeLocalGatewayRouteTablesRequest)((Object)DescribeLocalGatewayRouteTablesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

