/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPrefixListResolversRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPrefixListResolversResponse;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolver;

public class DescribeIpamPrefixListResolversPublisher
implements SdkPublisher<DescribeIpamPrefixListResolversResponse> {
    private final Ec2AsyncClient client;
    private final DescribeIpamPrefixListResolversRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeIpamPrefixListResolversPublisher(Ec2AsyncClient client, DescribeIpamPrefixListResolversRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeIpamPrefixListResolversPublisher(Ec2AsyncClient client, DescribeIpamPrefixListResolversRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeIpamPrefixListResolversResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeIpamPrefixListResolversResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamPrefixListResolver> ipamPrefixListResolvers() {
        return this.flatMapIterable(response -> response.ipamPrefixListResolvers());
    }

    private class DescribeIpamPrefixListResolversResponseFetcher
    implements AsyncPageFetcher<DescribeIpamPrefixListResolversResponse> {
        private DescribeIpamPrefixListResolversResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamPrefixListResolversResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeIpamPrefixListResolversResponse> nextPage(DescribeIpamPrefixListResolversResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamPrefixListResolversPublisher.this.client.describeIpamPrefixListResolvers(DescribeIpamPrefixListResolversPublisher.this.firstRequest);
            }
            return DescribeIpamPrefixListResolversPublisher.this.client.describeIpamPrefixListResolvers((DescribeIpamPrefixListResolversRequest)((Object)DescribeIpamPrefixListResolversPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

