/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityReservation;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse;

public class DescribeCapacityReservationsPublisher
implements SdkPublisher<DescribeCapacityReservationsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeCapacityReservationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCapacityReservationsPublisher(Ec2AsyncClient client, DescribeCapacityReservationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCapacityReservationsPublisher(Ec2AsyncClient client, DescribeCapacityReservationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCapacityReservationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCapacityReservationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapacityReservation> capacityReservations() {
        return this.flatMapIterable(response -> response.capacityReservations());
    }

    private class DescribeCapacityReservationsResponseFetcher
    implements AsyncPageFetcher<DescribeCapacityReservationsResponse> {
        private DescribeCapacityReservationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityReservationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCapacityReservationsResponse> nextPage(DescribeCapacityReservationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityReservationsPublisher.this.client.describeCapacityReservations(DescribeCapacityReservationsPublisher.this.firstRequest);
            }
            return DescribeCapacityReservationsPublisher.this.client.describeCapacityReservations((DescribeCapacityReservationsRequest)((Object)DescribeCapacityReservationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

