/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityBlock;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlocksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlocksResponse;

public class DescribeCapacityBlocksPublisher
implements SdkPublisher<DescribeCapacityBlocksResponse> {
    private final Ec2AsyncClient client;
    private final DescribeCapacityBlocksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCapacityBlocksPublisher(Ec2AsyncClient client, DescribeCapacityBlocksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCapacityBlocksPublisher(Ec2AsyncClient client, DescribeCapacityBlocksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCapacityBlocksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCapacityBlocksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapacityBlock> capacityBlocks() {
        return this.flatMapIterable(response -> response.capacityBlocks());
    }

    private class DescribeCapacityBlocksResponseFetcher
    implements AsyncPageFetcher<DescribeCapacityBlocksResponse> {
        private DescribeCapacityBlocksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityBlocksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCapacityBlocksResponse> nextPage(DescribeCapacityBlocksResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityBlocksPublisher.this.client.describeCapacityBlocks(DescribeCapacityBlocksPublisher.this.firstRequest);
            }
            return DescribeCapacityBlocksPublisher.this.client.describeCapacityBlocks((DescribeCapacityBlocksRequest)((Object)DescribeCapacityBlocksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

