/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.VolumeAttachmentState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeAttachment> {
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteOnTermination").getter(VolumeAttachment.getter(VolumeAttachment::deleteOnTermination)).setter(VolumeAttachment.setter(Builder::deleteOnTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").unmarshallLocationName("deleteOnTermination").build()}).build();
    private static final SdkField<String> ASSOCIATED_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedResource").getter(VolumeAttachment.getter(VolumeAttachment::associatedResource)).setter(VolumeAttachment.setter(Builder::associatedResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResource").unmarshallLocationName("associatedResource").build()}).build();
    private static final SdkField<String> INSTANCE_OWNING_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceOwningService").getter(VolumeAttachment.getter(VolumeAttachment::instanceOwningService)).setter(VolumeAttachment.setter(Builder::instanceOwningService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceOwningService").unmarshallLocationName("instanceOwningService").build()}).build();
    private static final SdkField<Integer> EBS_CARD_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EbsCardIndex").getter(VolumeAttachment.getter(VolumeAttachment::ebsCardIndex)).setter(VolumeAttachment.setter(Builder::ebsCardIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsCardIndex").unmarshallLocationName("ebsCardIndex").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(VolumeAttachment.getter(VolumeAttachment::volumeId)).setter(VolumeAttachment.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(VolumeAttachment.getter(VolumeAttachment::instanceId)).setter(VolumeAttachment.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Device").getter(VolumeAttachment.getter(VolumeAttachment::device)).setter(VolumeAttachment.setter(Builder::device)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Device").unmarshallLocationName("device").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(VolumeAttachment.getter(VolumeAttachment::stateAsString)).setter(VolumeAttachment.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<Instant> ATTACH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AttachTime").getter(VolumeAttachment.getter(VolumeAttachment::attachTime)).setter(VolumeAttachment.setter(Builder::attachTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTime").unmarshallLocationName("attachTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETE_ON_TERMINATION_FIELD, ASSOCIATED_RESOURCE_FIELD, INSTANCE_OWNING_SERVICE_FIELD, EBS_CARD_INDEX_FIELD, VOLUME_ID_FIELD, INSTANCE_ID_FIELD, DEVICE_FIELD, STATE_FIELD, ATTACH_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VolumeAttachment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean deleteOnTermination;
    private final String associatedResource;
    private final String instanceOwningService;
    private final Integer ebsCardIndex;
    private final String volumeId;
    private final String instanceId;
    private final String device;
    private final String state;
    private final Instant attachTime;

    private VolumeAttachment(BuilderImpl builder) {
        this.deleteOnTermination = builder.deleteOnTermination;
        this.associatedResource = builder.associatedResource;
        this.instanceOwningService = builder.instanceOwningService;
        this.ebsCardIndex = builder.ebsCardIndex;
        this.volumeId = builder.volumeId;
        this.instanceId = builder.instanceId;
        this.device = builder.device;
        this.state = builder.state;
        this.attachTime = builder.attachTime;
    }

    public final Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public final String associatedResource() {
        return this.associatedResource;
    }

    public final String instanceOwningService() {
        return this.instanceOwningService;
    }

    public final Integer ebsCardIndex() {
        return this.ebsCardIndex;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String device() {
        return this.device;
    }

    public final VolumeAttachmentState state() {
        return VolumeAttachmentState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant attachTime() {
        return this.attachTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceOwningService());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeAttachment)) {
            return false;
        }
        VolumeAttachment other = (VolumeAttachment)obj;
        return Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.associatedResource(), other.associatedResource()) && Objects.equals(this.instanceOwningService(), other.instanceOwningService()) && Objects.equals(this.ebsCardIndex(), other.ebsCardIndex()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.device(), other.device()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.attachTime(), other.attachTime());
    }

    public final String toString() {
        return ToString.builder((String)"VolumeAttachment").add("DeleteOnTermination", (Object)this.deleteOnTermination()).add("AssociatedResource", (Object)this.associatedResource()).add("InstanceOwningService", (Object)this.instanceOwningService()).add("EbsCardIndex", (Object)this.ebsCardIndex()).add("VolumeId", (Object)this.volumeId()).add("InstanceId", (Object)this.instanceId()).add("Device", (Object)this.device()).add("State", (Object)this.stateAsString()).add("AttachTime", (Object)this.attachTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
            case "AssociatedResource": {
                return Optional.ofNullable(clazz.cast(this.associatedResource()));
            }
            case "InstanceOwningService": {
                return Optional.ofNullable(clazz.cast(this.instanceOwningService()));
            }
            case "EbsCardIndex": {
                return Optional.ofNullable(clazz.cast(this.ebsCardIndex()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Device": {
                return Optional.ofNullable(clazz.cast(this.device()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "AttachTime": {
                return Optional.ofNullable(clazz.cast(this.attachTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        map.put("AssociatedResource", ASSOCIATED_RESOURCE_FIELD);
        map.put("InstanceOwningService", INSTANCE_OWNING_SERVICE_FIELD);
        map.put("EbsCardIndex", EBS_CARD_INDEX_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Device", DEVICE_FIELD);
        map.put("Status", STATE_FIELD);
        map.put("AttachTime", ATTACH_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VolumeAttachment, T> g) {
        return obj -> g.apply((VolumeAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean deleteOnTermination;
        private String associatedResource;
        private String instanceOwningService;
        private Integer ebsCardIndex;
        private String volumeId;
        private String instanceId;
        private String device;
        private String state;
        private Instant attachTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeAttachment model) {
            this.deleteOnTermination(model.deleteOnTermination);
            this.associatedResource(model.associatedResource);
            this.instanceOwningService(model.instanceOwningService);
            this.ebsCardIndex(model.ebsCardIndex);
            this.volumeId(model.volumeId);
            this.instanceId(model.instanceId);
            this.device(model.device);
            this.state(model.state);
            this.attachTime(model.attachTime);
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final String getAssociatedResource() {
            return this.associatedResource;
        }

        public final void setAssociatedResource(String associatedResource) {
            this.associatedResource = associatedResource;
        }

        @Override
        public final Builder associatedResource(String associatedResource) {
            this.associatedResource = associatedResource;
            return this;
        }

        public final String getInstanceOwningService() {
            return this.instanceOwningService;
        }

        public final void setInstanceOwningService(String instanceOwningService) {
            this.instanceOwningService = instanceOwningService;
        }

        @Override
        public final Builder instanceOwningService(String instanceOwningService) {
            this.instanceOwningService = instanceOwningService;
            return this;
        }

        public final Integer getEbsCardIndex() {
            return this.ebsCardIndex;
        }

        public final void setEbsCardIndex(Integer ebsCardIndex) {
            this.ebsCardIndex = ebsCardIndex;
        }

        @Override
        public final Builder ebsCardIndex(Integer ebsCardIndex) {
            this.ebsCardIndex = ebsCardIndex;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDevice() {
            return this.device;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VolumeAttachmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getAttachTime() {
            return this.attachTime;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public VolumeAttachment build() {
            return new VolumeAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeAttachment> {
        public Builder deleteOnTermination(Boolean var1);

        public Builder associatedResource(String var1);

        public Builder instanceOwningService(String var1);

        public Builder ebsCardIndex(Integer var1);

        public Builder volumeId(String var1);

        public Builder instanceId(String var1);

        public Builder device(String var1);

        public Builder state(String var1);

        public Builder state(VolumeAttachmentState var1);

        public Builder attachTime(Instant var1);
    }
}

