/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.GpuDeviceMemoryInfo;
import software.amazon.awssdk.services.ec2.model.WorkloadsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GpuDeviceInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GpuDeviceInfo> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GpuDeviceInfo.getter(GpuDeviceInfo::name)).setter(GpuDeviceInfo.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> MANUFACTURER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Manufacturer").getter(GpuDeviceInfo.getter(GpuDeviceInfo::manufacturer)).setter(GpuDeviceInfo.setter(Builder::manufacturer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manufacturer").unmarshallLocationName("manufacturer").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(GpuDeviceInfo.getter(GpuDeviceInfo::count)).setter(GpuDeviceInfo.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").unmarshallLocationName("count").build()}).build();
    private static final SdkField<Integer> LOGICAL_GPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LogicalGpuCount").getter(GpuDeviceInfo.getter(GpuDeviceInfo::logicalGpuCount)).setter(GpuDeviceInfo.setter(Builder::logicalGpuCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalGpuCount").unmarshallLocationName("logicalGpuCount").build()}).build();
    private static final SdkField<Double> GPU_PARTITION_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("GpuPartitionSize").getter(GpuDeviceInfo.getter(GpuDeviceInfo::gpuPartitionSize)).setter(GpuDeviceInfo.setter(Builder::gpuPartitionSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GpuPartitionSize").unmarshallLocationName("gpuPartitionSize").build()}).build();
    private static final SdkField<List<String>> WORKLOADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Workloads").getter(GpuDeviceInfo.getter(GpuDeviceInfo::workloads)).setter(GpuDeviceInfo.setter(Builder::workloads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadSet").unmarshallLocationName("workloadSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<GpuDeviceMemoryInfo> MEMORY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemoryInfo").getter(GpuDeviceInfo.getter(GpuDeviceInfo::memoryInfo)).setter(GpuDeviceInfo.setter(Builder::memoryInfo)).constructor(GpuDeviceMemoryInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryInfo").unmarshallLocationName("memoryInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MANUFACTURER_FIELD, COUNT_FIELD, LOGICAL_GPU_COUNT_FIELD, GPU_PARTITION_SIZE_FIELD, WORKLOADS_FIELD, MEMORY_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GpuDeviceInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String manufacturer;
    private final Integer count;
    private final Integer logicalGpuCount;
    private final Double gpuPartitionSize;
    private final List<String> workloads;
    private final GpuDeviceMemoryInfo memoryInfo;

    private GpuDeviceInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.manufacturer = builder.manufacturer;
        this.count = builder.count;
        this.logicalGpuCount = builder.logicalGpuCount;
        this.gpuPartitionSize = builder.gpuPartitionSize;
        this.workloads = builder.workloads;
        this.memoryInfo = builder.memoryInfo;
    }

    public final String name() {
        return this.name;
    }

    public final String manufacturer() {
        return this.manufacturer;
    }

    public final Integer count() {
        return this.count;
    }

    public final Integer logicalGpuCount() {
        return this.logicalGpuCount;
    }

    public final Double gpuPartitionSize() {
        return this.gpuPartitionSize;
    }

    public final boolean hasWorkloads() {
        return this.workloads != null && !(this.workloads instanceof SdkAutoConstructList);
    }

    public final List<String> workloads() {
        return this.workloads;
    }

    public final GpuDeviceMemoryInfo memoryInfo() {
        return this.memoryInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.manufacturer());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalGpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.gpuPartitionSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkloads() ? this.workloads() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GpuDeviceInfo)) {
            return false;
        }
        GpuDeviceInfo other = (GpuDeviceInfo)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.manufacturer(), other.manufacturer()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.logicalGpuCount(), other.logicalGpuCount()) && Objects.equals(this.gpuPartitionSize(), other.gpuPartitionSize()) && this.hasWorkloads() == other.hasWorkloads() && Objects.equals(this.workloads(), other.workloads()) && Objects.equals(this.memoryInfo(), other.memoryInfo());
    }

    public final String toString() {
        return ToString.builder((String)"GpuDeviceInfo").add("Name", (Object)this.name()).add("Manufacturer", (Object)this.manufacturer()).add("Count", (Object)this.count()).add("LogicalGpuCount", (Object)this.logicalGpuCount()).add("GpuPartitionSize", (Object)this.gpuPartitionSize()).add("Workloads", this.hasWorkloads() ? this.workloads() : null).add("MemoryInfo", (Object)this.memoryInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Manufacturer": {
                return Optional.ofNullable(clazz.cast(this.manufacturer()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "LogicalGpuCount": {
                return Optional.ofNullable(clazz.cast(this.logicalGpuCount()));
            }
            case "GpuPartitionSize": {
                return Optional.ofNullable(clazz.cast(this.gpuPartitionSize()));
            }
            case "Workloads": {
                return Optional.ofNullable(clazz.cast(this.workloads()));
            }
            case "MemoryInfo": {
                return Optional.ofNullable(clazz.cast(this.memoryInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Manufacturer", MANUFACTURER_FIELD);
        map.put("Count", COUNT_FIELD);
        map.put("LogicalGpuCount", LOGICAL_GPU_COUNT_FIELD);
        map.put("GpuPartitionSize", GPU_PARTITION_SIZE_FIELD);
        map.put("WorkloadSet", WORKLOADS_FIELD);
        map.put("MemoryInfo", MEMORY_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GpuDeviceInfo, T> g) {
        return obj -> g.apply((GpuDeviceInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String manufacturer;
        private Integer count;
        private Integer logicalGpuCount;
        private Double gpuPartitionSize;
        private List<String> workloads = DefaultSdkAutoConstructList.getInstance();
        private GpuDeviceMemoryInfo memoryInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GpuDeviceInfo model) {
            this.name(model.name);
            this.manufacturer(model.manufacturer);
            this.count(model.count);
            this.logicalGpuCount(model.logicalGpuCount);
            this.gpuPartitionSize(model.gpuPartitionSize);
            this.workloads(model.workloads);
            this.memoryInfo(model.memoryInfo);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getManufacturer() {
            return this.manufacturer;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        @Override
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Integer getLogicalGpuCount() {
            return this.logicalGpuCount;
        }

        public final void setLogicalGpuCount(Integer logicalGpuCount) {
            this.logicalGpuCount = logicalGpuCount;
        }

        @Override
        public final Builder logicalGpuCount(Integer logicalGpuCount) {
            this.logicalGpuCount = logicalGpuCount;
            return this;
        }

        public final Double getGpuPartitionSize() {
            return this.gpuPartitionSize;
        }

        public final void setGpuPartitionSize(Double gpuPartitionSize) {
            this.gpuPartitionSize = gpuPartitionSize;
        }

        @Override
        public final Builder gpuPartitionSize(Double gpuPartitionSize) {
            this.gpuPartitionSize = gpuPartitionSize;
            return this;
        }

        public final Collection<String> getWorkloads() {
            if (this.workloads instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workloads;
        }

        public final void setWorkloads(Collection<String> workloads) {
            this.workloads = WorkloadsListCopier.copy(workloads);
        }

        @Override
        public final Builder workloads(Collection<String> workloads) {
            this.workloads = WorkloadsListCopier.copy(workloads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloads(String ... workloads) {
            this.workloads(Arrays.asList(workloads));
            return this;
        }

        public final GpuDeviceMemoryInfo.Builder getMemoryInfo() {
            return this.memoryInfo != null ? this.memoryInfo.toBuilder() : null;
        }

        public final void setMemoryInfo(GpuDeviceMemoryInfo.BuilderImpl memoryInfo) {
            this.memoryInfo = memoryInfo != null ? memoryInfo.build() : null;
        }

        @Override
        public final Builder memoryInfo(GpuDeviceMemoryInfo memoryInfo) {
            this.memoryInfo = memoryInfo;
            return this;
        }

        public GpuDeviceInfo build() {
            return new GpuDeviceInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GpuDeviceInfo> {
        public Builder name(String var1);

        public Builder manufacturer(String var1);

        public Builder count(Integer var1);

        public Builder logicalGpuCount(Integer var1);

        public Builder gpuPartitionSize(Double var1);

        public Builder workloads(Collection<String> var1);

        public Builder workloads(String ... var1);

        public Builder memoryInfo(GpuDeviceMemoryInfo var1);

        default public Builder memoryInfo(Consumer<GpuDeviceMemoryInfo.Builder> memoryInfo) {
            return this.memoryInfo((GpuDeviceMemoryInfo)((GpuDeviceMemoryInfo.Builder)GpuDeviceMemoryInfo.builder().applyMutation(memoryInfo)).build());
        }
    }
}

