/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.VpcEndpointConnection;

public class DescribeVpcEndpointConnectionsPublisher
implements SdkPublisher<DescribeVpcEndpointConnectionsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVpcEndpointConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVpcEndpointConnectionsPublisher(Ec2AsyncClient client, DescribeVpcEndpointConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVpcEndpointConnectionsPublisher(Ec2AsyncClient client, DescribeVpcEndpointConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVpcEndpointConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVpcEndpointConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VpcEndpointConnection> vpcEndpointConnections() {
        return this.flatMapIterable(response -> response.vpcEndpointConnections());
    }

    private class DescribeVpcEndpointConnectionsResponseFetcher
    implements AsyncPageFetcher<DescribeVpcEndpointConnectionsResponse> {
        private DescribeVpcEndpointConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcEndpointConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVpcEndpointConnectionsResponse> nextPage(DescribeVpcEndpointConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcEndpointConnectionsPublisher.this.client.describeVpcEndpointConnections(DescribeVpcEndpointConnectionsPublisher.this.firstRequest);
            }
            return DescribeVpcEndpointConnectionsPublisher.this.client.describeVpcEndpointConnections((DescribeVpcEndpointConnectionsRequest)((Object)DescribeVpcEndpointConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

