/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TransferType {
    TIME_BASED("time-based"),
    STANDARD("standard"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TransferType> VALUE_MAP;
    private final String value;

    private TransferType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransferType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransferType> knownValues() {
        EnumSet<TransferType> knownValues = EnumSet.allOf(TransferType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TransferType.class, TransferType::toString);
    }
}

